/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import hapi.chart.ChartOuterClass;
import hapi.chart.ConfigOuterClass;
import hapi.chart.MetadataOuterClass;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.microbean.helm.chart.Charts;
import org.microbean.helm.chart.Configs;
import org.microbean.helm.chart.MapTree;
import org.microbean.helm.chart.MissingDependenciesException;
import org.microbean.helm.chart.Values;
import org.yaml.snakeyaml.Yaml;

public final class Requirements {
    private Collection<Dependency> dependencies;

    public final boolean isEmpty() {
        return this.dependencies == null || this.dependencies.isEmpty();
    }

    public final Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public final void setDependencies(Collection<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    private final void applyEnablementRules(Map<String, Object> values) {
        this.processTags(values);
        this.processConditions(values);
    }

    private final void processTags(Map<String, Object> values) {
        Collection<Dependency> dependencies = this.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                if (dependency == null) continue;
                dependency.processTags(values);
            }
        }
    }

    private final void processConditions(Map<String, Object> values) {
        Collection<Dependency> dependencies = this.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                if (dependency == null) continue;
                dependency.processConditions(values);
            }
        }
    }

    static final ChartOuterClass.Chart.Builder processImportValues(ChartOuterClass.Chart.Builder chartBuilder) {
        Objects.requireNonNull(chartBuilder);
        List<ChartOuterClass.Chart.Builder> flattenedCharts = Charts.flatten(chartBuilder);
        if (flattenedCharts != null) {
            assert (!flattenedCharts.isEmpty());
            ListIterator<ChartOuterClass.Chart.Builder> listIterator = flattenedCharts.listIterator(flattenedCharts.size());
            assert (listIterator != null);
            while (listIterator.hasPrevious()) {
                ChartOuterClass.Chart.Builder chart = listIterator.previous();
                assert (chart != null);
                Requirements.processSingleChartImportValues(chart);
            }
        }
        return chartBuilder;
    }

    private static final ChartOuterClass.Chart.Builder processSingleChartImportValues(ChartOuterClass.Chart.Builder chartBuilder) {
        Collection<Dependency> dependencies;
        Objects.requireNonNull(chartBuilder);
        ChartOuterClass.Chart.Builder returnValue = null;
        Map<String, Object> canonicalValues = Configs.toDefaultValuesMap(chartBuilder);
        Map<String, Object> combinedValues = new HashMap<String, Object>();
        Requirements requirements = Requirements.fromChartOrBuilder(chartBuilder);
        if (requirements != null && (dependencies = requirements.getDependencies()) != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                if (dependency == null) continue;
                String dependencyName = dependency.getName();
                if (dependencyName == null) {
                    throw new IllegalStateException();
                }
                Collection<Object> importValues = dependency.getImportValues();
                if (importValues == null || importValues.isEmpty()) continue;
                ArrayList<Object> newImportValues = new ArrayList<Object>(importValues.size());
                for (Object importValue : importValues) {
                    String importValueChild;
                    if (importValue instanceof Map) {
                        Map importValueMap = (Map)importValue;
                        importValueChild = (String)importValueMap.get("child");
                        String importValueParent = (String)importValueMap.get("parent");
                        HashMap<String, String> newMap = new HashMap<String, String>();
                        newMap.put("child", importValueChild);
                        newMap.put("parent", importValueParent);
                        newImportValues.add(newMap);
                        Map<String, Object> vv = MapTree.newMapChain(importValueParent, Requirements.getMap(canonicalValues, dependencyName + "." + importValueChild));
                        combinedValues = Values.coalesceMaps(vv, canonicalValues);
                        continue;
                    }
                    if (!(importValue instanceof String)) continue;
                    String importValueString = (String)importValue;
                    importValueChild = "exports." + importValueString;
                    HashMap<String, String> newMap = new HashMap<String, String>();
                    newMap.put("child", importValueChild);
                    newMap.put("parent", ".");
                    newImportValues.add(newMap);
                    combinedValues = Values.coalesceMaps(Requirements.getMap(canonicalValues, dependencyName + "." + importValueChild), combinedValues);
                }
                dependency.setImportValues(newImportValues);
            }
        }
        combinedValues = Values.coalesceMaps(canonicalValues, combinedValues);
        assert (combinedValues != null);
        String yaml = new Yaml().dump(combinedValues);
        assert (yaml != null);
        ConfigOuterClass.Config.Builder configBuilder = chartBuilder.getValuesBuilder();
        assert (configBuilder != null);
        configBuilder.setRaw(yaml);
        returnValue = chartBuilder;
        assert (returnValue != null);
        return returnValue;
    }

    private static final Map<String, Object> getMap(Map<String, Object> map, String dotSeparatedPath) {
        Map<String, Object> returnValue = map == null || dotSeparatedPath == null || dotSeparatedPath.isEmpty() || map.isEmpty() ? null : new MapTree(map).getMap(dotSeparatedPath);
        return returnValue;
    }

    public static final Requirements fromChartOrBuilder(ChartOuterClass.ChartOrBuilder chart) {
        List<Any> files;
        Requirements returnValue = null;
        if (chart != null && (files = chart.getFilesList()) != null && !files.isEmpty()) {
            Yaml yaml = new Yaml();
            for (Any file : files) {
                String yamlString;
                ByteString fileContents;
                if (file == null || !"requirements.yaml".equals(file.getTypeUrl()) || (fileContents = file.getValue()) == null || (yamlString = fileContents.toStringUtf8()) == null) continue;
                returnValue = (Requirements)yaml.loadAs(yamlString, Requirements.class);
                assert (returnValue != null);
            }
        }
        return returnValue;
    }

    public static final ChartOuterClass.Chart.Builder apply(ChartOuterClass.Chart.Builder chartBuilder, ConfigOuterClass.ConfigOrBuilder userSuppliedValues) {
        return Requirements.apply(chartBuilder, userSuppliedValues, true);
    }

    static final ChartOuterClass.Chart.Builder apply(ChartOuterClass.Chart.Builder chartBuilder, ConfigOuterClass.ConfigOrBuilder userSuppliedValues, boolean topLevel) {
        List<ChartOuterClass.Chart.Builder> existingSubcharts;
        Collection<Dependency> requirementsDependencies;
        Objects.requireNonNull(chartBuilder);
        Requirements requirements = Requirements.fromChartOrBuilder(chartBuilder);
        if (!(requirements == null || requirements.isEmpty() || (requirementsDependencies = requirements.getDependencies()) == null || requirementsDependencies.isEmpty() || (existingSubcharts = chartBuilder.getDependenciesBuilderList()) == null || existingSubcharts.isEmpty())) {
            ArrayList<Dependency> missingSubcharts = null;
            for (Dependency dependency : requirementsDependencies) {
                if (dependency == null) continue;
                boolean dependencySelectsAtLeastOneSubchart = false;
                for (ChartOuterClass.Chart.Builder subchart : existingSubcharts) {
                    if (subchart == null) continue;
                    dependencySelectsAtLeastOneSubchart = dependencySelectsAtLeastOneSubchart || dependency.selects(subchart);
                    dependency.adjustName(subchart);
                }
                if (topLevel && !dependencySelectsAtLeastOneSubchart) {
                    if (missingSubcharts == null) {
                        missingSubcharts = new ArrayList<Dependency>();
                    }
                    missingSubcharts.add(dependency);
                } else {
                    dependency.setNameToAlias();
                }
                assert (dependency.isEnabled());
            }
            if (missingSubcharts != null && !missingSubcharts.isEmpty()) {
                throw new MissingDependenciesException((Collection<? extends Dependency>)missingSubcharts);
            }
            Map<String, Object> chartValuesMap = Configs.toValuesMap((ChartOuterClass.ChartOrBuilder)chartBuilder, userSuppliedValues);
            assert (chartValuesMap != null);
            requirements.applyEnablementRules(chartValuesMap);
            String userSuppliedValuesYaml = chartValuesMap.isEmpty() ? "" : new Yaml().dump(chartValuesMap);
            assert (userSuppliedValuesYaml != null);
            ConfigOuterClass.Config.Builder configBuilder = ConfigOuterClass.Config.newBuilder();
            assert (configBuilder != null);
            configBuilder.setRaw(userSuppliedValuesYaml);
            block2: for (int i = 0; i < chartBuilder.getDependenciesCount(); ++i) {
                ChartOuterClass.Chart.Builder subchart;
                subchart = chartBuilder.getDependenciesBuilder(i);
                for (Dependency dependency : requirementsDependencies) {
                    if (dependency == null || dependency.isEnabled() || !dependency.selects(subchart)) continue;
                    chartBuilder.removeDependencies(i--);
                    continue block2;
                }
                Requirements.apply(subchart, configBuilder, false);
            }
        }
        ChartOuterClass.Chart.Builder returnValue = topLevel ? Requirements.processImportValues(chartBuilder) : chartBuilder;
        return returnValue;
    }

    public static final class Dependency {
        private static final Pattern commaSplitPattern = Pattern.compile("\\s*,\\s*");
        private String name;
        private String version;
        private String repository;
        private String condition;
        private Collection<String> tags;
        private boolean enabled;
        private Collection<Object> importValues;
        private String alias;

        public Dependency() {
            this.setEnabled(true);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        public final Collection<String> getTags() {
            return this.tags;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = tags;
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Object> getImportValues() {
            return this.importValues;
        }

        public final void setImportValues(Collection<Object> importValues) {
            this.importValues = importValues;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final boolean selects(ChartOuterClass.ChartOrBuilder chart) {
            if (chart == null) {
                return false;
            }
            return this.selects(chart.getMetadata());
        }

        private final boolean selects(MetadataOuterClass.MetadataOrBuilder metadata) {
            boolean returnValue = metadata == null ? this.selects(null, null) : this.selects(metadata.getName(), metadata.getVersion());
            return returnValue;
        }

        private final boolean selects(String name, String versionString) {
            String myName = this.getName();
            if (myName == null ? name != null : !myName.equals(name)) {
                return false;
            }
            String myVersion = this.getVersion();
            if (myVersion == null) {
                if (versionString != null) {
                    return false;
                }
            } else {
                Version version = Version.valueOf((String)myVersion);
                assert (version != null);
                Parser parser = ExpressionParser.newInstance();
                assert (parser != null);
                Expression semVerConstraint = (Expression)parser.parse(versionString);
                assert (semVerConstraint != null);
                if (!version.satisfies(semVerConstraint)) {
                    return false;
                }
            }
            return true;
        }

        final boolean adjustName(ChartOuterClass.Chart.Builder subchart) {
            String alias;
            boolean returnValue = false;
            if (subchart != null && this.selects(subchart) && (alias = this.getAlias()) != null && !alias.isEmpty() && subchart.hasMetadata()) {
                MetadataOuterClass.Metadata.Builder subchartMetadataBuilder = subchart.getMetadataBuilder();
                assert (subchartMetadataBuilder != null);
                if (!alias.equals(subchartMetadataBuilder.getName())) {
                    subchartMetadataBuilder.setName(alias);
                    returnValue = true;
                }
            }
            return returnValue;
        }

        final boolean setNameToAlias() {
            boolean returnValue = false;
            String alias = this.getAlias();
            if (alias != null && !alias.isEmpty() && !alias.equals(this.getName())) {
                this.setName(alias);
                returnValue = true;
            }
            return returnValue;
        }

        final void processTags(Map<String, Object> values) {
            Object tagsObject;
            if (values != null && (tagsObject = values.get("tags")) instanceof Map) {
                Map tags = (Map)tagsObject;
                Collection<String> myTags = this.getTags();
                if (myTags != null && !myTags.isEmpty()) {
                    boolean explicitlyTrue = false;
                    boolean explicitlyFalse = false;
                    for (String myTag : myTags) {
                        Object tagValue = tags.get(myTag);
                        if (Boolean.TRUE.equals(tagValue)) {
                            explicitlyTrue = true;
                            continue;
                        }
                        if (!Boolean.FALSE.equals(tagValue)) continue;
                        explicitlyFalse = true;
                    }
                    if (explicitlyFalse) {
                        if (!explicitlyTrue) {
                            this.setEnabled(false);
                        }
                    } else {
                        this.setEnabled(explicitlyTrue);
                    }
                }
            }
        }

        final void processConditions(Map<String, Object> values) {
            if (values != null && !values.isEmpty()) {
                String[] conditions;
                MapTree mapTree = new MapTree(values);
                boolean explicitlyTrue = false;
                boolean explicitlyFalse = false;
                String conditionString = this.getCondition();
                if (conditionString != null && (conditions = commaSplitPattern.split(conditionString = conditionString.trim())) != null && conditions.length > 0) {
                    for (String condition : conditions) {
                        if (condition == null || condition.isEmpty()) continue;
                        Object conditionValue = mapTree.get(condition, Object.class);
                        if (Boolean.TRUE.equals(conditionValue)) {
                            explicitlyTrue = true;
                            continue;
                        }
                        if (Boolean.FALSE.equals(conditionValue)) {
                            explicitlyFalse = true;
                            continue;
                        }
                        if (conditionValue != null) break;
                    }
                }
                if (explicitlyFalse) {
                    if (!explicitlyTrue) {
                        this.setEnabled(false);
                    }
                } else if (explicitlyTrue) {
                    this.setEnabled(true);
                }
            }
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            String name = this.getName();
            if (name == null) {
                sb.append("Unnamed");
            } else {
                sb.append((Object)name);
            }
            String alias = this.getAlias();
            if (alias != null && !alias.isEmpty()) {
                sb.append(" (").append(alias).append(")");
            }
            sb.append(" ");
            sb.append(this.getVersion());
            return sb.toString();
        }
    }

    public static final class DependencyBeanInfo
    extends SimpleBeanInfo {
        private final Collection<? extends PropertyDescriptor> propertyDescriptors;

        public DependencyBeanInfo() throws IntrospectionException {
            ArrayList<? extends PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
            propertyDescriptors.add(new PropertyDescriptor("name", Dependency.class));
            propertyDescriptors.add(new PropertyDescriptor("version", Dependency.class));
            propertyDescriptors.add(new PropertyDescriptor("repository", Dependency.class));
            propertyDescriptors.add(new PropertyDescriptor("condition", Dependency.class));
            propertyDescriptors.add(new PropertyDescriptor("tags", Dependency.class));
            propertyDescriptors.add(new PropertyDescriptor("import-values", Dependency.class, "getImportValues", "setImportValues"));
            propertyDescriptors.add(new PropertyDescriptor("alias", Dependency.class));
            this.propertyDescriptors = propertyDescriptors;
        }

        @Override
        public final PropertyDescriptor[] getPropertyDescriptors() {
            return this.propertyDescriptors.toArray(new PropertyDescriptor[this.propertyDescriptors.size()]);
        }
    }
}

