package hapi.services.tiller;

import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 * <pre>
 * ReleaseService is the service that a helm application uses to mutate,
 * query, and manage releases.
 *		Release: A named installation composed of a chart and
 * 				 config. At any given time a release has one
 *				 chart and one config.
 *		Config:  A config is a YAML file that supplies values
 *				 to the parametrizable templates of a chart.
 *		Chart:   A chart is a helm package that contains
 *				 metadata, a default config, zero or more
 *				 optionally parameterizable templates, and
 *				 zero or more charts (dependencies).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.7.0)",
    comments = "Source: hapi/services/tiller.proto")
public final class ReleaseServiceGrpc {

  private ReleaseServiceGrpc() {}

  public static final String SERVICE_NAME = "hapi.services.tiller.ReleaseService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest,
      hapi.services.tiller.Tiller.ListReleasesResponse> METHOD_LIST_RELEASES =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.ListReleasesRequest, hapi.services.tiller.Tiller.ListReleasesResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "ListReleases"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.ListReleasesRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.ListReleasesResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("ListReleases"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest,
      hapi.services.tiller.Tiller.GetReleaseStatusResponse> METHOD_GET_RELEASE_STATUS =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetReleaseStatusRequest, hapi.services.tiller.Tiller.GetReleaseStatusResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "GetReleaseStatus"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetReleaseStatusRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetReleaseStatusResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetReleaseStatus"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest,
      hapi.services.tiller.Tiller.GetReleaseContentResponse> METHOD_GET_RELEASE_CONTENT =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetReleaseContentRequest, hapi.services.tiller.Tiller.GetReleaseContentResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "GetReleaseContent"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetReleaseContentRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetReleaseContentResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetReleaseContent"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest,
      hapi.services.tiller.Tiller.UpdateReleaseResponse> METHOD_UPDATE_RELEASE =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.UpdateReleaseRequest, hapi.services.tiller.Tiller.UpdateReleaseResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "UpdateRelease"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.UpdateReleaseRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.UpdateReleaseResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("UpdateRelease"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest,
      hapi.services.tiller.Tiller.InstallReleaseResponse> METHOD_INSTALL_RELEASE =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.InstallReleaseRequest, hapi.services.tiller.Tiller.InstallReleaseResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "InstallRelease"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.InstallReleaseRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.InstallReleaseResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("InstallRelease"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest,
      hapi.services.tiller.Tiller.UninstallReleaseResponse> METHOD_UNINSTALL_RELEASE =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.UninstallReleaseRequest, hapi.services.tiller.Tiller.UninstallReleaseResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "UninstallRelease"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.UninstallReleaseRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.UninstallReleaseResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("UninstallRelease"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest,
      hapi.services.tiller.Tiller.GetVersionResponse> METHOD_GET_VERSION =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetVersionRequest, hapi.services.tiller.Tiller.GetVersionResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "GetVersion"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetVersionRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetVersionResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetVersion"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest,
      hapi.services.tiller.Tiller.RollbackReleaseResponse> METHOD_ROLLBACK_RELEASE =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.RollbackReleaseRequest, hapi.services.tiller.Tiller.RollbackReleaseResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "RollbackRelease"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.RollbackReleaseRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.RollbackReleaseResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("RollbackRelease"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest,
      hapi.services.tiller.Tiller.GetHistoryResponse> METHOD_GET_HISTORY =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetHistoryRequest, hapi.services.tiller.Tiller.GetHistoryResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "GetHistory"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetHistoryRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.GetHistoryResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetHistory"))
          .build();
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest,
      hapi.services.tiller.Tiller.TestReleaseResponse> METHOD_RUN_RELEASE_TEST =
      io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.TestReleaseRequest, hapi.services.tiller.Tiller.TestReleaseResponse>newBuilder()
          .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
          .setFullMethodName(generateFullMethodName(
              "hapi.services.tiller.ReleaseService", "RunReleaseTest"))
          .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.TestReleaseRequest.getDefaultInstance()))
          .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
              hapi.services.tiller.Tiller.TestReleaseResponse.getDefaultInstance()))
          .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("RunReleaseTest"))
          .build();

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ReleaseServiceStub newStub(io.grpc.Channel channel) {
    return new ReleaseServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ReleaseServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ReleaseServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ReleaseServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ReleaseServiceFutureStub(channel);
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static abstract class ReleaseServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public void listReleases(hapi.services.tiller.Tiller.ListReleasesRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_LIST_RELEASES, responseObserver);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public void getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_RELEASE_STATUS, responseObserver);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public void getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_RELEASE_CONTENT, responseObserver);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public void updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_UPDATE_RELEASE, responseObserver);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public void installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_INSTALL_RELEASE, responseObserver);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public void uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_UNINSTALL_RELEASE, responseObserver);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public void getVersion(hapi.services.tiller.Tiller.GetVersionRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_VERSION, responseObserver);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public void rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_ROLLBACK_RELEASE, responseObserver);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public void getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_GET_HISTORY, responseObserver);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public void runReleaseTest(hapi.services.tiller.Tiller.TestReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(METHOD_RUN_RELEASE_TEST, responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            METHOD_LIST_RELEASES,
            asyncServerStreamingCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.ListReleasesRequest,
                hapi.services.tiller.Tiller.ListReleasesResponse>(
                  this, METHODID_LIST_RELEASES)))
          .addMethod(
            METHOD_GET_RELEASE_STATUS,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetReleaseStatusRequest,
                hapi.services.tiller.Tiller.GetReleaseStatusResponse>(
                  this, METHODID_GET_RELEASE_STATUS)))
          .addMethod(
            METHOD_GET_RELEASE_CONTENT,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetReleaseContentRequest,
                hapi.services.tiller.Tiller.GetReleaseContentResponse>(
                  this, METHODID_GET_RELEASE_CONTENT)))
          .addMethod(
            METHOD_UPDATE_RELEASE,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.UpdateReleaseRequest,
                hapi.services.tiller.Tiller.UpdateReleaseResponse>(
                  this, METHODID_UPDATE_RELEASE)))
          .addMethod(
            METHOD_INSTALL_RELEASE,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.InstallReleaseRequest,
                hapi.services.tiller.Tiller.InstallReleaseResponse>(
                  this, METHODID_INSTALL_RELEASE)))
          .addMethod(
            METHOD_UNINSTALL_RELEASE,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.UninstallReleaseRequest,
                hapi.services.tiller.Tiller.UninstallReleaseResponse>(
                  this, METHODID_UNINSTALL_RELEASE)))
          .addMethod(
            METHOD_GET_VERSION,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetVersionRequest,
                hapi.services.tiller.Tiller.GetVersionResponse>(
                  this, METHODID_GET_VERSION)))
          .addMethod(
            METHOD_ROLLBACK_RELEASE,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.RollbackReleaseRequest,
                hapi.services.tiller.Tiller.RollbackReleaseResponse>(
                  this, METHODID_ROLLBACK_RELEASE)))
          .addMethod(
            METHOD_GET_HISTORY,
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetHistoryRequest,
                hapi.services.tiller.Tiller.GetHistoryResponse>(
                  this, METHODID_GET_HISTORY)))
          .addMethod(
            METHOD_RUN_RELEASE_TEST,
            asyncServerStreamingCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.TestReleaseRequest,
                hapi.services.tiller.Tiller.TestReleaseResponse>(
                  this, METHODID_RUN_RELEASE_TEST)))
          .build();
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceStub extends io.grpc.stub.AbstractStub<ReleaseServiceStub> {
    private ReleaseServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public void listReleases(hapi.services.tiller.Tiller.ListReleasesRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_LIST_RELEASES, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public void getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_RELEASE_STATUS, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public void getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_RELEASE_CONTENT, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public void updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_UPDATE_RELEASE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public void installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_INSTALL_RELEASE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public void uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_UNINSTALL_RELEASE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public void getVersion(hapi.services.tiller.Tiller.GetVersionRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_VERSION, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public void rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_ROLLBACK_RELEASE, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public void getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(METHOD_GET_HISTORY, getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public void runReleaseTest(hapi.services.tiller.Tiller.TestReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(METHOD_RUN_RELEASE_TEST, getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceBlockingStub extends io.grpc.stub.AbstractStub<ReleaseServiceBlockingStub> {
    private ReleaseServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public java.util.Iterator<hapi.services.tiller.Tiller.ListReleasesResponse> listReleases(
        hapi.services.tiller.Tiller.ListReleasesRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_LIST_RELEASES, getCallOptions(), request);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetReleaseStatusResponse getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_RELEASE_STATUS, getCallOptions(), request);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetReleaseContentResponse getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_RELEASE_CONTENT, getCallOptions(), request);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public hapi.services.tiller.Tiller.UpdateReleaseResponse updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_UPDATE_RELEASE, getCallOptions(), request);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.InstallReleaseResponse installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_INSTALL_RELEASE, getCallOptions(), request);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.UninstallReleaseResponse uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_UNINSTALL_RELEASE, getCallOptions(), request);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetVersionResponse getVersion(hapi.services.tiller.Tiller.GetVersionRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_VERSION, getCallOptions(), request);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public hapi.services.tiller.Tiller.RollbackReleaseResponse rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_ROLLBACK_RELEASE, getCallOptions(), request);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetHistoryResponse getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request) {
      return blockingUnaryCall(
          getChannel(), METHOD_GET_HISTORY, getCallOptions(), request);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public java.util.Iterator<hapi.services.tiller.Tiller.TestReleaseResponse> runReleaseTest(
        hapi.services.tiller.Tiller.TestReleaseRequest request) {
      return blockingServerStreamingCall(
          getChannel(), METHOD_RUN_RELEASE_TEST, getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceFutureStub extends io.grpc.stub.AbstractStub<ReleaseServiceFutureStub> {
    private ReleaseServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetReleaseStatusResponse> getReleaseStatus(
        hapi.services.tiller.Tiller.GetReleaseStatusRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_RELEASE_STATUS, getCallOptions()), request);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetReleaseContentResponse> getReleaseContent(
        hapi.services.tiller.Tiller.GetReleaseContentRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_RELEASE_CONTENT, getCallOptions()), request);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.UpdateReleaseResponse> updateRelease(
        hapi.services.tiller.Tiller.UpdateReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_UPDATE_RELEASE, getCallOptions()), request);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.InstallReleaseResponse> installRelease(
        hapi.services.tiller.Tiller.InstallReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_INSTALL_RELEASE, getCallOptions()), request);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.UninstallReleaseResponse> uninstallRelease(
        hapi.services.tiller.Tiller.UninstallReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_UNINSTALL_RELEASE, getCallOptions()), request);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetVersionResponse> getVersion(
        hapi.services.tiller.Tiller.GetVersionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_VERSION, getCallOptions()), request);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.RollbackReleaseResponse> rollbackRelease(
        hapi.services.tiller.Tiller.RollbackReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_ROLLBACK_RELEASE, getCallOptions()), request);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetHistoryResponse> getHistory(
        hapi.services.tiller.Tiller.GetHistoryRequest request) {
      return futureUnaryCall(
          getChannel().newCall(METHOD_GET_HISTORY, getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_RELEASES = 0;
  private static final int METHODID_GET_RELEASE_STATUS = 1;
  private static final int METHODID_GET_RELEASE_CONTENT = 2;
  private static final int METHODID_UPDATE_RELEASE = 3;
  private static final int METHODID_INSTALL_RELEASE = 4;
  private static final int METHODID_UNINSTALL_RELEASE = 5;
  private static final int METHODID_GET_VERSION = 6;
  private static final int METHODID_ROLLBACK_RELEASE = 7;
  private static final int METHODID_GET_HISTORY = 8;
  private static final int METHODID_RUN_RELEASE_TEST = 9;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ReleaseServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ReleaseServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_RELEASES:
          serviceImpl.listReleases((hapi.services.tiller.Tiller.ListReleasesRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse>) responseObserver);
          break;
        case METHODID_GET_RELEASE_STATUS:
          serviceImpl.getReleaseStatus((hapi.services.tiller.Tiller.GetReleaseStatusRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse>) responseObserver);
          break;
        case METHODID_GET_RELEASE_CONTENT:
          serviceImpl.getReleaseContent((hapi.services.tiller.Tiller.GetReleaseContentRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse>) responseObserver);
          break;
        case METHODID_UPDATE_RELEASE:
          serviceImpl.updateRelease((hapi.services.tiller.Tiller.UpdateReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse>) responseObserver);
          break;
        case METHODID_INSTALL_RELEASE:
          serviceImpl.installRelease((hapi.services.tiller.Tiller.InstallReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse>) responseObserver);
          break;
        case METHODID_UNINSTALL_RELEASE:
          serviceImpl.uninstallRelease((hapi.services.tiller.Tiller.UninstallReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse>) responseObserver);
          break;
        case METHODID_GET_VERSION:
          serviceImpl.getVersion((hapi.services.tiller.Tiller.GetVersionRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse>) responseObserver);
          break;
        case METHODID_ROLLBACK_RELEASE:
          serviceImpl.rollbackRelease((hapi.services.tiller.Tiller.RollbackReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse>) responseObserver);
          break;
        case METHODID_GET_HISTORY:
          serviceImpl.getHistory((hapi.services.tiller.Tiller.GetHistoryRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse>) responseObserver);
          break;
        case METHODID_RUN_RELEASE_TEST:
          serviceImpl.runReleaseTest((hapi.services.tiller.Tiller.TestReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ReleaseServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ReleaseServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return hapi.services.tiller.Tiller.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ReleaseService");
    }
  }

  private static final class ReleaseServiceFileDescriptorSupplier
      extends ReleaseServiceBaseDescriptorSupplier {
    ReleaseServiceFileDescriptorSupplier() {}
  }

  private static final class ReleaseServiceMethodDescriptorSupplier
      extends ReleaseServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ReleaseServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ReleaseServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ReleaseServiceFileDescriptorSupplier())
              .addMethod(METHOD_LIST_RELEASES)
              .addMethod(METHOD_GET_RELEASE_STATUS)
              .addMethod(METHOD_GET_RELEASE_CONTENT)
              .addMethod(METHOD_UPDATE_RELEASE)
              .addMethod(METHOD_INSTALL_RELEASE)
              .addMethod(METHOD_UNINSTALL_RELEASE)
              .addMethod(METHOD_GET_VERSION)
              .addMethod(METHOD_ROLLBACK_RELEASE)
              .addMethod(METHOD_GET_HISTORY)
              .addMethod(METHOD_RUN_RELEASE_TEST)
              .build();
        }
      }
    }
    return result;
  }
}
