/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm;

import hapi.services.tiller.ReleaseServiceGrpc;
import hapi.services.tiller.Tiller;
import hapi.version.VersionOuterClass;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigAware;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.microbean.kubernetes.Pods;

public class Tiller
implements ConfigAware<Config>,
Closeable {
    public static final String VERSION = "2.7.0";
    public static final String DEFAULT_NAMESPACE = "kube-system";
    public static final int DEFAULT_PORT = 44134;
    public static final Map<String, String> DEFAULT_LABELS;
    private static final Metadata metadata;
    private final Config config;
    private final LocalPortForward portForward;
    private final ManagedChannel channel;

    public Tiller(ManagedChannel channel) {
        Objects.requireNonNull(channel);
        this.config = null;
        this.portForward = null;
        this.channel = channel;
    }

    public Tiller(LocalPortForward portForward) {
        Objects.requireNonNull(portForward);
        this.config = null;
        this.portForward = null;
        this.channel = this.buildChannel(portForward);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client) throws MalformedURLException {
        this(client, DEFAULT_NAMESPACE, 44134, DEFAULT_LABELS);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client, String namespaceHousingTiller) throws MalformedURLException {
        this(client, namespaceHousingTiller, 44134, DEFAULT_LABELS);
    }

    public <T extends HttpClientAware & KubernetesClient> Tiller(T client, String namespaceHousingTiller, int tillerPort, Map<String, String> tillerLabels) throws MalformedURLException {
        OkHttpClient httpClient;
        Objects.requireNonNull(client);
        this.config = ((ConfigAware)client).getConfiguration();
        if (namespaceHousingTiller == null || namespaceHousingTiller.isEmpty()) {
            namespaceHousingTiller = DEFAULT_NAMESPACE;
        }
        if (tillerPort <= 0) {
            tillerPort = 44134;
        }
        if (tillerLabels == null) {
            tillerLabels = DEFAULT_LABELS;
        }
        if ((httpClient = client.getHttpClient()) == null) {
            throw new IllegalArgumentException("client", new IllegalStateException("client.getHttpClient() == null"));
        }
        this.portForward = Pods.forwardPort((OkHttpClient)httpClient, (Listable)((Listable)((NonNamespaceOperation)((KubernetesClient)client).pods().inNamespace(namespaceHousingTiller)).withLabels(tillerLabels)), (int)tillerPort);
        assert (this.portForward != null);
        this.channel = this.buildChannel(this.portForward);
    }

    public Config getConfiguration() {
        return this.config;
    }

    protected ManagedChannel buildChannel(LocalPortForward portForward) {
        return ManagedChannelBuilder.forAddress((String)portForward.getLocalAddress().getHostAddress(), (int)portForward.getLocalPort()).usePlaintext(true).build();
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.shutdown();
        }
        if (this.portForward != null) {
            this.portForward.close();
        }
    }

    public ReleaseServiceGrpc.ReleaseServiceBlockingStub getReleaseServiceBlockingStub() {
        ReleaseServiceGrpc.ReleaseServiceBlockingStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newBlockingStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public ReleaseServiceGrpc.ReleaseServiceFutureStub getReleaseServiceFutureStub() {
        ReleaseServiceGrpc.ReleaseServiceFutureStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceFutureStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newFutureStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public ReleaseServiceGrpc.ReleaseServiceStub getReleaseServiceStub() {
        ReleaseServiceGrpc.ReleaseServiceStub returnValue = null;
        if (this.channel != null) {
            returnValue = (ReleaseServiceGrpc.ReleaseServiceStub)MetadataUtils.attachHeaders((AbstractStub)ReleaseServiceGrpc.newStub((Channel)this.channel), (Metadata)metadata);
        }
        return returnValue;
    }

    public VersionOuterClass.VersionOrBuilder getVersion() throws IOException {
        ReleaseServiceGrpc.ReleaseServiceBlockingStub stub = this.getReleaseServiceBlockingStub();
        assert (stub != null);
        Tiller.GetVersionResponse response = stub.getVersion(null);
        assert (response != null);
        return response.getVersion();
    }

    static {
        metadata = new Metadata();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("name", "tiller");
        labels.put("app", "helm");
        DEFAULT_LABELS = Collections.unmodifiableMap(labels);
        metadata.put(Metadata.Key.of((String)"x-helm-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)VERSION);
    }
}

