/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import hapi.chart.ChartOuterClass;
import hapi.chart.ConfigOuterClass;
import hapi.chart.MetadataOuterClass;
import hapi.chart.TemplateOuterClass;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.kamranzafar.jtar.TarInputStream;
import org.microbean.development.annotation.Issue;
import org.microbean.helm.chart.AbstractChartLoader;
import org.microbean.helm.chart.Metadatas;
import org.microbean.helm.chart.NonClosingInputStream;
import org.microbean.helm.chart.TapeArchiveChartLoader;
import org.yaml.snakeyaml.Yaml;

public abstract class StreamOrientedChartLoader<T>
extends AbstractChartLoader<T> {
    private static final Pattern fileNamePattern = Pattern.compile("^/*[^/]+(?!.*/(?:charts|templates)/)/(.+)$");
    private static final Pattern templateFileNamePattern = Pattern.compile("^.+/(templates/[^/]+)$");
    @Issue(uri="https://github.com/microbean/microbean-helm/issues/63")
    private static final @Issue(uri="https://github.com/microbean/microbean-helm/issues/63") Pattern subchartFileNamePattern = Pattern.compile("^.+/charts/([^._][^/]+/?(.*))$");
    private static final Pattern nonGreedySubchartsPattern = Pattern.compile(".*?/charts/[^/]+");
    private static final Pattern chartNamePattern = Pattern.compile("^.+/charts/([^/]+).*$");
    @Issue(uri="https://github.com/microbean/microbean-helm/issues/63")
    private static final @Issue(uri="https://github.com/microbean/microbean-helm/issues/63") Pattern basenamePattern = Pattern.compile("^.*?([^/]+)$");

    protected StreamOrientedChartLoader() {
    }

    protected abstract Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> toNamedInputStreamEntries(T var1) throws IOException;

    @Override
    public ChartOuterClass.Chart.Builder load(ChartOuterClass.Chart.Builder parent, T source) throws IOException {
        Objects.requireNonNull(source);
        ChartOuterClass.Chart.Builder returnValue = this.load(parent, this.toNamedInputStreamEntries(source));
        if (returnValue == null) {
            throw new IllegalStateException("load(toNamedInputStreamEntries(source)) == null; source: " + source);
        }
        return returnValue;
    }

    @Override
    public ChartOuterClass.Chart.Builder load(ChartOuterClass.Chart.Builder parent, Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> entrySet) throws IOException {
        Objects.requireNonNull(entrySet);
        ChartOuterClass.Chart.Builder rootBuilder = parent == null ? ChartOuterClass.Chart.newBuilder() : parent;
        assert (rootBuilder != null);
        TreeMap<String, ChartOuterClass.Chart.Builder> chartBuilders = new TreeMap<String, ChartOuterClass.Chart.Builder>(new ChartPathComparator());
        chartBuilders.put(null, rootBuilder);
        for (Map.Entry<? extends String, ? extends InputStream> entry : entrySet) {
            InputStream value;
            String key;
            if (entry == null || (key = entry.getKey()) == null || (value = entry.getValue()) == null) continue;
            this.addFile(chartBuilders, key, value);
        }
        return rootBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addFile(NavigableMap<String, ChartOuterClass.Chart.Builder> chartBuilders, String path, InputStream stream) throws IOException {
        boolean subchartFile;
        TemplateOuterClass.Template.Builder templateBuilder;
        Objects.requireNonNull(chartBuilders);
        Objects.requireNonNull(path);
        Objects.requireNonNull(stream);
        ChartOuterClass.Chart.Builder builder = StreamOrientedChartLoader.getChartBuilder(chartBuilders, path);
        if (builder == null) {
            throw new IllegalStateException();
        }
        String fileName = StreamOrientedChartLoader.getTemplateFileName(path);
        if (fileName == null) {
            templateBuilder = null;
            fileName = StreamOrientedChartLoader.getSubchartFileName(path);
            if (fileName == null) {
                subchartFile = false;
                fileName = StreamOrientedChartLoader.getOrdinaryFileName(path);
            } else {
                subchartFile = true;
            }
        } else {
            subchartFile = false;
            templateBuilder = this.createTemplateBuilder(builder, stream, fileName);
        }
        assert (fileName != null);
        if (templateBuilder != null) return;
        switch (fileName) {
            case "Chart.yaml": {
                this.installMetadata(builder, stream);
                return;
            }
            case "values.yaml": {
                this.installConfig(builder, stream);
                return;
            }
        }
        if (subchartFile) {
            if (fileName.endsWith(".prov")) {
                Map.Entry<String, ChartOuterClass.Chart.Builder> parentChartBuilderEntry = chartBuilders.lowerEntry(path);
                if (parentChartBuilderEntry == null) {
                    throw new IllegalStateException("chartBuilders.lowerEntry(path) == null; path: " + path);
                }
                String parentChartPath = parentChartBuilderEntry.getKey();
                ChartOuterClass.Chart.Builder parentChartBuilder = parentChartBuilderEntry.getValue();
                if (parentChartBuilder == null) {
                    throw new IllegalStateException("chartBuilders.lowerEntry(path).getValue() == null; path: " + path);
                }
                int prefixLength = ((parentChartPath == null ? "" : parentChartPath) + "/").length();
                assert (path.length() > prefixLength);
                this.installAny(parentChartBuilder, stream, path.substring(prefixLength));
                return;
            }
            if (!fileName.startsWith("_") && !fileName.startsWith(".") && fileName.endsWith(".tgz") && fileName.equals(StreamOrientedChartLoader.basename(fileName))) {
                assert (fileName.indexOf(47) < 0);
                ChartOuterClass.Chart.Builder subchartBuilder = null;
                try (TarInputStream tarInputStream = new TarInputStream((InputStream)new GZIPInputStream(new NonClosingInputStream(stream)));){
                    subchartBuilder = new TapeArchiveChartLoader().load(builder, tarInputStream);
                }
                if (subchartBuilder != null) return;
                throw new IllegalStateException("load(builder, tarInputStream) == null; path: " + path);
            }
            this.installAny(builder, stream, fileName);
            return;
        }
        assert (!subchartFile);
        this.installAny(builder, stream, fileName);
    }

    static final String getOrdinaryFileName(String path) {
        String returnValue = null;
        if (path != null) {
            Matcher fileMatcher = fileNamePattern.matcher(path);
            assert (fileMatcher != null);
            if (fileMatcher.find()) {
                returnValue = fileMatcher.group(1);
            }
        }
        return returnValue;
    }

    static final String getSubchartFileName(String path) {
        String returnValue = null;
        if (path != null) {
            Matcher subchartMatcher = subchartFileNamePattern.matcher(path);
            assert (subchartMatcher != null);
            if (subchartMatcher.find()) {
                String group2 = subchartMatcher.group(2);
                assert (group2 != null);
                if (group2.isEmpty()) {
                    returnValue = subchartMatcher.group(1);
                    assert (returnValue != null);
                } else {
                    returnValue = group2;
                }
            }
        }
        return returnValue;
    }

    static final String getTemplateFileName(String path) {
        String returnValue = null;
        if (path != null) {
            Matcher templateMatcher = templateFileNamePattern.matcher(path);
            assert (templateMatcher != null);
            if (templateMatcher.find()) {
                returnValue = templateMatcher.group(1);
            }
        }
        return returnValue;
    }

    private static final ChartOuterClass.Chart.Builder getChartBuilder(Map<String, ChartOuterClass.Chart.Builder> chartBuilders, String chartPath) {
        Objects.requireNonNull(chartBuilders);
        Objects.requireNonNull(chartPath);
        ChartOuterClass.Chart.Builder rootBuilder = chartBuilders.get(null);
        if (rootBuilder == null) {
            rootBuilder = ChartOuterClass.Chart.newBuilder();
            chartBuilders.put(null, rootBuilder);
        }
        assert (rootBuilder != null);
        ChartOuterClass.Chart.Builder returnValue = rootBuilder;
        NavigableSet<String> chartPaths = StreamOrientedChartLoader.toSubcharts(chartPath);
        if (chartPaths != null && !chartPaths.isEmpty()) {
            for (String path : chartPaths) {
                ChartOuterClass.Chart.Builder builder = chartBuilders.get(path);
                if (builder == null) {
                    builder = StreamOrientedChartLoader.createSubchartBuilder(returnValue, path);
                    assert (builder != null);
                    chartBuilders.put(path, builder);
                }
                assert (builder != null);
                returnValue = builder;
            }
        }
        assert (returnValue != null);
        return returnValue;
    }

    static final NavigableSet<String> toSubcharts(String chartPath) {
        Objects.requireNonNull(chartPath);
        TreeSet<String> returnValue = new TreeSet<String>(new ChartPathComparator());
        Matcher matcher = nonGreedySubchartsPattern.matcher(chartPath);
        if (matcher != null) {
            while (matcher.find()) {
                returnValue.add(chartPath.substring(0, matcher.end()));
            }
        }
        return returnValue;
    }

    private static final ChartOuterClass.Chart.Builder createSubchartBuilder(ChartOuterClass.Chart.Builder parentBuilder, String chartPath) {
        Objects.requireNonNull(parentBuilder);
        ChartOuterClass.Chart.Builder returnValue = null;
        String chartName = StreamOrientedChartLoader.getChartName(chartPath);
        if (chartName != null) {
            returnValue = parentBuilder.addDependenciesBuilder();
            assert (returnValue != null);
            MetadataOuterClass.Metadata.Builder builder = returnValue.getMetadataBuilder();
            assert (builder != null);
            builder.setName(chartName);
        }
        return returnValue;
    }

    private static final String getChartName(String chartPath) {
        String returnValue = null;
        if (chartPath != null) {
            Matcher matcher = chartNamePattern.matcher(chartPath);
            assert (matcher != null);
            if (matcher.find()) {
                returnValue = matcher.group(1);
            }
        }
        return returnValue;
    }

    private static final String basename(String path) {
        String returnValue = null;
        if (path != null) {
            Matcher matcher = basenamePattern.matcher(path);
            assert (matcher != null);
            if (matcher.find()) {
                returnValue = matcher.group(1);
            }
        }
        return returnValue;
    }

    protected void installConfig(ChartOuterClass.Chart.Builder chartBuilder, InputStream stream) throws IOException {
        Objects.requireNonNull(chartBuilder);
        Objects.requireNonNull(stream);
        Object returnValue = null;
        ConfigOuterClass.Config.Builder builder = chartBuilder.getValuesBuilder();
        assert (builder != null);
        ByteString rawBytes = ByteString.readFrom((InputStream)stream);
        assert (rawBytes != null);
        builder.setRawBytes(rawBytes);
    }

    protected void installMetadata(ChartOuterClass.Chart.Builder chartBuilder, InputStream stream) throws IOException {
        Objects.requireNonNull(chartBuilder);
        Objects.requireNonNull(stream);
        Object returnValue = null;
        Map map = (Map)new Yaml().loadAs(stream, Map.class);
        assert (map != null);
        MetadataOuterClass.Metadata.Builder metadataBuilder = chartBuilder.getMetadataBuilder();
        assert (metadataBuilder != null);
        Metadatas.populateMetadataBuilder(metadataBuilder, map);
    }

    protected TemplateOuterClass.Template.Builder createTemplateBuilder(ChartOuterClass.Chart.Builder chartBuilder, InputStream stream, String name) throws IOException {
        Objects.requireNonNull(chartBuilder);
        Objects.requireNonNull(stream);
        Objects.requireNonNull(name);
        TemplateOuterClass.Template.Builder builder = chartBuilder.addTemplatesBuilder();
        assert (builder != null);
        builder.setName(name);
        ByteString data = ByteString.readFrom((InputStream)stream);
        assert (data != null);
        assert (data.isValidUtf8());
        builder.setData(data);
        return builder;
    }

    protected void installAny(ChartOuterClass.Chart.Builder chartBuilder, InputStream stream, String name) throws IOException {
        Objects.requireNonNull(chartBuilder);
        Objects.requireNonNull(stream);
        Objects.requireNonNull(name);
        Object returnValue = null;
        Any.Builder builder = chartBuilder.addFilesBuilder();
        assert (builder != null);
        builder.setTypeUrl(name);
        ByteString fileContents = ByteString.readFrom((InputStream)stream);
        assert (fileContents != null);
        assert (fileContents.isValidUtf8());
        builder.setValue(fileContents);
    }

    private static final class ChartPathComparator
    implements Comparator<String> {
        private ChartPathComparator() {
        }

        @Override
        public final int compare(String chartPath1, String chartPath2) {
            int chartPath2Length;
            if (chartPath1 == null) {
                if (chartPath2 == null) {
                    return 0;
                }
                return -1;
            }
            if (chartPath1.equals(chartPath2)) {
                return 0;
            }
            if (chartPath2 == null) {
                return 1;
            }
            int chartPath1Length = chartPath1.length();
            if (chartPath1Length == (chartPath2Length = chartPath2.length())) {
                return chartPath1.compareTo(chartPath2);
            }
            if (chartPath1Length > chartPath2Length) {
                return 1;
            }
            return -1;
        }
    }

    static final class EmptyIterable
    implements Iterable<Map.Entry<String, InputStream>> {
        EmptyIterable() {
        }

        @Override
        public final Iterator<Map.Entry<String, InputStream>> iterator() {
            return Collections.emptyIterator();
        }
    }
}

