/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart.repository;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import hapi.chart.ChartOuterClass;
import hapi.chart.MetadataOuterClass;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import org.kamranzafar.jtar.TarInputStream;
import org.microbean.development.annotation.Experimental;
import org.microbean.helm.chart.Metadatas;
import org.microbean.helm.chart.TapeArchiveChartLoader;
import org.microbean.helm.chart.resolver.AbstractChartResolver;
import org.microbean.helm.chart.resolver.ChartResolverException;
import org.yaml.snakeyaml.Yaml;

@Experimental
public class ChartRepository
extends AbstractChartResolver {
    private final Path archiveCacheDirectory;
    private final Path cachedIndexPath;
    private transient Index index;
    private final Path indexCacheDirectory;
    private final String name;
    private final URI uri;

    public ChartRepository(String name, URI uri) {
        this(name, uri, null, null, null);
    }

    public ChartRepository(String name, URI uri, Path cachedIndexPath) {
        this(name, uri, null, null, cachedIndexPath);
    }

    public ChartRepository(String name, URI uri, Path archiveCacheDirectory, Path indexCacheDirectory, Path cachedIndexPath) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(uri);
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("!uri.isAbsolute(): " + uri);
        }
        Path helmHome = null;
        if (archiveCacheDirectory == null) {
            helmHome = ChartRepository.getHelmHome();
            assert (helmHome != null);
            this.archiveCacheDirectory = helmHome.resolve("cache/archive");
            assert (this.archiveCacheDirectory != null);
            assert (this.archiveCacheDirectory.isAbsolute());
        } else {
            if (archiveCacheDirectory.toString().isEmpty()) {
                throw new IllegalArgumentException("archiveCacheDirectory.toString().isEmpty(): " + archiveCacheDirectory);
            }
            if (!archiveCacheDirectory.isAbsolute()) {
                throw new IllegalArgumentException("!archiveCacheDirectory.isAbsolute(): " + archiveCacheDirectory);
            }
            this.archiveCacheDirectory = archiveCacheDirectory;
        }
        assert (this.archiveCacheDirectory != null);
        assert (this.archiveCacheDirectory.isAbsolute());
        if (!Files.isDirectory(this.archiveCacheDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("!Files.isDirectory(this.archiveCacheDirectory): " + this.archiveCacheDirectory);
        }
        if (cachedIndexPath == null || cachedIndexPath.toString().isEmpty()) {
            cachedIndexPath = Paths.get(name + "-index.yaml", new String[0]);
        }
        assert (cachedIndexPath != null);
        if (cachedIndexPath.isAbsolute()) {
            this.indexCacheDirectory = null;
            this.cachedIndexPath = cachedIndexPath;
        } else {
            if (indexCacheDirectory == null) {
                if (helmHome == null) {
                    helmHome = ChartRepository.getHelmHome();
                    assert (helmHome != null);
                }
                this.indexCacheDirectory = helmHome.resolve("repository/cache");
                assert (this.indexCacheDirectory.isAbsolute());
            } else {
                if (!indexCacheDirectory.isAbsolute()) {
                    throw new IllegalArgumentException("!indexCacheDirectory.isAbsolute(): " + indexCacheDirectory);
                }
                this.indexCacheDirectory = indexCacheDirectory;
                assert (this.indexCacheDirectory.isAbsolute());
            }
            if (!Files.isDirectory(this.indexCacheDirectory, new LinkOption[0])) {
                throw new IllegalArgumentException("!Files.isDirectory(this.indexCacheDirectory): " + this.indexCacheDirectory);
            }
            this.cachedIndexPath = this.indexCacheDirectory.resolve(cachedIndexPath);
        }
        assert (this.cachedIndexPath != null);
        assert (this.cachedIndexPath.isAbsolute());
        this.name = name;
        this.uri = uri;
    }

    public final String getName() {
        return this.name;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final Path getCachedIndexPath() {
        return this.cachedIndexPath;
    }

    public final Index getIndex() throws IOException, URISyntaxException {
        return this.getIndex(false);
    }

    public final Index getIndex(boolean forceDownload) throws IOException, URISyntaxException {
        if (forceDownload || this.index == null) {
            Path cachedIndexPath = this.getCachedIndexPath();
            assert (cachedIndexPath != null);
            if (forceDownload || this.isCachedIndexExpired()) {
                this.downloadIndexTo(cachedIndexPath);
            }
            this.index = Index.loadFrom(cachedIndexPath);
            assert (this.index != null);
        }
        return this.index;
    }

    public boolean isCachedIndexExpired() {
        Path cachedIndexPath = this.getCachedIndexPath();
        assert (cachedIndexPath != null);
        return !Files.isRegularFile(cachedIndexPath, new LinkOption[0]);
    }

    public final Index clearIndex() {
        Index returnValue = this.index;
        this.index = null;
        return returnValue;
    }

    public final Path downloadIndex() throws IOException {
        return this.downloadIndexTo(this.getCachedIndexPath());
    }

    public Path downloadIndexTo(Path path) throws IOException {
        URI baseUri = this.getUri();
        if (baseUri == null) {
            throw new IllegalStateException("getUri() == null");
        }
        URI indexUri = baseUri.resolve("index.yaml");
        assert (indexUri != null);
        URL indexUrl = indexUri.toURL();
        assert (indexUrl != null);
        if (path == null) {
            path = this.getCachedIndexPath();
        }
        assert (path != null);
        if (!path.isAbsolute()) {
            assert (this.indexCacheDirectory != null);
            assert (this.indexCacheDirectory.isAbsolute());
            path = this.indexCacheDirectory.resolve(path);
            assert (path != null);
            assert (path.isAbsolute());
        }
        Path temporaryPath = Files.createTempFile(this.getName() + "-index-", ".yaml", new FileAttribute[0]);
        assert (temporaryPath != null);
        try (BufferedInputStream stream = new BufferedInputStream(indexUrl.openStream());){
            Files.copy(stream, temporaryPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException throwMe) {
            try {
                Files.deleteIfExists(temporaryPath);
            }
            catch (IOException suppressMe) {
                throwMe.addSuppressed(suppressMe);
            }
            throw throwMe;
        }
        return Files.move(temporaryPath, path, StandardCopyOption.ATOMIC_MOVE);
    }

    public Index loadIndex() throws IOException, URISyntaxException {
        Path path = this.getCachedIndexPath();
        assert (path != null);
        if (!path.isAbsolute()) {
            assert (this.indexCacheDirectory != null);
            assert (this.indexCacheDirectory.isAbsolute());
            path = this.indexCacheDirectory.resolve(path);
            assert (path != null);
            assert (path.isAbsolute());
        }
        return Index.loadFrom(path);
    }

    public final Path getCachedChartPath(String chartName, String chartVersion) throws IOException, URISyntaxException {
        Objects.requireNonNull(chartName);
        Path returnValue = null;
        if (chartVersion == null) {
            Index index = this.getIndex(false);
            assert (index != null);
            Index.Entry entry = index.getEntry(chartName, null);
            if (entry != null) {
                chartVersion = entry.getVersion();
            }
        }
        if (chartVersion != null) {
            assert (this.archiveCacheDirectory != null);
            StringBuilder chartKey = new StringBuilder(chartName).append("-").append(chartVersion);
            String chartFilename = new StringBuilder(chartKey).append(".tgz").toString();
            Path cachedChartPath = this.archiveCacheDirectory.resolve(chartFilename);
            assert (cachedChartPath != null);
            if (!Files.isRegularFile(cachedChartPath, new LinkOption[0])) {
                URI chartUri;
                Index index = this.getIndex(true);
                assert (index != null);
                Index.Entry entry = index.getEntry(chartName, chartVersion);
                if (entry != null && (chartUri = entry.getFirstUri()) != null) {
                    if (!chartUri.isAbsolute()) {
                        URI chartRepositoryUri = this.getUri();
                        assert (chartRepositoryUri != null);
                        assert (chartRepositoryUri.isAbsolute());
                        chartUri = chartRepositoryUri.resolve(chartUri);
                        assert (chartUri != null);
                        assert (chartUri.isAbsolute());
                    }
                    URL chartUrl = chartUri.toURL();
                    assert (chartUrl != null);
                    Path temporaryPath = Files.createTempFile(chartKey.append("-").toString(), ".tgz", new FileAttribute[0]);
                    assert (temporaryPath != null);
                    try (BufferedInputStream stream = new BufferedInputStream(chartUrl.openStream());){
                        Files.copy(stream, temporaryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException throwMe) {
                        try {
                            Files.deleteIfExists(temporaryPath);
                        }
                        catch (IOException suppressMe) {
                            throwMe.addSuppressed(suppressMe);
                        }
                        throw throwMe;
                    }
                    Files.move(temporaryPath, cachedChartPath, StandardCopyOption.ATOMIC_MOVE);
                }
            }
            returnValue = cachedChartPath;
        }
        return returnValue;
    }

    @Override
    public ChartOuterClass.Chart.Builder resolve(String chartName, String chartVersion) throws ChartResolverException {
        Objects.requireNonNull(chartName);
        ChartOuterClass.Chart.Builder returnValue = null;
        Path cachedChartPath = null;
        try {
            cachedChartPath = this.getCachedChartPath(chartName, chartVersion);
        }
        catch (IOException | URISyntaxException exception) {
            throw new ChartResolverException(exception.getMessage(), exception);
        }
        if (cachedChartPath != null && Files.isRegularFile(cachedChartPath, new LinkOption[0])) {
            try (TapeArchiveChartLoader loader = new TapeArchiveChartLoader();){
                returnValue = loader.load(new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(Files.newInputStream(cachedChartPath, new OpenOption[0])))));
            }
            catch (IOException exception) {
                throw new ChartResolverException(exception.getMessage(), exception);
            }
        }
        return returnValue;
    }

    static final Path getHelmHome() {
        String helmHome = System.getProperty("helm.home", System.getenv("HELM_HOME"));
        if (helmHome == null) {
            helmHome = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".helm").toString();
            assert (helmHome != null);
        }
        return Paths.get(helmHome, new String[0]);
    }

    @Experimental
    public static final class Index {
        private final SortedMap<String, SortedSet<Entry>> entries;

        Index(Map<? extends String, ? extends SortedSet<Entry>> entries) {
            this.entries = entries == null || entries.isEmpty() ? Collections.emptySortedMap() : Collections.unmodifiableSortedMap(Index.deepCopy(entries));
        }

        @Experimental
        public final Index merge(Index other) {
            Index returnValue;
            Map<String, SortedSet<Entry>> myEntries = this.getEntries();
            Map<String, SortedSet<Entry>> otherEntries = other == null ? null : other.getEntries();
            if (otherEntries == null || otherEntries.isEmpty()) {
                returnValue = myEntries == null || myEntries.isEmpty() ? new Index(null) : new Index(myEntries);
            } else if (myEntries == null || myEntries.isEmpty()) {
                returnValue = new Index(otherEntries);
            } else {
                SortedMap<String, SortedSet<Entry>> mergedEntries = Index.deepCopy(myEntries);
                Set<Map.Entry<String, SortedSet<Entry>>> otherEntrySet = otherEntries.entrySet();
                if (otherEntrySet != null && !otherEntrySet.isEmpty()) {
                    for (Map.Entry<String, SortedSet<Entry>> otherEntrySetElement : otherEntrySet) {
                        SortedSet<Entry> otherValues;
                        if (otherEntrySetElement == null || (otherValues = otherEntrySetElement.getValue()) == null || otherValues.isEmpty()) continue;
                        for (Entry otherEntry : otherValues) {
                            String otherEntryName;
                            Entry myCorrespondingEntry;
                            if (otherEntry == null || (myCorrespondingEntry = this.getEntry(otherEntryName = otherEntry.getName(), otherEntry.getVersion())) != null) continue;
                            TreeSet myRelatedEntries = (TreeSet)mergedEntries.get(otherEntryName);
                            if (myRelatedEntries == null) {
                                myRelatedEntries = new TreeSet(Collections.reverseOrder());
                                mergedEntries.put(otherEntryName, myRelatedEntries);
                            }
                            assert (!myRelatedEntries.contains(otherEntry));
                            myRelatedEntries.add(otherEntry);
                        }
                    }
                }
                returnValue = new Index(mergedEntries);
            }
            return returnValue;
        }

        public final Map<String, SortedSet<Entry>> getEntries() {
            return this.entries;
        }

        public final Entry getEntry(String name, String versionString) {
            SortedSet<Entry> entrySet;
            Objects.requireNonNull(name);
            Entry returnValue = null;
            Map<String, SortedSet<Entry>> entries = this.getEntries();
            if (entries != null && !entries.isEmpty() && (entrySet = entries.get(name)) != null && !entrySet.isEmpty()) {
                if (versionString == null) {
                    returnValue = entrySet.first();
                } else {
                    for (Entry entry : entrySet) {
                        if (entry == null || !versionString.equals(entry.getVersion())) continue;
                        returnValue = entry;
                        break;
                    }
                }
            }
            return returnValue;
        }

        public static final Index loadFrom(Path path) throws IOException, URISyntaxException {
            Index returnValue;
            Objects.requireNonNull(path);
            try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                returnValue = Index.loadFrom(stream);
            }
            return returnValue;
        }

        public static final Index loadFrom(InputStream stream) throws IOException, URISyntaxException {
            Index returnValue;
            Objects.requireNonNull(stream);
            Map yamlMap = (Map)new Yaml().loadAs(stream, Map.class);
            if (yamlMap == null || yamlMap.isEmpty()) {
                returnValue = new Index(null);
            } else {
                Set entries;
                TreeMap sortedEntryMap = new TreeMap();
                Map entriesMap = (Map)yamlMap.get("entries");
                if (entriesMap != null && !entriesMap.isEmpty() && (entries = entriesMap.entrySet()) != null && !entries.isEmpty()) {
                    for (Map.Entry entry : entries) {
                        Collection entryContents;
                        String entryName;
                        if (entry == null || (entryName = (String)entry.getKey()) == null || (entryContents = (Collection)entry.getValue()) == null || entryContents.isEmpty()) continue;
                        for (Map entryMap : entryContents) {
                            if (entryMap == null || entryMap.isEmpty()) continue;
                            MetadataOuterClass.Metadata.Builder metadataBuilder = MetadataOuterClass.Metadata.newBuilder();
                            assert (metadataBuilder != null);
                            Metadatas.populateMetadataBuilder(metadataBuilder, entryMap);
                            Collection uriStrings = (Collection)entryMap.get("urls");
                            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
                            if (uriStrings != null && !uriStrings.isEmpty()) {
                                for (String uriString : uriStrings) {
                                    if (uriString == null || uriString.isEmpty()) continue;
                                    uris.add(new URI(uriString));
                                }
                            }
                            String digest = (String)entryMap.get("digest");
                            TreeSet entryObjects = (TreeSet)sortedEntryMap.get(entryName);
                            if (entryObjects == null) {
                                entryObjects = new TreeSet(Collections.reverseOrder());
                                sortedEntryMap.put(entryName, entryObjects);
                            }
                            entryObjects.add(new Entry(metadataBuilder, uris, digest));
                        }
                    }
                }
                returnValue = new Index(sortedEntryMap);
            }
            return returnValue;
        }

        private static final SortedMap<String, SortedSet<Entry>> deepCopy(Map<? extends String, ? extends SortedSet<Entry>> source) {
            SortedMap returnValue;
            if (source == null) {
                returnValue = null;
            } else if (source.isEmpty()) {
                returnValue = Collections.emptySortedMap();
            } else {
                returnValue = new TreeMap();
                Set<Map.Entry<? extends String, ? extends SortedSet<Entry>>> entrySet = source.entrySet();
                if (entrySet != null && !entrySet.isEmpty()) {
                    for (Map.Entry entry : entrySet) {
                        String key = (String)entry.getKey();
                        SortedSet value = (SortedSet)entry.getValue();
                        if (value == null) {
                            returnValue.put(key, null);
                            continue;
                        }
                        TreeSet newValue = new TreeSet(value.comparator());
                        newValue.addAll(value);
                        returnValue.put(key, newValue);
                    }
                }
            }
            return returnValue;
        }

        @Experimental
        public static final class Entry
        implements Comparable<Entry> {
            private final MetadataOuterClass.MetadataOrBuilder metadata;
            private final Set<URI> uris;
            private final String digest;

            Entry(MetadataOuterClass.MetadataOrBuilder metadata, Collection<? extends URI> uris) {
                this(metadata, uris, null);
            }

            Entry(MetadataOuterClass.MetadataOrBuilder metadata, Collection<? extends URI> uris, String digest) {
                this.metadata = Objects.requireNonNull(metadata);
                this.uris = uris == null || uris.isEmpty() ? Collections.emptySet() : new LinkedHashSet<URI>(uris);
                this.digest = digest;
            }

            @Override
            public final int compareTo(Entry her) {
                Objects.requireNonNull(her);
                String myName = this.getName();
                String herName = her.getName();
                if (myName == null) {
                    if (herName != null) {
                        return -1;
                    }
                } else {
                    if (herName == null) {
                        return 1;
                    }
                    int nameComparison = myName.compareTo(herName);
                    if (nameComparison != 0) {
                        return nameComparison;
                    }
                }
                String myVersionString = this.getVersion();
                String herVersionString = her.getVersion();
                if (myVersionString == null) {
                    if (herVersionString != null) {
                        return -1;
                    }
                } else {
                    if (herVersionString == null) {
                        return 1;
                    }
                    Version myVersion = null;
                    try {
                        myVersion = Version.valueOf((String)myVersionString);
                    }
                    catch (ParseException | IllegalArgumentException badVersion) {
                        myVersion = null;
                    }
                    Version herVersion = null;
                    try {
                        herVersion = Version.valueOf((String)herVersionString);
                    }
                    catch (ParseException | IllegalArgumentException badVersion) {
                        herVersion = null;
                    }
                    if (myVersion == null) {
                        if (herVersion != null) {
                            return -1;
                        }
                    } else {
                        if (herVersion == null) {
                            return 1;
                        }
                        return myVersion.compareTo(herVersion);
                    }
                }
                return 0;
            }

            public final int hashCode() {
                int hashCode = 17;
                String name = this.getName();
                int c = name == null ? 0 : name.hashCode();
                hashCode = 37 * hashCode + c;
                String version = this.getVersion();
                c = version == null ? 0 : version.hashCode();
                hashCode = 37 * hashCode + c;
                return hashCode;
            }

            public final boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other instanceof Entry) {
                    Entry her = (Entry)other;
                    String myName = this.getName();
                    if (myName == null ? her.getName() != null : !myName.equals(her.getName())) {
                        return false;
                    }
                    String myVersion = this.getVersion();
                    return !(myVersion == null ? her.getVersion() != null : !myVersion.equals(her.getVersion()));
                }
                return false;
            }

            public final MetadataOuterClass.MetadataOrBuilder getMetadataOrBuilder() {
                return this.metadata;
            }

            public final String getName() {
                MetadataOuterClass.MetadataOrBuilder metadata = this.getMetadataOrBuilder();
                assert (metadata != null);
                return metadata.getName();
            }

            public final String getVersion() {
                MetadataOuterClass.MetadataOrBuilder metadata = this.getMetadataOrBuilder();
                assert (metadata != null);
                return metadata.getVersion();
            }

            public final Set<URI> getUris() {
                return this.uris;
            }

            public final URI getFirstUri() {
                Iterator<URI> iterator;
                Set<URI> uris = this.getUris();
                URI returnValue = uris == null || uris.isEmpty() ? null : ((iterator = uris.iterator()) == null || !iterator.hasNext() ? null : iterator.next());
                return returnValue;
            }

            public final String getDigest() {
                return this.digest;
            }

            public final String toString() {
                String name = this.getName();
                if (name == null || name.isEmpty()) {
                    name = "unnamed";
                }
                return name + " " + this.getVersion();
            }

            @Experimental
            public static final String getDigest(InputStream inputStream) throws IOException {
                Objects.requireNonNull(inputStream);
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InternalError(noSuchAlgorithmException);
                }
                assert (md != null);
                ByteBuffer buffer = Entry.toByteBuffer(inputStream);
                assert (buffer != null);
                md.update(buffer);
                return DatatypeConverter.printHexBinary((byte[])md.digest());
            }

            private static final ByteBuffer toByteBuffer(InputStream stream) throws IOException {
                return ByteBuffer.wrap(Entry.read(stream));
            }

            private static final byte[] read(InputStream stream) throws IOException {
                byte[] returnValue = null;
                if (stream == null) {
                    returnValue = new byte[]{};
                } else {
                    try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                        int bytesRead;
                        byte[] byteArray = new byte[4096];
                        while ((bytesRead = stream.read(byteArray, 0, byteArray.length)) != -1) {
                            buffer.write(byteArray, 0, bytesRead);
                        }
                        buffer.flush();
                        returnValue = buffer.toByteArray();
                    }
                }
                return returnValue;
            }
        }
    }
}

