package hapi.services.tiller;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * ReleaseService is the service that a helm application uses to mutate,
 * query, and manage releases.
 *		Release: A named installation composed of a chart and
 * 				 config. At any given time a release has one
 *				 chart and one config.
 *		Config:  A config is a YAML file that supplies values
 *				 to the parametrizable templates of a chart.
 *		Chart:   A chart is a helm package that contains
 *				 metadata, a default config, zero or more
 *				 optionally parameterizable templates, and
 *				 zero or more charts (dependencies).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.10.0)",
    comments = "Source: hapi/services/tiller.proto")
public final class ReleaseServiceGrpc {

  private ReleaseServiceGrpc() {}

  public static final String SERVICE_NAME = "hapi.services.tiller.ReleaseService";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getListReleasesMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest,
      hapi.services.tiller.Tiller.ListReleasesResponse> METHOD_LIST_RELEASES = getListReleasesMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest,
      hapi.services.tiller.Tiller.ListReleasesResponse> getListReleasesMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest,
      hapi.services.tiller.Tiller.ListReleasesResponse> getListReleasesMethod() {
    return getListReleasesMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest,
      hapi.services.tiller.Tiller.ListReleasesResponse> getListReleasesMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.ListReleasesRequest, hapi.services.tiller.Tiller.ListReleasesResponse> getListReleasesMethod;
    if ((getListReleasesMethod = ReleaseServiceGrpc.getListReleasesMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getListReleasesMethod = ReleaseServiceGrpc.getListReleasesMethod) == null) {
          ReleaseServiceGrpc.getListReleasesMethod = getListReleasesMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.ListReleasesRequest, hapi.services.tiller.Tiller.ListReleasesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "ListReleases"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.ListReleasesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.ListReleasesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("ListReleases"))
                  .build();
          }
        }
     }
     return getListReleasesMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getGetReleaseStatusMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest,
      hapi.services.tiller.Tiller.GetReleaseStatusResponse> METHOD_GET_RELEASE_STATUS = getGetReleaseStatusMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest,
      hapi.services.tiller.Tiller.GetReleaseStatusResponse> getGetReleaseStatusMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest,
      hapi.services.tiller.Tiller.GetReleaseStatusResponse> getGetReleaseStatusMethod() {
    return getGetReleaseStatusMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest,
      hapi.services.tiller.Tiller.GetReleaseStatusResponse> getGetReleaseStatusMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseStatusRequest, hapi.services.tiller.Tiller.GetReleaseStatusResponse> getGetReleaseStatusMethod;
    if ((getGetReleaseStatusMethod = ReleaseServiceGrpc.getGetReleaseStatusMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getGetReleaseStatusMethod = ReleaseServiceGrpc.getGetReleaseStatusMethod) == null) {
          ReleaseServiceGrpc.getGetReleaseStatusMethod = getGetReleaseStatusMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetReleaseStatusRequest, hapi.services.tiller.Tiller.GetReleaseStatusResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "GetReleaseStatus"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetReleaseStatusRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetReleaseStatusResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetReleaseStatus"))
                  .build();
          }
        }
     }
     return getGetReleaseStatusMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getGetReleaseContentMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest,
      hapi.services.tiller.Tiller.GetReleaseContentResponse> METHOD_GET_RELEASE_CONTENT = getGetReleaseContentMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest,
      hapi.services.tiller.Tiller.GetReleaseContentResponse> getGetReleaseContentMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest,
      hapi.services.tiller.Tiller.GetReleaseContentResponse> getGetReleaseContentMethod() {
    return getGetReleaseContentMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest,
      hapi.services.tiller.Tiller.GetReleaseContentResponse> getGetReleaseContentMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetReleaseContentRequest, hapi.services.tiller.Tiller.GetReleaseContentResponse> getGetReleaseContentMethod;
    if ((getGetReleaseContentMethod = ReleaseServiceGrpc.getGetReleaseContentMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getGetReleaseContentMethod = ReleaseServiceGrpc.getGetReleaseContentMethod) == null) {
          ReleaseServiceGrpc.getGetReleaseContentMethod = getGetReleaseContentMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetReleaseContentRequest, hapi.services.tiller.Tiller.GetReleaseContentResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "GetReleaseContent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetReleaseContentRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetReleaseContentResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetReleaseContent"))
                  .build();
          }
        }
     }
     return getGetReleaseContentMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getUpdateReleaseMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest,
      hapi.services.tiller.Tiller.UpdateReleaseResponse> METHOD_UPDATE_RELEASE = getUpdateReleaseMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest,
      hapi.services.tiller.Tiller.UpdateReleaseResponse> getUpdateReleaseMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest,
      hapi.services.tiller.Tiller.UpdateReleaseResponse> getUpdateReleaseMethod() {
    return getUpdateReleaseMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest,
      hapi.services.tiller.Tiller.UpdateReleaseResponse> getUpdateReleaseMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UpdateReleaseRequest, hapi.services.tiller.Tiller.UpdateReleaseResponse> getUpdateReleaseMethod;
    if ((getUpdateReleaseMethod = ReleaseServiceGrpc.getUpdateReleaseMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getUpdateReleaseMethod = ReleaseServiceGrpc.getUpdateReleaseMethod) == null) {
          ReleaseServiceGrpc.getUpdateReleaseMethod = getUpdateReleaseMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.UpdateReleaseRequest, hapi.services.tiller.Tiller.UpdateReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "UpdateRelease"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.UpdateReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.UpdateReleaseResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("UpdateRelease"))
                  .build();
          }
        }
     }
     return getUpdateReleaseMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getInstallReleaseMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest,
      hapi.services.tiller.Tiller.InstallReleaseResponse> METHOD_INSTALL_RELEASE = getInstallReleaseMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest,
      hapi.services.tiller.Tiller.InstallReleaseResponse> getInstallReleaseMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest,
      hapi.services.tiller.Tiller.InstallReleaseResponse> getInstallReleaseMethod() {
    return getInstallReleaseMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest,
      hapi.services.tiller.Tiller.InstallReleaseResponse> getInstallReleaseMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.InstallReleaseRequest, hapi.services.tiller.Tiller.InstallReleaseResponse> getInstallReleaseMethod;
    if ((getInstallReleaseMethod = ReleaseServiceGrpc.getInstallReleaseMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getInstallReleaseMethod = ReleaseServiceGrpc.getInstallReleaseMethod) == null) {
          ReleaseServiceGrpc.getInstallReleaseMethod = getInstallReleaseMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.InstallReleaseRequest, hapi.services.tiller.Tiller.InstallReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "InstallRelease"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.InstallReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.InstallReleaseResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("InstallRelease"))
                  .build();
          }
        }
     }
     return getInstallReleaseMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getUninstallReleaseMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest,
      hapi.services.tiller.Tiller.UninstallReleaseResponse> METHOD_UNINSTALL_RELEASE = getUninstallReleaseMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest,
      hapi.services.tiller.Tiller.UninstallReleaseResponse> getUninstallReleaseMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest,
      hapi.services.tiller.Tiller.UninstallReleaseResponse> getUninstallReleaseMethod() {
    return getUninstallReleaseMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest,
      hapi.services.tiller.Tiller.UninstallReleaseResponse> getUninstallReleaseMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.UninstallReleaseRequest, hapi.services.tiller.Tiller.UninstallReleaseResponse> getUninstallReleaseMethod;
    if ((getUninstallReleaseMethod = ReleaseServiceGrpc.getUninstallReleaseMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getUninstallReleaseMethod = ReleaseServiceGrpc.getUninstallReleaseMethod) == null) {
          ReleaseServiceGrpc.getUninstallReleaseMethod = getUninstallReleaseMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.UninstallReleaseRequest, hapi.services.tiller.Tiller.UninstallReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "UninstallRelease"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.UninstallReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.UninstallReleaseResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("UninstallRelease"))
                  .build();
          }
        }
     }
     return getUninstallReleaseMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getGetVersionMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest,
      hapi.services.tiller.Tiller.GetVersionResponse> METHOD_GET_VERSION = getGetVersionMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest,
      hapi.services.tiller.Tiller.GetVersionResponse> getGetVersionMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest,
      hapi.services.tiller.Tiller.GetVersionResponse> getGetVersionMethod() {
    return getGetVersionMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest,
      hapi.services.tiller.Tiller.GetVersionResponse> getGetVersionMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetVersionRequest, hapi.services.tiller.Tiller.GetVersionResponse> getGetVersionMethod;
    if ((getGetVersionMethod = ReleaseServiceGrpc.getGetVersionMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getGetVersionMethod = ReleaseServiceGrpc.getGetVersionMethod) == null) {
          ReleaseServiceGrpc.getGetVersionMethod = getGetVersionMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetVersionRequest, hapi.services.tiller.Tiller.GetVersionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "GetVersion"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetVersionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetVersionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetVersion"))
                  .build();
          }
        }
     }
     return getGetVersionMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getRollbackReleaseMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest,
      hapi.services.tiller.Tiller.RollbackReleaseResponse> METHOD_ROLLBACK_RELEASE = getRollbackReleaseMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest,
      hapi.services.tiller.Tiller.RollbackReleaseResponse> getRollbackReleaseMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest,
      hapi.services.tiller.Tiller.RollbackReleaseResponse> getRollbackReleaseMethod() {
    return getRollbackReleaseMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest,
      hapi.services.tiller.Tiller.RollbackReleaseResponse> getRollbackReleaseMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.RollbackReleaseRequest, hapi.services.tiller.Tiller.RollbackReleaseResponse> getRollbackReleaseMethod;
    if ((getRollbackReleaseMethod = ReleaseServiceGrpc.getRollbackReleaseMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getRollbackReleaseMethod = ReleaseServiceGrpc.getRollbackReleaseMethod) == null) {
          ReleaseServiceGrpc.getRollbackReleaseMethod = getRollbackReleaseMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.RollbackReleaseRequest, hapi.services.tiller.Tiller.RollbackReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "RollbackRelease"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.RollbackReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.RollbackReleaseResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("RollbackRelease"))
                  .build();
          }
        }
     }
     return getRollbackReleaseMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getGetHistoryMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest,
      hapi.services.tiller.Tiller.GetHistoryResponse> METHOD_GET_HISTORY = getGetHistoryMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest,
      hapi.services.tiller.Tiller.GetHistoryResponse> getGetHistoryMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest,
      hapi.services.tiller.Tiller.GetHistoryResponse> getGetHistoryMethod() {
    return getGetHistoryMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest,
      hapi.services.tiller.Tiller.GetHistoryResponse> getGetHistoryMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.GetHistoryRequest, hapi.services.tiller.Tiller.GetHistoryResponse> getGetHistoryMethod;
    if ((getGetHistoryMethod = ReleaseServiceGrpc.getGetHistoryMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getGetHistoryMethod = ReleaseServiceGrpc.getGetHistoryMethod) == null) {
          ReleaseServiceGrpc.getGetHistoryMethod = getGetHistoryMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.GetHistoryRequest, hapi.services.tiller.Tiller.GetHistoryResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "GetHistory"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetHistoryRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.GetHistoryResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("GetHistory"))
                  .build();
          }
        }
     }
     return getGetHistoryMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getRunReleaseTestMethod()} instead. 
  public static final io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest,
      hapi.services.tiller.Tiller.TestReleaseResponse> METHOD_RUN_RELEASE_TEST = getRunReleaseTestMethodHelper();

  private static volatile io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest,
      hapi.services.tiller.Tiller.TestReleaseResponse> getRunReleaseTestMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest,
      hapi.services.tiller.Tiller.TestReleaseResponse> getRunReleaseTestMethod() {
    return getRunReleaseTestMethodHelper();
  }

  private static io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest,
      hapi.services.tiller.Tiller.TestReleaseResponse> getRunReleaseTestMethodHelper() {
    io.grpc.MethodDescriptor<hapi.services.tiller.Tiller.TestReleaseRequest, hapi.services.tiller.Tiller.TestReleaseResponse> getRunReleaseTestMethod;
    if ((getRunReleaseTestMethod = ReleaseServiceGrpc.getRunReleaseTestMethod) == null) {
      synchronized (ReleaseServiceGrpc.class) {
        if ((getRunReleaseTestMethod = ReleaseServiceGrpc.getRunReleaseTestMethod) == null) {
          ReleaseServiceGrpc.getRunReleaseTestMethod = getRunReleaseTestMethod = 
              io.grpc.MethodDescriptor.<hapi.services.tiller.Tiller.TestReleaseRequest, hapi.services.tiller.Tiller.TestReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "hapi.services.tiller.ReleaseService", "RunReleaseTest"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.TestReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  hapi.services.tiller.Tiller.TestReleaseResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ReleaseServiceMethodDescriptorSupplier("RunReleaseTest"))
                  .build();
          }
        }
     }
     return getRunReleaseTestMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ReleaseServiceStub newStub(io.grpc.Channel channel) {
    return new ReleaseServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ReleaseServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ReleaseServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ReleaseServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ReleaseServiceFutureStub(channel);
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static abstract class ReleaseServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public void listReleases(hapi.services.tiller.Tiller.ListReleasesRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListReleasesMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public void getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetReleaseStatusMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public void getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetReleaseContentMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public void updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateReleaseMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public void installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getInstallReleaseMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public void uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUninstallReleaseMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public void getVersion(hapi.services.tiller.Tiller.GetVersionRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetVersionMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public void rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRollbackReleaseMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public void getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetHistoryMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public void runReleaseTest(hapi.services.tiller.Tiller.TestReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRunReleaseTestMethodHelper(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getListReleasesMethodHelper(),
            asyncServerStreamingCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.ListReleasesRequest,
                hapi.services.tiller.Tiller.ListReleasesResponse>(
                  this, METHODID_LIST_RELEASES)))
          .addMethod(
            getGetReleaseStatusMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetReleaseStatusRequest,
                hapi.services.tiller.Tiller.GetReleaseStatusResponse>(
                  this, METHODID_GET_RELEASE_STATUS)))
          .addMethod(
            getGetReleaseContentMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetReleaseContentRequest,
                hapi.services.tiller.Tiller.GetReleaseContentResponse>(
                  this, METHODID_GET_RELEASE_CONTENT)))
          .addMethod(
            getUpdateReleaseMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.UpdateReleaseRequest,
                hapi.services.tiller.Tiller.UpdateReleaseResponse>(
                  this, METHODID_UPDATE_RELEASE)))
          .addMethod(
            getInstallReleaseMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.InstallReleaseRequest,
                hapi.services.tiller.Tiller.InstallReleaseResponse>(
                  this, METHODID_INSTALL_RELEASE)))
          .addMethod(
            getUninstallReleaseMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.UninstallReleaseRequest,
                hapi.services.tiller.Tiller.UninstallReleaseResponse>(
                  this, METHODID_UNINSTALL_RELEASE)))
          .addMethod(
            getGetVersionMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetVersionRequest,
                hapi.services.tiller.Tiller.GetVersionResponse>(
                  this, METHODID_GET_VERSION)))
          .addMethod(
            getRollbackReleaseMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.RollbackReleaseRequest,
                hapi.services.tiller.Tiller.RollbackReleaseResponse>(
                  this, METHODID_ROLLBACK_RELEASE)))
          .addMethod(
            getGetHistoryMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.GetHistoryRequest,
                hapi.services.tiller.Tiller.GetHistoryResponse>(
                  this, METHODID_GET_HISTORY)))
          .addMethod(
            getRunReleaseTestMethodHelper(),
            asyncServerStreamingCall(
              new MethodHandlers<
                hapi.services.tiller.Tiller.TestReleaseRequest,
                hapi.services.tiller.Tiller.TestReleaseResponse>(
                  this, METHODID_RUN_RELEASE_TEST)))
          .build();
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceStub extends io.grpc.stub.AbstractStub<ReleaseServiceStub> {
    private ReleaseServiceStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public void listReleases(hapi.services.tiller.Tiller.ListReleasesRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getListReleasesMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public void getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetReleaseStatusMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public void getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetReleaseContentMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public void updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateReleaseMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public void installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getInstallReleaseMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public void uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUninstallReleaseMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public void getVersion(hapi.services.tiller.Tiller.GetVersionRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetVersionMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public void rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRollbackReleaseMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public void getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetHistoryMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public void runReleaseTest(hapi.services.tiller.Tiller.TestReleaseRequest request,
        io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getRunReleaseTestMethodHelper(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceBlockingStub extends io.grpc.stub.AbstractStub<ReleaseServiceBlockingStub> {
    private ReleaseServiceBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * ListReleases retrieves release history.
     * TODO: Allow filtering the set of releases by
     * release status. By default, ListAllReleases returns the releases who
     * current status is "Active".
     * </pre>
     */
    public java.util.Iterator<hapi.services.tiller.Tiller.ListReleasesResponse> listReleases(
        hapi.services.tiller.Tiller.ListReleasesRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getListReleasesMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetReleaseStatusResponse getReleaseStatus(hapi.services.tiller.Tiller.GetReleaseStatusRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetReleaseStatusMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetReleaseContentResponse getReleaseContent(hapi.services.tiller.Tiller.GetReleaseContentRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetReleaseContentMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public hapi.services.tiller.Tiller.UpdateReleaseResponse updateRelease(hapi.services.tiller.Tiller.UpdateReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateReleaseMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.InstallReleaseResponse installRelease(hapi.services.tiller.Tiller.InstallReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), getInstallReleaseMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public hapi.services.tiller.Tiller.UninstallReleaseResponse uninstallRelease(hapi.services.tiller.Tiller.UninstallReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), getUninstallReleaseMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetVersionResponse getVersion(hapi.services.tiller.Tiller.GetVersionRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetVersionMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public hapi.services.tiller.Tiller.RollbackReleaseResponse rollbackRelease(hapi.services.tiller.Tiller.RollbackReleaseRequest request) {
      return blockingUnaryCall(
          getChannel(), getRollbackReleaseMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public hapi.services.tiller.Tiller.GetHistoryResponse getHistory(hapi.services.tiller.Tiller.GetHistoryRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetHistoryMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RunReleaseTest executes the tests defined of a named release
     * </pre>
     */
    public java.util.Iterator<hapi.services.tiller.Tiller.TestReleaseResponse> runReleaseTest(
        hapi.services.tiller.Tiller.TestReleaseRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getRunReleaseTestMethodHelper(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * ReleaseService is the service that a helm application uses to mutate,
   * query, and manage releases.
   *		Release: A named installation composed of a chart and
   * 				 config. At any given time a release has one
   *				 chart and one config.
   *		Config:  A config is a YAML file that supplies values
   *				 to the parametrizable templates of a chart.
   *		Chart:   A chart is a helm package that contains
   *				 metadata, a default config, zero or more
   *				 optionally parameterizable templates, and
   *				 zero or more charts (dependencies).
   * </pre>
   */
  public static final class ReleaseServiceFutureStub extends io.grpc.stub.AbstractStub<ReleaseServiceFutureStub> {
    private ReleaseServiceFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ReleaseServiceFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ReleaseServiceFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ReleaseServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * GetReleasesStatus retrieves status information for the specified release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetReleaseStatusResponse> getReleaseStatus(
        hapi.services.tiller.Tiller.GetReleaseStatusRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetReleaseStatusMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * GetReleaseContent retrieves the release content (chart + value) for the specified release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetReleaseContentResponse> getReleaseContent(
        hapi.services.tiller.Tiller.GetReleaseContentRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetReleaseContentMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UpdateRelease updates release content.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.UpdateReleaseResponse> updateRelease(
        hapi.services.tiller.Tiller.UpdateReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateReleaseMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * InstallRelease requests installation of a chart as a new release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.InstallReleaseResponse> installRelease(
        hapi.services.tiller.Tiller.InstallReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getInstallReleaseMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * UninstallRelease requests deletion of a named release.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.UninstallReleaseResponse> uninstallRelease(
        hapi.services.tiller.Tiller.UninstallReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUninstallReleaseMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * GetVersion returns the current version of the server.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetVersionResponse> getVersion(
        hapi.services.tiller.Tiller.GetVersionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetVersionMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RollbackRelease rolls back a release to a previous version.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.RollbackReleaseResponse> rollbackRelease(
        hapi.services.tiller.Tiller.RollbackReleaseRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRollbackReleaseMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ReleaseHistory retrieves a releasse's history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<hapi.services.tiller.Tiller.GetHistoryResponse> getHistory(
        hapi.services.tiller.Tiller.GetHistoryRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetHistoryMethodHelper(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_RELEASES = 0;
  private static final int METHODID_GET_RELEASE_STATUS = 1;
  private static final int METHODID_GET_RELEASE_CONTENT = 2;
  private static final int METHODID_UPDATE_RELEASE = 3;
  private static final int METHODID_INSTALL_RELEASE = 4;
  private static final int METHODID_UNINSTALL_RELEASE = 5;
  private static final int METHODID_GET_VERSION = 6;
  private static final int METHODID_ROLLBACK_RELEASE = 7;
  private static final int METHODID_GET_HISTORY = 8;
  private static final int METHODID_RUN_RELEASE_TEST = 9;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ReleaseServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ReleaseServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_RELEASES:
          serviceImpl.listReleases((hapi.services.tiller.Tiller.ListReleasesRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.ListReleasesResponse>) responseObserver);
          break;
        case METHODID_GET_RELEASE_STATUS:
          serviceImpl.getReleaseStatus((hapi.services.tiller.Tiller.GetReleaseStatusRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseStatusResponse>) responseObserver);
          break;
        case METHODID_GET_RELEASE_CONTENT:
          serviceImpl.getReleaseContent((hapi.services.tiller.Tiller.GetReleaseContentRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetReleaseContentResponse>) responseObserver);
          break;
        case METHODID_UPDATE_RELEASE:
          serviceImpl.updateRelease((hapi.services.tiller.Tiller.UpdateReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UpdateReleaseResponse>) responseObserver);
          break;
        case METHODID_INSTALL_RELEASE:
          serviceImpl.installRelease((hapi.services.tiller.Tiller.InstallReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.InstallReleaseResponse>) responseObserver);
          break;
        case METHODID_UNINSTALL_RELEASE:
          serviceImpl.uninstallRelease((hapi.services.tiller.Tiller.UninstallReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.UninstallReleaseResponse>) responseObserver);
          break;
        case METHODID_GET_VERSION:
          serviceImpl.getVersion((hapi.services.tiller.Tiller.GetVersionRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetVersionResponse>) responseObserver);
          break;
        case METHODID_ROLLBACK_RELEASE:
          serviceImpl.rollbackRelease((hapi.services.tiller.Tiller.RollbackReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.RollbackReleaseResponse>) responseObserver);
          break;
        case METHODID_GET_HISTORY:
          serviceImpl.getHistory((hapi.services.tiller.Tiller.GetHistoryRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.GetHistoryResponse>) responseObserver);
          break;
        case METHODID_RUN_RELEASE_TEST:
          serviceImpl.runReleaseTest((hapi.services.tiller.Tiller.TestReleaseRequest) request,
              (io.grpc.stub.StreamObserver<hapi.services.tiller.Tiller.TestReleaseResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ReleaseServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ReleaseServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return hapi.services.tiller.Tiller.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ReleaseService");
    }
  }

  private static final class ReleaseServiceFileDescriptorSupplier
      extends ReleaseServiceBaseDescriptorSupplier {
    ReleaseServiceFileDescriptorSupplier() {}
  }

  private static final class ReleaseServiceMethodDescriptorSupplier
      extends ReleaseServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ReleaseServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ReleaseServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ReleaseServiceFileDescriptorSupplier())
              .addMethod(getListReleasesMethodHelper())
              .addMethod(getGetReleaseStatusMethodHelper())
              .addMethod(getGetReleaseContentMethodHelper())
              .addMethod(getUpdateReleaseMethodHelper())
              .addMethod(getInstallReleaseMethodHelper())
              .addMethod(getUninstallReleaseMethodHelper())
              .addMethod(getGetVersionMethodHelper())
              .addMethod(getRollbackReleaseMethodHelper())
              .addMethod(getGetHistoryMethodHelper())
              .addMethod(getRunReleaseTestMethodHelper())
              .build();
        }
      }
    }
    return result;
  }
}
