/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jackson.cdi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;

public final class JacksonCdiExtension
implements Extension {
    private final Set<Set<Annotation>> qualifierSets = new HashSet<Set<Annotation>>();

    private final <T, X extends ObjectMapper> void processInjectionPoint(@Observes ProcessInjectionPoint<T, X> event) {
        Objects.requireNonNull(event);
        InjectionPoint injectionPoint = event.getInjectionPoint();
        if (injectionPoint != null) {
            this.qualifierSets.add(injectionPoint.getQualifiers());
        }
    }

    private final void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        for (Set<Annotation> qualifiers : this.qualifierSets) {
            Annotation[] qualifiersArray = qualifiers == null || qualifiers.isEmpty() ? null : qualifiers.toArray(new Annotation[qualifiers.size()]);
            if (!JacksonCdiExtension.noBeans(beanManager, ObjectMapper.class, qualifiersArray)) continue;
            event.addBean().scope(ApplicationScoped.class).addTransitiveTypeClosure(ObjectMapper.class).qualifiers(qualifiers).createWith(cc -> JacksonCdiExtension.createObjectMapper(beanManager, qualifiersArray));
        }
        this.qualifierSets.clear();
    }

    private static final ObjectMapper createObjectMapper(BeanManager beanManager, Annotation[] qualifiersArray) {
        Objects.requireNonNull(beanManager);
        ObjectMapper returnValue = new ObjectMapper();
        returnValue.findAndRegisterModules();
        beanManager.getEvent().select(ObjectMapper.class, qualifiersArray).fire((Object)returnValue);
        return returnValue;
    }

    private static final boolean noBeans(BeanManager beanManager, Type type, Annotation[] qualifiersArray) {
        Collection beans = beanManager != null && type != null ? (qualifiersArray == null || qualifiersArray.length <= 0 ? beanManager.getBeans(type, new Annotation[0]) : beanManager.getBeans(type, qualifiersArray)) : null;
        return beans == null || beans.isEmpty();
    }
}

