/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jpa.org.eclipse.persistence.platform.server.cdi;

import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import org.eclipse.persistence.platform.server.JMXServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.JTATransactionController;

public class CDISEPlatform
extends JMXServerPlatformBase {
    private final Executor executor;
    private volatile Instance<MBeanServer> mBeanServerInstance;

    public CDISEPlatform(DatabaseSession session) {
        super(session);
        Instance executorInstance;
        CDI cdi = CDI.current();
        assert (cdi != null);
        if (!cdi.select(TransactionManager.class, new Annotation[0]).isResolvable()) {
            this.disableJTA();
        }
        this.executor = (executorInstance = cdi.select(Executor.class, new Annotation[0])) == null || !executorInstance.isResolvable() ? null : (Executor)executorInstance.get();
    }

    public boolean isRuntimeServicesEnabledDefault() {
        boolean returnValue;
        Instance instance = this.mBeanServerInstance;
        if (instance == null) {
            instance = CDI.current().select(MBeanServer.class, new Annotation[0]);
            assert (instance != null);
            if (instance.isResolvable()) {
                this.mBeanServerInstance = instance;
                returnValue = true;
            } else {
                returnValue = false;
            }
        } else {
            returnValue = instance.isResolvable();
        }
        return returnValue;
    }

    public MBeanServer getMBeanServer() {
        Instance<MBeanServer> instance;
        if (this.mBeanServer == null && (instance = this.mBeanServerInstance) != null && instance.isResolvable()) {
            this.mBeanServer = (MBeanServer)instance.get();
        }
        return super.getMBeanServer();
    }

    public void launchContainerRunnable(Runnable runnable) {
        if (runnable != null && this.executor != null) {
            this.executor.execute(runnable);
        } else {
            super.launchContainerRunnable(runnable);
        }
    }

    public final Class<?> getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = TransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    public final int getJNDIConnectorLookupType() {
        return -1;
    }

    public static final class TransactionController
    extends JTATransactionController {
        protected final TransactionManager acquireTransactionManager() {
            return (TransactionManager)CDI.current().select(TransactionManager.class, new Annotation[0]).get();
        }
    }
}

