/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jpa.weld;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.microbean.development.annotation.Issue;

@Issue(id="WELD-2563", uri="https://issues.jboss.org/browse/WELD-2563")
public final class JpaInjectionServices
implements org.jboss.weld.injection.spi.JpaInjectionServices {
    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    static volatile @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563") JpaInjectionServices INSTANCE;
    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    private static volatile @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563") boolean UNDERWAY;
    private final Set<EntityManager> ems;
    private volatile Map<String, EntityManagerFactory> emfs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpaInjectionServices() {
        Class<JpaInjectionServices> clazz = JpaInjectionServices.class;
        synchronized (JpaInjectionServices.class) {
            if (INSTANCE != null && UNDERWAY) {
                throw new IllegalStateException();
            }
            INSTANCE = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.ems = ConcurrentHashMap.newKeySet();
            return;
        }
    }

    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    private static final synchronized void underway() {
        assert (INSTANCE != null);
        UNDERWAY = true;
    }

    final void jtaTransactionBegun(Object transaction) {
        if (this != INSTANCE) {
            INSTANCE.jtaTransactionBegun(transaction);
        } else if (transaction != null) {
            this.ems.forEach(em -> em.joinTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        ResourceReferenceFactory returnValue;
        JpaInjectionServices.underway();
        if (this != INSTANCE) {
            returnValue = INSTANCE.registerPersistenceContextInjectionPoint(injectionPoint);
        } else {
            Objects.requireNonNull(injectionPoint);
            Annotated annotatedMember = injectionPoint.getAnnotated();
            assert (annotatedMember != null);
            PersistenceContext persistenceContextAnnotation = (PersistenceContext)annotatedMember.getAnnotation(PersistenceContext.class);
            if (persistenceContextAnnotation == null) {
                throw new IllegalArgumentException("injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class) == null");
            }
            String n = persistenceContextAnnotation.unitName();
            String name = n.isEmpty() ? (annotatedMember instanceof AnnotatedField ? ((AnnotatedField)annotatedMember).getJavaMember().getName() : n) : n;
            SynchronizationType synchronizationType = persistenceContextAnnotation.synchronization();
            assert (synchronizationType != null);
            JpaInjectionServices jpaInjectionServices = this;
            synchronized (jpaInjectionServices) {
                if (this.emfs == null) {
                    this.emfs = new ConcurrentHashMap<String, EntityManagerFactory>();
                }
            }
            returnValue = () -> new EntityManagerResourceReference(name, synchronizationType);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        ResourceReferenceFactory returnValue;
        JpaInjectionServices.underway();
        if (this != INSTANCE) {
            returnValue = INSTANCE.registerPersistenceUnitInjectionPoint(injectionPoint);
        } else {
            Objects.requireNonNull(injectionPoint);
            Annotated annotatedMember = injectionPoint.getAnnotated();
            assert (annotatedMember != null);
            PersistenceUnit persistenceUnitAnnotation = (PersistenceUnit)annotatedMember.getAnnotation(PersistenceUnit.class);
            if (persistenceUnitAnnotation == null) {
                throw new IllegalArgumentException("injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class) == null");
            }
            String n = persistenceUnitAnnotation.unitName();
            String name = n.isEmpty() ? (annotatedMember instanceof AnnotatedField ? ((AnnotatedField)annotatedMember).getJavaMember().getName() : n) : n;
            JpaInjectionServices jpaInjectionServices = this;
            synchronized (jpaInjectionServices) {
                if (this.emfs == null) {
                    this.emfs = new ConcurrentHashMap<String, EntityManagerFactory>();
                }
            }
            returnValue = () -> new EntityManagerFactoryResourceReference(this.emfs, name);
        }
        return returnValue;
    }

    public final void cleanup() {
        JpaInjectionServices.underway();
        if (this != INSTANCE) {
            INSTANCE.cleanup();
        } else {
            this.ems.clear();
            Map<String, EntityManagerFactory> emfs = this.emfs;
            if (emfs != null && !emfs.isEmpty()) {
                Set<Map.Entry<String, EntityManagerFactory>> entries = emfs.entrySet();
                assert (entries != null);
                assert (!entries.isEmpty());
                Iterator iterator = entries.iterator();
                assert (iterator != null);
                assert (iterator.hasNext());
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    assert (entry != null);
                    EntityManagerFactory emf = (EntityManagerFactory)entry.getValue();
                    assert (emf != null);
                    if (emf.isOpen()) {
                        emf.close();
                    }
                    iterator.remove();
                }
            }
        }
    }

    @Deprecated
    public final EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        return (EntityManager)this.registerPersistenceContextInjectionPoint(injectionPoint).createResource().getInstance();
    }

    @Deprecated
    public final EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        return (EntityManagerFactory)this.registerPersistenceUnitInjectionPoint(injectionPoint).createResource().getInstance();
    }

    private static final PersistenceProvider getPersistenceProvider(PersistenceUnitInfo persistenceUnitInfo) {
        PersistenceProvider persistenceProvider;
        String providerClassName = Objects.requireNonNull(persistenceUnitInfo).getPersistenceProviderClassName();
        if (providerClassName == null) {
            persistenceProvider = (PersistenceProvider)CDI.current().select(PersistenceProvider.class, new Annotation[0]).get();
        } else {
            try {
                persistenceProvider = (PersistenceProvider)CDI.current().select(Class.forName(providerClassName, true, Thread.currentThread().getContextClassLoader()), new Annotation[0]).get();
            }
            catch (ReflectiveOperationException exception) {
                throw new PersistenceException(exception.getMessage(), (Throwable)exception);
            }
        }
        return persistenceProvider;
    }

    private static final PersistenceUnitInfo getPersistenceUnitInfo(String name) {
        return (PersistenceUnitInfo)CDI.current().select(PersistenceUnitInfo.class, new Annotation[]{NamedLiteral.of((String)Objects.requireNonNull(name))}).get();
    }

    private static final EntityManagerFactory getOrCreateEntityManagerFactory(Map<String, EntityManagerFactory> emfs, PersistenceUnitInfo persistenceUnitInfo, String name) {
        EntityManagerFactory returnValue;
        Objects.requireNonNull(emfs);
        Objects.requireNonNull(name);
        if (persistenceUnitInfo == null) {
            returnValue = emfs.computeIfAbsent(name, n -> Persistence.createEntityManagerFactory((String)n));
        } else {
            PersistenceProvider persistenceProvider = JpaInjectionServices.getPersistenceProvider(persistenceUnitInfo);
            assert (persistenceProvider != null);
            returnValue = emfs.computeIfAbsent(name, n -> {
                Bean<?> validatorFactoryBean;
                CDI cdi = CDI.current();
                assert (cdi != null);
                BeanManager beanManager = cdi.getBeanManager();
                assert (beanManager != null);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("javax.persistence.bean.manager", beanManager);
                Class<?> validatorFactoryClass = null;
                try {
                    validatorFactoryClass = Class.forName("javax.validation.ValidatorFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                if (validatorFactoryClass != null && (validatorFactoryBean = JpaInjectionServices.getValidatorFactoryBean(beanManager, validatorFactoryClass)) != null) {
                    properties.put("javax.validation.ValidatorFactory", beanManager.getReference(validatorFactoryBean, validatorFactoryClass, beanManager.createCreationalContext(validatorFactoryBean)));
                }
                return persistenceProvider.createContainerEntityManagerFactory(persistenceUnitInfo, properties);
            });
        }
        return returnValue;
    }

    private static final Bean<?> getValidatorFactoryBean(BeanManager beanManager, Class<?> validatorFactoryClass) {
        return JpaInjectionServices.getValidatorFactoryBean(beanManager, validatorFactoryClass, null);
    }

    private static final Bean<?> getValidatorFactoryBean(BeanManager beanManager, Class<?> validatorFactoryClass, Set<Annotation> qualifiers) {
        Set beans;
        Bean returnValue = null;
        if (beanManager != null && validatorFactoryClass != null && (beans = qualifiers == null ? beanManager.getBeans(validatorFactoryClass, new Annotation[0]) : beanManager.getBeans(validatorFactoryClass, qualifiers.toArray(new Annotation[qualifiers.size()]))) != null && !beans.isEmpty()) {
            returnValue = beanManager.resolve(beans);
        }
        return returnValue;
    }

    private final class EntityManagerResourceReference
    implements ResourceReference<EntityManager> {
        private final String name;
        private final SynchronizationType synchronizationType;
        private volatile EntityManager em;

        private EntityManagerResourceReference(String name, SynchronizationType synchronizationType) {
            this.name = Objects.requireNonNull(name);
            this.synchronizationType = Objects.requireNonNull(synchronizationType);
        }

        public final EntityManager getInstance() {
            EntityManager returnValue = this.em;
            if (returnValue == null) {
                PersistenceUnitInfo persistenceUnitInfo = JpaInjectionServices.getPersistenceUnitInfo(this.name);
                assert (persistenceUnitInfo != null);
                if (PersistenceUnitTransactionType.RESOURCE_LOCAL.equals((Object)persistenceUnitInfo.getTransactionType())) {
                    EntityManagerFactory emf = JpaInjectionServices.getOrCreateEntityManagerFactory(JpaInjectionServices.this.emfs, null, this.name);
                    assert (emf != null);
                    returnValue = emf.createEntityManager();
                } else {
                    EntityManagerFactory emf = JpaInjectionServices.getOrCreateEntityManagerFactory(JpaInjectionServices.this.emfs, persistenceUnitInfo, this.name);
                    assert (emf != null);
                    returnValue = emf.createEntityManager(this.synchronizationType);
                }
                assert (returnValue != null);
                this.em = returnValue;
                JpaInjectionServices.this.ems.add(returnValue);
            }
            return returnValue;
        }

        public final void release() {
            EntityManager em = this.em;
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private static final class EntityManagerFactoryResourceReference
    implements ResourceReference<EntityManagerFactory> {
        private final Map<String, EntityManagerFactory> emfs;
        private final String name;

        private EntityManagerFactoryResourceReference(Map<String, EntityManagerFactory> emfs, String name) {
            this.emfs = Objects.requireNonNull(emfs);
            this.name = Objects.requireNonNull(name);
        }

        public final EntityManagerFactory getInstance() {
            PersistenceUnitInfo persistenceUnitInfo = JpaInjectionServices.getPersistenceUnitInfo(this.name);
            assert (persistenceUnitInfo != null);
            EntityManagerFactory returnValue = PersistenceUnitTransactionType.RESOURCE_LOCAL.equals((Object)persistenceUnitInfo.getTransactionType()) ? JpaInjectionServices.getOrCreateEntityManagerFactory(this.emfs, null, this.name) : JpaInjectionServices.getOrCreateEntityManagerFactory(this.emfs, persistenceUnitInfo, this.name);
            return returnValue;
        }

        public final void release() {
            EntityManagerFactory emf = this.emfs.remove(this.name);
            if (emf != null && emf.isOpen()) {
                emf.close();
            }
        }
    }
}

