/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.jpa.weld;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import javax.persistence.SynchronizationType;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.manager.api.WeldManager;
import org.microbean.development.annotation.Issue;

@Issue(id="WELD-2563", uri="https://issues.jboss.org/browse/WELD-2563")
public final class JpaInjectionServices
implements org.jboss.weld.injection.spi.JpaInjectionServices {
    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    static volatile @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563") JpaInjectionServices INSTANCE;
    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    private static volatile @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563") boolean UNDERWAY;
    private final Set<EntityManager> ems;
    private volatile Map<String, EntityManagerFactory> emfs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpaInjectionServices() {
        Class<JpaInjectionServices> clazz = JpaInjectionServices.class;
        synchronized (JpaInjectionServices.class) {
            if (INSTANCE == null) {
                assert (!UNDERWAY);
                INSTANCE = this;
            } else if (UNDERWAY) {
                throw new IllegalStateException();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.ems = ConcurrentHashMap.newKeySet();
            return;
        }
    }

    @Issue(id="WELD_2563", uri="https://issues.jboss.org/browse/WELD-2563")
    private static final synchronized void underway() {
        UNDERWAY = true;
    }

    final void jtaTransactionBegun() {
        assert (this == INSTANCE);
        this.ems.forEach(em -> em.joinTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        JpaInjectionServices.underway();
        assert (this == INSTANCE);
        Objects.requireNonNull(injectionPoint);
        Annotated annotatedMember = injectionPoint.getAnnotated();
        assert (annotatedMember != null);
        PersistenceContext persistenceContextAnnotation = (PersistenceContext)annotatedMember.getAnnotation(PersistenceContext.class);
        if (persistenceContextAnnotation == null) {
            throw new IllegalArgumentException("injectionPoint.getAnnotated().getAnnotation(PersistenceContext.class) == null");
        }
        String n = persistenceContextAnnotation.unitName();
        String name = n.isEmpty() ? (annotatedMember instanceof AnnotatedField ? ((AnnotatedField)annotatedMember).getJavaMember().getName() : n) : n;
        SynchronizationType synchronizationType = persistenceContextAnnotation.synchronization();
        assert (synchronizationType != null);
        JpaInjectionServices jpaInjectionServices = this;
        synchronized (jpaInjectionServices) {
            if (this.emfs == null) {
                this.emfs = new ConcurrentHashMap<String, EntityManagerFactory>();
            }
        }
        ResourceReferenceFactory returnValue = () -> new EntityManagerResourceReference(name, synchronizationType);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        JpaInjectionServices.underway();
        assert (this == INSTANCE);
        Objects.requireNonNull(injectionPoint);
        Annotated annotatedMember = injectionPoint.getAnnotated();
        assert (annotatedMember != null);
        PersistenceUnit persistenceUnitAnnotation = (PersistenceUnit)annotatedMember.getAnnotation(PersistenceUnit.class);
        if (persistenceUnitAnnotation == null) {
            throw new IllegalArgumentException("injectionPoint.getAnnotated().getAnnotation(PersistenceUnit.class) == null");
        }
        String n = persistenceUnitAnnotation.unitName();
        String name = n.isEmpty() ? (annotatedMember instanceof AnnotatedField ? ((AnnotatedField)annotatedMember).getJavaMember().getName() : n) : n;
        JpaInjectionServices jpaInjectionServices = this;
        synchronized (jpaInjectionServices) {
            if (this.emfs == null) {
                this.emfs = new ConcurrentHashMap<String, EntityManagerFactory>();
            }
        }
        ResourceReferenceFactory returnValue = () -> new EntityManagerFactoryResourceReference(this.emfs, name);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanup() {
        if (UNDERWAY) {
            assert (this == INSTANCE);
            this.ems.clear();
            Map<String, EntityManagerFactory> emfs = this.emfs;
            if (emfs != null && !emfs.isEmpty()) {
                Collection<EntityManagerFactory> values = emfs.values();
                assert (values != null);
                assert (!values.isEmpty());
                Iterator<EntityManagerFactory> iterator = values.iterator();
                assert (iterator != null);
                assert (iterator.hasNext());
                while (iterator.hasNext()) {
                    EntityManagerFactory emf = iterator.next();
                    assert (emf != null);
                    if (emf.isOpen()) {
                        emf.close();
                    }
                    iterator.remove();
                }
            }
        }
        assert (this.ems.isEmpty());
        assert (this.emfs == null || this.emfs.isEmpty());
        Class<JpaInjectionServices> clazz = JpaInjectionServices.class;
        synchronized (JpaInjectionServices.class) {
            UNDERWAY = false;
            INSTANCE = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public final EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        return (EntityManager)this.registerPersistenceContextInjectionPoint(injectionPoint).createResource().getInstance();
    }

    @Deprecated
    public final EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        return (EntityManagerFactory)this.registerPersistenceUnitInjectionPoint(injectionPoint).createResource().getInstance();
    }

    private static final PersistenceProvider getPersistenceProvider(PersistenceUnitInfo persistenceUnitInfo) {
        PersistenceProvider persistenceProvider;
        String providerClassName = Objects.requireNonNull(persistenceUnitInfo).getPersistenceProviderClassName();
        if (providerClassName == null) {
            persistenceProvider = (PersistenceProvider)CDI.current().select(PersistenceProvider.class, new Annotation[0]).get();
        } else {
            try {
                persistenceProvider = (PersistenceProvider)CDI.current().select(Class.forName(providerClassName, true, Thread.currentThread().getContextClassLoader()), new Annotation[0]).get();
            }
            catch (ReflectiveOperationException exception) {
                throw new PersistenceException(exception.getMessage(), (Throwable)exception);
            }
        }
        return persistenceProvider;
    }

    private static final PersistenceUnitInfo getPersistenceUnitInfo(String name) {
        return (PersistenceUnitInfo)CDI.current().select(PersistenceUnitInfo.class, new Annotation[]{NamedLiteral.of((String)Objects.requireNonNull(name))}).get();
    }

    private static final EntityManagerFactory getOrCreateEntityManagerFactory(Map<String, EntityManagerFactory> emfs, PersistenceUnitInfo persistenceUnitInfo, String name) {
        EntityManagerFactory returnValue;
        Objects.requireNonNull(emfs);
        Objects.requireNonNull(name);
        if (persistenceUnitInfo == null) {
            returnValue = emfs.computeIfAbsent(name, n -> Persistence.createEntityManagerFactory((String)n));
        } else {
            PersistenceProvider persistenceProvider = JpaInjectionServices.getPersistenceProvider(persistenceUnitInfo);
            assert (persistenceProvider != null);
            returnValue = emfs.computeIfAbsent(name, n -> {
                Bean<?> validatorFactoryBean;
                CDI cdi = CDI.current();
                assert (cdi != null);
                BeanManager beanManager = cdi.getBeanManager();
                assert (beanManager != null);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("javax.persistence.bean.manager", beanManager);
                Class<?> validatorFactoryClass = null;
                try {
                    validatorFactoryClass = Class.forName("javax.validation.ValidatorFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (validatorFactoryClass != null && (validatorFactoryBean = JpaInjectionServices.getValidatorFactoryBean(beanManager, validatorFactoryClass)) != null) {
                    properties.put("javax.validation.ValidatorFactory", beanManager.getReference(validatorFactoryBean, validatorFactoryClass, beanManager.createCreationalContext(validatorFactoryBean)));
                }
                return persistenceProvider.createContainerEntityManagerFactory(persistenceUnitInfo, properties);
            });
        }
        return returnValue;
    }

    private static final Bean<?> getValidatorFactoryBean(BeanManager beanManager, Class<?> validatorFactoryClass) {
        return JpaInjectionServices.getValidatorFactoryBean(beanManager, validatorFactoryClass, null);
    }

    private static final Bean<?> getValidatorFactoryBean(BeanManager beanManager, Class<?> validatorFactoryClass, Set<Annotation> qualifiers) {
        Set beans;
        Bean returnValue = null;
        if (beanManager != null && validatorFactoryClass != null && (beans = qualifiers == null ? beanManager.getBeans(validatorFactoryClass, new Annotation[0]) : beanManager.getBeans(validatorFactoryClass, qualifiers.toArray(new Annotation[qualifiers.size()]))) != null && !beans.isEmpty()) {
            returnValue = beanManager.resolve(beans);
        }
        return returnValue;
    }

    private final class EntityManagerResourceReference
    implements ResourceReference<EntityManager> {
        private final String name;
        private final SynchronizationType synchronizationType;
        private final PersistenceUnitInfo persistenceUnitInfo;
        private EntityManager em;
        private final Future<EntityManagerFactory> emfFuture;
        private final Supplier<EntityManager> emSupplier;

        private EntityManagerResourceReference(String name, SynchronizationType synchronizationType) {
            this.name = Objects.requireNonNull(name);
            this.synchronizationType = Objects.requireNonNull(synchronizationType);
            this.persistenceUnitInfo = JpaInjectionServices.getPersistenceUnitInfo(name);
            assert (this.persistenceUnitInfo != null);
            ExecutorService taskExecutorService = ((ExecutorServices)((WeldManager)CDI.current().getBeanManager()).getServices().get(ExecutorServices.class)).getTaskExecutor();
            assert (taskExecutorService != null);
            if (this.isResourceLocal()) {
                this.emfFuture = taskExecutorService.submit(() -> JpaInjectionServices.getOrCreateEntityManagerFactory(JpaInjectionServices.this.emfs, null, this.name));
                this.emSupplier = () -> {
                    try {
                        return this.emfFuture.get().createEntityManager();
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException.getMessage(), executionException);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interruptedException.getMessage(), interruptedException);
                    }
                };
            } else {
                this.emfFuture = taskExecutorService.submit(() -> JpaInjectionServices.getOrCreateEntityManagerFactory(JpaInjectionServices.this.emfs, this.persistenceUnitInfo, this.name));
                this.emSupplier = () -> {
                    try {
                        EntityManager em = this.emfFuture.get().createEntityManager(this.synchronizationType);
                        JpaInjectionServices.this.ems.add(em);
                        return em;
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException.getMessage(), executionException);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(interruptedException.getMessage(), interruptedException);
                    }
                };
            }
        }

        private final boolean isResourceLocal() {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL.equals((Object)this.persistenceUnitInfo.getTransactionType());
        }

        public final synchronized EntityManager getInstance() {
            if (this.em == null) {
                this.em = this.emSupplier.get();
            }
            return this.em;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void release() {
            EntityManager em;
            EntityManagerResourceReference entityManagerResourceReference = this;
            synchronized (entityManagerResourceReference) {
                em = this.em;
                this.em = null;
            }
            if (em != null) {
                if (em.isOpen() && this.isResourceLocal()) {
                    em.close();
                }
                JpaInjectionServices.this.ems.remove(em);
            }
            if (!this.emfFuture.isDone()) {
                this.emfFuture.cancel(true);
            }
        }
    }

    private static final class EntityManagerFactoryResourceReference
    implements ResourceReference<EntityManagerFactory> {
        private final Map<String, EntityManagerFactory> emfs;
        private final String name;
        private final PersistenceUnitInfo persistenceUnitInfo;

        private EntityManagerFactoryResourceReference(Map<String, EntityManagerFactory> emfs, String name) {
            this.emfs = Objects.requireNonNull(emfs);
            this.name = Objects.requireNonNull(name);
            this.persistenceUnitInfo = JpaInjectionServices.getPersistenceUnitInfo(name);
            assert (this.persistenceUnitInfo != null);
        }

        public final EntityManagerFactory getInstance() {
            EntityManagerFactory returnValue = PersistenceUnitTransactionType.RESOURCE_LOCAL.equals((Object)this.persistenceUnitInfo.getTransactionType()) ? JpaInjectionServices.getOrCreateEntityManagerFactory(this.emfs, null, this.name) : JpaInjectionServices.getOrCreateEntityManagerFactory(this.emfs, this.persistenceUnitInfo, this.name);
            return returnValue;
        }

        public final void release() {
            EntityManagerFactory emf = this.emfs.remove(this.name);
            if (emf != null && emf.isOpen()) {
                emf.close();
            }
        }
    }
}

