/*
 * Decompiled with CFR 0.152.
 */
package org.microg.wearable;

import java.io.IOException;
import org.microg.wearable.MessageListener;
import org.microg.wearable.WearableConnection;
import org.microg.wearable.proto.Connect;
import org.microg.wearable.proto.RootMessage;

public abstract class ServerMessageListener
extends MessageListener {
    private Connect localConnect;
    private Connect remoteConnect;

    public ServerMessageListener(Connect localConnect) {
        this.localConnect = localConnect;
    }

    @Override
    public void onConnected(WearableConnection connection) {
        super.onConnected(connection);
        try {
            connection.writeMessage(new RootMessage.Builder().connect(this.localConnect).build());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onDisconnected() {
        super.onDisconnected();
        this.remoteConnect = null;
    }

    @Override
    public void onConnect(Connect connect) {
        this.remoteConnect = connect;
    }

    public Connect getRemoteConnect() {
        return this.remoteConnect;
    }
}

