/*
 * Decompiled with CFR 0.152.
 */
package org.microg.wearable;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.microg.wearable.SocketWearableConnection;
import org.microg.wearable.WearableConnection;

public abstract class SocketConnectionThread
extends Thread {
    private SocketWearableConnection wearableConnection;

    private SocketConnectionThread() {
    }

    protected void setWearableConnection(SocketWearableConnection wearableConnection) {
        this.wearableConnection = wearableConnection;
    }

    public SocketWearableConnection getWearableConnection() {
        return this.wearableConnection;
    }

    public abstract void close();

    public static SocketConnectionThread serverListen(final int port, final WearableConnection.Listener listener) {
        return new SocketConnectionThread(){
            private ServerSocket serverSocket;
            {
                this.serverSocket = null;
            }

            @Override
            public void close() {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.serverSocket = null;
                }
            }

            @Override
            public void run() {
                try {
                    Socket socket;
                    this.serverSocket = new ServerSocket(port);
                    while ((socket = this.serverSocket.accept()) != null && !Thread.interrupted()) {
                        SocketWearableConnection connection = new SocketWearableConnection(socket, listener);
                        this.setWearableConnection(connection);
                        connection.run();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
    }

    public static SocketConnectionThread clientConnect(final int port, final WearableConnection.Listener listener) {
        return new SocketConnectionThread(){
            private Socket socket;

            @Override
            public void close() {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }

            @Override
            public void run() {
                try {
                    this.socket = new Socket("127.0.0.1", port);
                    SocketWearableConnection connection = new SocketWearableConnection(this.socket, listener);
                    this.setWearableConnection(connection);
                    connection.run();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
    }
}

