/*
 * Decompiled with CFR 0.152.
 */
package org.microg.wearable;

import com.squareup.wire.Wire;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.microg.wearable.WearableConnection;
import org.microg.wearable.proto.MessagePiece;

public class SocketWearableConnection
extends WearableConnection {
    private final int MAX_PIECE_SIZE = 0x1400000;
    private final Socket socket;
    private final DataInputStream is;
    private final DataOutputStream os;

    public SocketWearableConnection(Socket socket, WearableConnection.Listener listener) throws IOException {
        super(listener);
        this.socket = socket;
        this.is = new DataInputStream(socket.getInputStream());
        this.os = new DataOutputStream(socket.getOutputStream());
    }

    @Override
    protected void writeMessagePiece(MessagePiece piece) throws IOException {
        byte[] bytes = piece.toByteArray();
        this.os.writeInt(bytes.length);
        this.os.write(bytes);
    }

    @Override
    protected MessagePiece readMessagePiece() throws IOException {
        int len = this.is.readInt();
        if (len > 0x1400000) {
            throw new IOException("Piece size " + len + " exceeded limit of " + 0x1400000 + " bytes.");
        }
        System.out.println("Reading piece of length " + len);
        byte[] bytes = new byte[len];
        this.is.readFully(bytes);
        return (MessagePiece)new Wire(new Class[0]).parseFrom(bytes, MessagePiece.class);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

