/*
 * Decompiled with CFR 0.152.
 */
package org.microg.wearable;

import com.squareup.wire.Wire;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okio.ByteString;
import org.microg.wearable.proto.MessagePiece;
import org.microg.wearable.proto.RootMessage;

public abstract class WearableConnection
implements Runnable {
    private static String B64ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    protected static Wire wire = new Wire(new Class[0]);
    private HashMap<Integer, List<MessagePiece>> piecesQueues = new HashMap();
    private final Listener listener;

    public WearableConnection(Listener listener) {
        this.listener = listener;
    }

    public static String base64encode(byte[] bytes) {
        int paddingCount = (3 - bytes.length % 3) % 3;
        byte[] padded = new byte[bytes.length + paddingCount];
        System.arraycopy(bytes, 0, padded, 0, bytes.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i += 3) {
            int j = ((padded[i] & 0xFF) << 16) + ((padded[i + 1] & 0xFF) << 8) + (padded[i + 2] & 0xFF);
            sb.append(B64ALPHABET.charAt(j >> 18 & 0x3F)).append(B64ALPHABET.charAt(j >> 12 & 0x3F)).append(B64ALPHABET.charAt(j >> 6 & 0x3F)).append(B64ALPHABET.charAt(j & 0x3F));
        }
        return sb.substring(0, sb.length() - paddingCount);
    }

    public static String calculateDigest(byte[] bytes) {
        try {
            return WearableConnection.base64encode(MessageDigest.getInstance("SHA1").digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1 not supported => platform not supported");
        }
    }

    public void writeMessage(RootMessage message) throws IOException {
        byte[] bytes = message.toByteArray();
        this.writeMessagePiece(new MessagePiece.Builder().data(ByteString.of((byte[])bytes)).digest(WearableConnection.calculateDigest(bytes)).thisPiece(1).totalPieces(1).build());
    }

    protected abstract void writeMessagePiece(MessagePiece var1) throws IOException;

    protected RootMessage readMessage() throws IOException {
        List<MessagePiece> queue;
        MessagePiece piece;
        while (true) {
            System.out.println("Waiting for new message...");
            piece = this.readMessagePiece();
            if (piece.totalPieces == 1) {
                return (RootMessage)wire.parseFrom(piece.data.toByteArray(), RootMessage.class);
            }
            if (piece.thisPiece == 1) {
                queue = this.piecesQueues.get(piece.queueId);
                String oldDigest = null;
                if (queue != null) {
                    oldDigest = queue.get((int)0).digest;
                }
                queue = new ArrayList<MessagePiece>(piece.totalPieces);
                queue.add(piece);
                this.piecesQueues.put(piece.queueId, queue);
                if (oldDigest == null) continue;
                throw new IOException("Could not finish message of digest " + oldDigest + ", queue is used for newer messagee");
            }
            queue = this.piecesQueues.get(piece.queueId);
            if (queue == null || !queue.get((int)0).digest.equals(piece.digest)) {
                throw new IOException("Received " + piece.thisPiece + " before first piece.");
            }
            if (queue.size() + 1 != piece.thisPiece) {
                throw new IOException("Received " + piece.thisPiece + " but expected piece" + queue.size() + 1);
            }
            queue.add(piece);
            if (piece.thisPiece.equals(piece.totalPieces)) break;
        }
        this.piecesQueues.remove(piece.queueId);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (MessagePiece messagePiece : queue) {
            messagePiece.data.write((OutputStream)bos);
        }
        byte[] bytes = bos.toByteArray();
        if (!WearableConnection.calculateDigest(bytes).equals(piece.digest)) {
            throw new IOException("Merged pieces have digest " + WearableConnection.calculateDigest(bytes) + ", but should be " + piece.digest);
        }
        return (RootMessage)wire.parseFrom(bytes, RootMessage.class);
    }

    protected abstract MessagePiece readMessagePiece() throws IOException;

    public abstract void close() throws IOException;

    @Override
    public void run() {
        try {
            RootMessage message;
            this.listener.onConnected(this);
            while ((message = this.readMessage()) != null) {
                this.listener.onMessage(this, message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("WearableConnection closed");
        this.listener.onDisconnected();
    }

    public static interface Listener {
        public void onConnected(WearableConnection var1);

        public void onMessage(WearableConnection var1, RootMessage var2);

        public void onDisconnected();
    }
}

