/*
 * Decompiled with CFR 0.152.
 */
package org.microjservice.lark.core.event;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.HttpServerException;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.microjservice.lark.core.event.crypto.EncryptedRequest;
import org.microjservice.lark.core.event.crypto.NotifyDataDecrypter;
import org.microjservice.lark.core.event.v1.model.BaseEventRequest;
import org.microjservice.lark.core.event.v2.EventService;
import org.microjservice.lark.core.event.v2.model.EventRequest;
import org.slf4j.Logger;

@io.micronaut.http.annotation.Controller
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\u00012\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/microjservice/lark/core/event/Controller;", "", "notifyDataDecrypter", "Lorg/microjservice/lark/core/event/crypto/NotifyDataDecrypter;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "eventService", "Lorg/microjservice/lark/core/event/v1/EventService;", "eventServiceV2", "Lorg/microjservice/lark/core/event/v2/EventService;", "(Lorg/microjservice/lark/core/event/crypto/NotifyDataDecrypter;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/microjservice/lark/core/event/v1/EventService;Lorg/microjservice/lark/core/event/v2/EventService;)V", "logger", "Lorg/slf4j/Logger;", "event", "eventRequest", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonError", "Lio/micronaut/http/HttpResponse;", "Lio/micronaut/http/hateoas/JsonError;", "request", "Lio/micronaut/http/HttpRequest;", "e", "Lcom/fasterxml/jackson/core/JsonParseException;", "Companion", "lark-api"})
public final class Controller {
    private final Logger logger;
    private final NotifyDataDecrypter notifyDataDecrypter;
    private final ObjectMapper objectMapper;
    private final org.microjservice.lark.core.event.v1.EventService eventService;
    private final EventService eventServiceV2;
    private static final String SUCCESS = "SUCCESS";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Error
    @NotNull
    public final HttpResponse<JsonError> jsonError(@NotNull HttpRequest<?> request, @NotNull JsonParseException e) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.printStackTrace();
        JsonError error = (JsonError)new JsonError("Invalid JSON: " + e.getMessage()).link(Link.SELF, Link.of((URI)request.getUri()));
        MutableHttpResponse mutableHttpResponse = HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Fix Your JSON").body((Object)error);
        Intrinsics.checkNotNullExpressionValue((Object)mutableHttpResponse, (String)"HttpResponse.status<Json\u2026\n            .body(error)");
        return (HttpResponse)mutableHttpResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Post(value="/lark/event", produces={"application/json"})
    @NotNull
    public final Object event(@EncryptedRequest @NotNull JsonNode eventRequest) {
        MutableHttpResponse mutableHttpResponse;
        Intrinsics.checkNotNullParameter((Object)eventRequest, (String)"eventRequest");
        this.logger.info("Receive {}", (Object)eventRequest);
        JsonNode jsonNode = eventRequest.get("type");
        if (Intrinsics.areEqual((Object)BaseEventRequest.Type.URL_VERIFICATION.getTypeName(), (Object)(jsonNode != null ? jsonNode.asText() : null))) {
            return eventRequest;
        }
        JsonNode jsonNode2 = eventRequest.get("type");
        if (jsonNode2 == null) {
            String string = eventRequest.get("schema").asText();
            if (!Intrinsics.areEqual((Object)string, (Object)EventRequest.SCHEMA.VERSION2.getValue())) throw (Throwable)new HttpServerException("Unknown event type!");
            this.eventServiceV2.dispatch(eventRequest);
            mutableHttpResponse = Unit.INSTANCE;
        } else {
            this.eventService.dispatch(eventRequest);
            mutableHttpResponse = HttpResponse.ok((Object)SUCCESS);
        }
        Intrinsics.checkNotNullExpressionValue((Object)mutableHttpResponse, (String)"when (eventRequest.get(B\u2026\n            }\n\n        }");
        return mutableHttpResponse;
    }

    public Controller(@NotNull NotifyDataDecrypter notifyDataDecrypter, @NotNull ObjectMapper objectMapper, @NotNull org.microjservice.lark.core.event.v1.EventService eventService, @NotNull EventService eventServiceV2) {
        Intrinsics.checkNotNullParameter((Object)notifyDataDecrypter, (String)"notifyDataDecrypter");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        Intrinsics.checkNotNullParameter((Object)eventServiceV2, (String)"eventServiceV2");
        this.notifyDataDecrypter = notifyDataDecrypter;
        this.objectMapper = objectMapper;
        this.eventService = eventService;
        this.eventServiceV2 = eventServiceV2;
        Logger logger = ClassUtils.REFLECTION_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"ClassUtils.REFLECTION_LOGGER");
        this.logger = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/microjservice/lark/core/event/Controller$Companion;", "", "()V", "SUCCESS", "", "lark-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

