/*
 * Decompiled with CFR 0.152.
 */
package org.microjservice.lark;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import jakarta.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.microjservice.lark.core.event.v2.EventConsumer;
import org.microjservice.lark.core.event.v2.model.EventRequest;
import org.microjservice.lark.core.event.v2.model.EventRequestDeserializer;
import org.microjservice.lark.core.event.v2.model.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/microjservice/lark/AppConfiguration;", "", "()V", "messageEventHandlerV2", "Lorg/microjservice/lark/core/event/v2/EventConsumer;", "Lorg/microjservice/lark/core/event/v2/model/MessageEvent;", "ObjectMapperBeanEventListener", "lark-api"})
public final class AppConfiguration {
    @Bean
    @NotNull
    public final EventConsumer<MessageEvent> messageEventHandlerV2() {
        return new EventConsumer<MessageEvent>(){
            private final Logger logger;

            public final Logger getLogger() {
                return this.logger;
            }

            @NotNull
            public Class<MessageEvent> getEventType() {
                return MessageEvent.class;
            }

            public void handleEvent(@NotNull EventRequest<MessageEvent> eventRequest) {
                Intrinsics.checkNotNullParameter(eventRequest, (String)"eventRequest");
                this.logger.info("Receive " + eventRequest);
            }
            {
                this.logger = LoggerFactory.getLogger(this.getClass());
            }
        };
    }

    @Singleton
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/microjservice/lark/AppConfiguration$ObjectMapperBeanEventListener;", "Lio/micronaut/context/event/BeanCreatedEventListener;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "()V", "onCreated", "event", "Lio/micronaut/context/event/BeanCreatedEvent;", "lark-api"})
    public static final class ObjectMapperBeanEventListener
    implements BeanCreatedEventListener<ObjectMapper> {
        @NotNull
        public ObjectMapper onCreated(@NotNull BeanCreatedEvent<ObjectMapper> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            ObjectMapper objectMapper = (ObjectMapper)event.getBean();
            if (objectMapper == null) {
                objectMapper = new ObjectMapper();
            }
            ObjectMapper mapper = objectMapper;
            mapper.registerModule((Module)new SimpleModule(){
                {
                    this.addDeserializer(EventRequest.class, new EventRequestDeserializer());
                }
            });
            return mapper;
        }
    }
}

