/*
 * Decompiled with CFR 0.152.
 */
package org.microjservice.lark.core.auth;

import io.micronaut.context.BeanProvider;
import jakarta.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.microjservice.lark.core.auth.AuthService$WhenMappings;
import org.microjservice.lark.core.auth.AuthorizationApi;
import org.microjservice.lark.core.auth.models.Credential;
import org.microjservice.lark.core.auth.models.Token;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/microjservice/lark/core/auth/AuthService;", "", "authorizationApiProvider", "Lio/micronaut/context/BeanProvider;", "Lorg/microjservice/lark/core/auth/AuthorizationApi;", "(Lio/micronaut/context/BeanProvider;)V", "getToken", "Lorg/microjservice/lark/core/auth/models/Token;", "credential", "Lorg/microjservice/lark/core/auth/models/Credential;", "lark-api"})
public final class AuthService {
    private final BeanProvider<AuthorizationApi> authorizationApiProvider;

    @NotNull
    public final Token getToken(@NotNull Credential credential) {
        Token token;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        AuthorizationApi authorizationApi = (AuthorizationApi)this.authorizationApiProvider.get();
        switch (AuthService$WhenMappings.$EnumSwitchMapping$0[credential.getCredentialType().ordinal()]) {
            case 1: {
                token = authorizationApi.internalAppAccessToken(credential).toAppToken();
                break;
            }
            case 2: {
                token = authorizationApi.appAccessToken(credential).toAppToken();
                break;
            }
            case 3: {
                token = authorizationApi.internalTenantAccessToken(credential).toTenantToken();
                break;
            }
            case 4: {
                token = authorizationApi.tenantAccessToken(credential).toTenantToken();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return token;
    }

    public AuthService(@NotNull BeanProvider<AuthorizationApi> authorizationApiProvider) {
        Intrinsics.checkNotNullParameter(authorizationApiProvider, (String)"authorizationApiProvider");
        this.authorizationApiProvider = authorizationApiProvider;
    }
}

