/*
 * Decompiled with CFR 0.152.
 */
package org.microjservice.lark.core.event.crypto;

import io.micronaut.context.annotation.Value;
import jakarta.inject.Singleton;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/microjservice/lark/core/event/crypto/NotifyDataDecrypter;", "", "encryptKey", "", "(Ljava/lang/String;)V", "key", "", "decrypt", "base64", "lark-api"})
public final class NotifyDataDecrypter {
    private final byte[] key;
    private final String encryptKey;

    @NotNull
    public final String decrypt(@Nullable String base64) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException {
        byte[] decode = Base64.getDecoder().decode(base64);
        Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
        byte[] iv = new byte[16];
        System.arraycopy(decode, 0, iv, 0, 16);
        byte[] data = new byte[decode.length - 16];
        System.arraycopy(decode, 16, data, 0, data.length);
        cipher.init(2, (Key)new SecretKeySpec(this.key, "AES"), new IvParameterSpec(iv));
        byte[] decryptedData = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)decryptedData, (String)"decryptedData");
        byte[] byArray = decryptedData;
        boolean bl = false;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        if (!(byArray2.length == 0)) {
            int p;
            for (p = decryptedData.length - 1; p >= 0 && decryptedData[p] < 16; --p) {
            }
            if (p != decryptedData.length - 1) {
                byte[] rr = new byte[p + 1];
                System.arraycopy(decryptedData, 0, rr, 0, p + 1);
                decryptedData = rr;
            }
        }
        byArray = decryptedData;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl3 = false;
        return new String(byArray, charset2);
    }

    public NotifyDataDecrypter(@Value(value="${lark.encrypt-key}") @NotNull String encryptKey) {
        Intrinsics.checkNotNullParameter((Object)encryptKey, (String)"encryptKey");
        this.encryptKey = encryptKey;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        MessageDigest messageDigest = digest;
        Intrinsics.checkNotNull((Object)messageDigest);
        String string = this.encryptKey;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest!!.digest(encryptK\u2026(StandardCharsets.UTF_8))");
        this.key = byArray2;
    }
}

