/*
 * Decompiled with CFR 0.152.
 */
package org.microjservice.lark.core.event.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.jackson.serialize.JacksonObjectSerializer;
import jakarta.inject.Singleton;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.microjservice.lark.core.event.v1.EventConsumer;
import org.microjservice.lark.core.event.v1.EventService;
import org.microjservice.lark.core.event.v1.model.BaseEvent;
import org.microjservice.lark.core.event.v1.model.MessageEvent;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/microjservice/lark/core/event/v1/EventService;", "", "objectSerializer", "Lio/micronaut/jackson/serialize/JacksonObjectSerializer;", "consumers", "", "Lorg/microjservice/lark/core/event/v1/EventConsumer;", "(Lio/micronaut/jackson/serialize/JacksonObjectSerializer;Ljava/util/List;)V", "eventTypeConventions", "", "", "Ljava/lang/Class;", "Lorg/microjservice/lark/core/event/v1/model/MessageEvent;", "dispatch", "", "eventRequest", "Lcom/fasterxml/jackson/databind/JsonNode;", "getEvent", "Lorg/microjservice/lark/core/event/v1/model/BaseEvent;", "lark-api"})
public final class EventService {
    private final Map<String, Class<MessageEvent>> eventTypeConventions;
    private final JacksonObjectSerializer objectSerializer;
    private final List<EventConsumer<Object>> consumers;

    /*
     * WARNING - void declaration
     */
    public final void dispatch(@NotNull JsonNode eventRequest) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)eventRequest, (String)"eventRequest");
        BaseEvent event = this.getEvent(eventRequest);
        Iterable $this$filter$iv = this.consumers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EventConsumer it = (EventConsumer)element$iv$iv;
            boolean bl = false;
            if (!it.getEventType().isInstance(event.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventConsumer it = (EventConsumer)element$iv;
            boolean bl = false;
            it.handleEvent(event);
        }
    }

    private final BaseEvent getEvent(JsonNode eventRequest) {
        JsonNode event = eventRequest.get("event");
        String type = event.get("type").asText();
        String string = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.toString()");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Object t = this.objectSerializer.deserialize(byArray, this.eventTypeConventions.get(type)).orElseThrow(getEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(t, (String)"objectSerializer.deseria\u2026ception(\"Empty event!\") }");
        return (BaseEvent)t;
    }

    public EventService(@NotNull JacksonObjectSerializer objectSerializer, @NotNull List<? extends EventConsumer<Object>> consumers) {
        Intrinsics.checkNotNullParameter((Object)objectSerializer, (String)"objectSerializer");
        Intrinsics.checkNotNullParameter(consumers, (String)"consumers");
        this.objectSerializer = objectSerializer;
        this.consumers = consumers;
        this.eventTypeConventions = MapsKt.mapOf((Pair)TuplesKt.to((Object)BaseEvent.Type.MESSAGE.getTypeName(), MessageEvent.class));
    }
}

