/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.liberty;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.microshed.testing.testcontainers.spi.ServerAdapter;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class LibertyAdapter
implements ServerAdapter {
    private static String BASE_DOCKER_IMAGE = "open-liberty:microProfile3";
    private static final String CONFIG_FILE_PROP = "MICROSHED_TEST_LIBERTY_CONFIG_FILE";

    public static String getBaseDockerImage() {
        return BASE_DOCKER_IMAGE;
    }

    public static void setBaseDockerImage(String imageName) {
        BASE_DOCKER_IMAGE = imageName;
    }

    public int getPriority() {
        return -50;
    }

    public int getDefaultHttpPort() {
        return 9080;
    }

    public int getDefaultHttpsPort() {
        return 9443;
    }

    public void setConfigProperties(Map<String, String> properties) {
        String MP_TEST_CONFIG_FILE = System.getProperty(CONFIG_FILE_PROP, System.getenv(CONFIG_FILE_PROP));
        Path configFile = null;
        if (MP_TEST_CONFIG_FILE == null) {
            String WLP_USR_DIR = System.getProperty("WLP_USR_DIR", System.getenv("WLP_USR_DIR"));
            if (WLP_USR_DIR == null) {
                WLP_USR_DIR = System.getProperty("wlp.user.dir");
            }
            if (WLP_USR_DIR == null) {
                throw new IllegalStateException("The 'w.p.user.dir', 'WLP_USR_DIR', or 'MICROSHED_TEST_LIBERTY_CONFIG_FILE' property must be set in order to dynamically set config properties");
            }
            Path usrDir = Paths.get(WLP_USR_DIR, new String[0]);
            configFile = usrDir.resolve("servers/defaultServer/configDropins/defaults/system-test-vars.xml");
        } else {
            configFile = Paths.get(MP_TEST_CONFIG_FILE, new String[0]);
        }
        configFile.getParent().toFile().mkdirs();
        if (properties.containsKey("mp_jwt_verify_publickey")) {
            properties.put("mp.jwt.verify.publickey", properties.remove("mp_jwt_verify_publickey"));
        }
        if (properties.containsKey("mp_jwt_verify_issuer")) {
            properties.put("mp.jwt.verify.issuer", properties.remove("mp_jwt_verify_issuer"));
        }
        ArrayList<String> lines = new ArrayList<String>(properties.size() + 2);
        lines.add("<server>");
        properties.forEach((k, v) -> lines.add("  <variable name=\"" + k + "\" value=\"" + v + "\"/>"));
        lines.add("</server>");
        try {
            Files.write(configFile, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Thread.sleep(500L);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write configuration to " + configFile, e);
        }
    }

    public ImageFromDockerfile getDefaultImage(File appFile) {
        String appName = appFile.getName();
        ImageFromDockerfile image = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(LibertyAdapter.getBaseDockerImage())).add("/config/dropins/" + appName, "/config/dropins/" + appName)).copy("/config", "/config")).build())).withFileFromFile("/config/dropins/" + appName, appFile)).withFileFromFile("/config", new File("src/main/liberty/config"));
        return image;
    }

    public Optional<String> getReadinessPath() {
        return Optional.empty();
    }
}

