/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;

public class ApacheCxfSSlHelperGo {
    private static final Logger log = Logger.getLogger((String)"fgsms.Agents");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance("jks");
        InputStream is = null;
        try {
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, (Object)("trouble opening keystore at " + url.toString()), (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return keystore;
    }

    public static void doCXF(Object webserviceclient, ConfigLoader cfg) {
        try {
            KeyStore keystore;
            HTTPConduit http = (HTTPConduit)ClientProxy.getClient((Object)webserviceclient).getConduit();
            TLSClientParameters parameters = new TLSClientParameters();
            parameters.setDisableCNCheck(false);
            KeyManager[] keymanagers = null;
            TrustManager[] trustmanagers = null;
            if (!Utility.stringIsNullOrEmpty((String)cfg.javaxkeystore)) {
                keystore = ApacheCxfSSlHelperGo.createKeyStore(new URL(cfg.javaxkeystore), Utility.DE((String)cfg.javaxkeystorepass));
                keymanagers = ApacheCxfSSlHelperGo.getKeyManagers(keystore, Utility.DE((String)cfg.javaxkeystorepass));
            }
            if (!Utility.stringIsNullOrEmpty((String)cfg.javaxtruststore)) {
                keystore = ApacheCxfSSlHelperGo.createKeyStore(new URL(cfg.javaxtruststore), Utility.DE((String)cfg.javaxtruststorepass));
                trustmanagers = ApacheCxfSSlHelperGo.getTrustManagers(keystore);
            }
            parameters.setKeyManagers(keymanagers);
            parameters.setTrustManagers(trustmanagers);
            TLSClientParameters tlsCP = new TLSClientParameters();
            tlsCP.setKeyManagers(keymanagers);
            tlsCP.setTrustManagers(trustmanagers);
            http.setTlsClientParameters(tlsCP);
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, (Object)"unable to initialize the CXF Conduit for configuration SSL information. The transaction may not go through", (Throwable)ex);
        }
    }

    private static TrustManager[] getTrustManagers(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = TrustManagerFactory.getInstance(alg);
        fac.init(trustStore);
        return fac.getTrustManagers();
    }

    private static KeyManager[] getKeyManagers(KeyStore keyStore, String keyPassword) throws GeneralSecurityException, IOException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        char[] keyPass = keyPassword != null ? keyPassword.toCharArray() : null;
        KeyManagerFactory fac = KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }
}

