/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.IMessageProcessor;
import org.miloss.fgsms.agentcore.MessageProcessorAdapter;
import org.miloss.fgsms.agentcore.mp.DefaultMessageProcessor;
import org.miloss.fgsms.common.Logger;

public class MessageProcessor {
    private static final Logger log = Logger.getLogger((String)"fgsms.Agents");
    private static IMessageProcessor singletonObject;

    public static void setSingletonObject(Object object) {
        singletonObject = (IMessageProcessor)object;
    }

    public static synchronized IMessageProcessor getSingletonObject() {
        if (singletonObject == null) {
            try {
                Properties p = ConfigLoader.loadProperties();
                if (p.containsKey("message.processor.impl")) {
                    IMessageProcessor mp;
                    String impl = p.getProperty("message.processor.impl");
                    singletonObject = mp = (IMessageProcessor)Class.forName(impl).newInstance();
                }
            }
            catch (ConfigurationException ex) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", (Throwable)ex);
            }
            catch (NullPointerException ex) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", (Throwable)ex);
            }
            catch (Throwable t) {
                log.log((Priority)Level.WARN, (Object)"failed to load custom message processor implementation, falling back to default implementation", t);
            }
            if (singletonObject == null) {
                singletonObject = new DefaultMessageProcessor();
            }
            try {
                MessageProcessorAdapter cache = new MessageProcessorAdapter();
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("org.miloss.fgsms.MessageProcessor:type=MessageProcessorAdapterMBean");
                mbs.registerMBean(cache, name);
            }
            catch (InstanceAlreadyExistsException cache) {
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)"unable to register MessageProcessor mbean", (Throwable)ex);
            }
        }
        return singletonObject;
    }
}

