/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.DataPusher;
import org.miloss.fgsms.agentcore.MessageProcessor;
import org.miloss.fgsms.agentcore.PersistentAgentThreadRunner;
import org.miloss.fgsms.agentcore.StatusHelper;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.datacollector.AddDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddMoreData;
import org.miloss.fgsms.services.interfaces.datacollector.DCS;
import org.miloss.fgsms.services.interfaces.datacollector.DataCollectorService;

public class PersistentStorage {
    static PersistentStorage instance = null;
    private static Thread t = null;
    static Logger log = Logger.getLogger((String)"fgsms.PersistentStorageAgent");
    private boolean running = true;
    private File file;
    private FileChannel channel;
    private FileLock lock;
    private boolean sendstatus = true;
    private boolean done = false;
    private static boolean noloop = false;

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Usage: java -jar fgsms.AgentCore.jar");
        System.out.println("This will monitor the configured or provided directory for encrypted files written by a Java based fgsms agent that couldn't be delievered.\nThese messages are read and then attempted to be delivered periodically. If delivered, they are removed from disk.This only applies to \ntransactions agents which cover web services. Configuration settings are within this jar file.");
        new PersistentStorage().init(args);
    }

    public static void start(String[] args) {
        instance = new PersistentStorage(args);
        t = new Thread(new PersistentAgentThreadRunner(instance));
        t.start();
    }

    public static void stop(String[] args) {
        if (t != null && t.isAlive() && instance != null) {
            PersistentStorage.instance.running = false;
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                log.log((Priority)Level.ERROR, null, (Throwable)ex);
            }
        }
    }

    public PersistentStorage(String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("nostatus")) {
            this.sendstatus = false;
        }
    }

    public PersistentStorage() {
    }

    public void init(String[] args) throws InterruptedException {
        boolean pooled = false;
        try {
            this.file = new File("dp.lck");
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            this.lock = this.channel.tryLock();
        }
        catch (Exception e) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file dp.lck needs to be deleted.");
            return;
        }
        if (this.lock == null) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file dp.lck needs to be deleted.");
            this.running = false;
            return;
        }
        if (args != null && args.length == 1 && args[0].equalsIgnoreCase("noloop")) {
            noloop = true;
        }
        Runtime.getRuntime().addShutdownHook(new RunWhenShuttingDown());
        PropertyConfigurator.configure((String)"log4j.properties");
        long lastRanAt = 0L;
        long interval = 300000L;
        long lastUpdateAt = 0L;
        long updatestatusinterval = 300000L;
        log.log((Priority)Level.INFO, (Object)"fgsms PersistentStorageAgent startup");
        while (this.running) {
            if (System.currentTimeMillis() - lastRanAt > interval) {
                try {
                    boolean bl = PersistentStorage.doWork(false);
                }
                catch (ConfigurationException ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    this.running = false;
                    this.done = true;
                    return;
                }
                catch (Exception ex) {
                    try {
                        if (this.sendstatus) {
                            StatusHelper.tryUpdateStatus(false, "urn:" + Utility.getHostName() + ":PersistentStorageAgent" + Utility.getHostName(), ex.getMessage(), pooled, PolicyType.STATUS, "unspecified", Utility.getHostName());
                        }
                    }
                    catch (Exception x) {
                        log.log((Priority)Level.WARN, (Object)"couldn't send status update", (Throwable)x);
                    }
                }
                log.log((Priority)Level.INFO, (Object)("fgsms PersistentStorageAgent sleeping for " + interval + "ms"));
                lastRanAt = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - lastUpdateAt > updatestatusinterval) {
                try {
                    if (this.sendstatus) {
                        StatusHelper.tryUpdateStatus(true, "urn:" + Utility.getHostName() + ":PersistentStorageAgent", "OK", pooled, PolicyType.STATUS, "unspecified", Utility.getHostName());
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, (Object)"couldn't send status update", (Throwable)ex);
                }
                lastUpdateAt = System.currentTimeMillis();
            }
            if (noloop) {
                this.running = false;
            }
            if (!this.running) continue;
            Thread.sleep(5000L);
        }
        this.done = true;
    }

    public static boolean doWork(boolean pooled) throws ConfigurationException {
        int i;
        ConfigLoader cfg = new ConfigLoader();
        String v = cfg.getOfflinestorage();
        if (cfg.behavior == null || cfg.behavior != ConfigLoader.UnavailableBehavior.HOLDPERSIST) {
            log.log((Priority)Level.ERROR, (Object)"the current config (fgsms-agent.properties) is not configured for offline storage");
            throw new ConfigurationException("not configured for persistant storage");
        }
        DataPusher.EnsureFolderExists(v);
        File f = new File(v);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!f.exists()) {
                log.log((Priority)Level.FATAL, (Object)("the storage directory does not exist and I can't create it. Check the OS file permissions. " + v));
            }
            throw new ConfigurationException("directory does not exist");
        }
        AddMoreData CheckPersistStore = DataPusher.CheckPersistStore();
        if (CheckPersistStore == null) {
            return false;
        }
        DataPusher dp = new DataPusher();
        DataPusher.Init();
        DataCollectorService dcsservice = new DataCollectorService();
        DCS dcsport = dcsservice.getDCSPort();
        BindingProvider bp = (BindingProvider)dcsport;
        Map context = bp.getRequestContext();
        if (cfg.mode_ == Constants.AuthMode.UsernamePassword) {
            context.put("javax.xml.ws.security.auth.username", cfg.username);
            context.put("javax.xml.ws.security.auth.password", Utility.DE((String)cfg.password));
        }
        if (Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            context.put("javax.net.ssl.trustStorePassword", Utility.DE((String)cfg.getJavaxtruststorepass()));
            context.put("javax.net.ssl.trustStore", Utility.DE((String)cfg.getJavaxtruststore()));
        }
        try {
            if (cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                context.put("javax.net.ssl.keyStorePassword", Utility.DE((String)cfg.getJavaxkeystorepass()));
                context.put("javax.net.ssl.keyStore", Utility.DE((String)cfg.getJavaxkeystore()));
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.FATAL, (Object)"error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", (Throwable)ex);
        }
        boolean success = false;
        for (i = 0; i < cfg.DCS_URLS.size(); ++i) {
            context.put("javax.xml.ws.service.endpoint.address", cfg.DCS_URLS.get(i));
            try {
                dcsport.addMoreData(CheckPersistStore.getReq());
                success = true;
                break;
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)("couldn't transmit the DCS message to " + cfg.DCS_URLS.get(i)));
                continue;
            }
        }
        if (!success) {
            DataPusher.StorePersist(CheckPersistStore);
            return false;
        }
        CheckPersistStore = DataPusher.CheckPersistStore();
        while (CheckPersistStore != null) {
            for (i = 0; i < CheckPersistStore.getReq().size(); ++i) {
                MessageProcessor.getSingletonObject().processPreppedMessage((AddDataRequestMsg)CheckPersistStore.getReq().get(i));
            }
            CheckPersistStore = DataPusher.CheckPersistStore();
        }
        return true;
    }

    private void closeLock() {
        try {
            this.lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this.file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class RunWhenShuttingDown
    extends Thread {
        @Override
        public void run() {
            System.out.println("Control-C caught. Shutting down...");
            PersistentStorage.this.running = false;
            while (!PersistentStorage.this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            PersistentStorage.this.closeLock();
            PersistentStorage.this.deleteFile();
            if (!noloop) {
                try {
                    if (PersistentStorage.this.sendstatus) {
                        StatusHelper.tryUpdateStatus(false, "urn:" + Utility.getHostName() + ":PersistentStorageAgent", "Stopped", false, PolicyType.STATUS, "unspecified", Utility.getHostName());
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, (Object)"couldn't send status update", (Throwable)ex);
                }
            }
        }
    }
}

