/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.HelperBase;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.policyconfiguration.GetGlobalPolicyRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.GetGlobalPolicyResponseMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.GlobalPolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicyRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicyResponseMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.StatisticalServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransactionalWebServicePolicy;
import us.gov.ic.ism.v2.ClassificationType;

public class PolicyFetch
extends HelperBase {
    static ConfigLoader cfg = null;
    static Logger log = Logger.getLogger((String)"fgsms.Agents");

    private static void Init() throws ConfigurationException {
        if (cfg == null) {
            cfg = new ConfigLoader();
        }
    }

    public static GlobalPolicy TryFetchGlobalPolicy() throws ConfigurationException {
        if (cfg == null) {
            PolicyFetch.Init();
        }
        PolicyFetch.discoverEndpoints();
        int retrycount = 0;
        int urlcount = 0;
        switch (PolicyFetch.cfg.PCSalgo) {
            case FAILOVER: {
                urlcount = 0;
                for (retrycount = 0; retrycount < PolicyFetch.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < PolicyFetch.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)PolicyFetch.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", PolicyFetch.cfg.PCS_URLS.get(urlcount));
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", PolicyFetch.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE((String)PolicyFetch.cfg.password));
                            }
                            if (Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                context.put("javax.net.ssl.trustStorePassword", Utility.DE((String)cfg.getJavaxtruststorepass()));
                                context.put("javax.net.ssl.trustStore", Utility.DE((String)cfg.getJavaxtruststore()));
                            }
                            try {
                                if (PolicyFetch.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                    context.put("javax.net.ssl.keyStorePassword", Utility.DE((String)cfg.getJavaxkeystorepass()));
                                    context.put("javax.net.ssl.keyStore", Utility.DE((String)cfg.getJavaxkeystore()));
                                }
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.FATAL, (Object)"error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", (Throwable)ex);
                            }
                            GetGlobalPolicyRequestMsg req = new GetGlobalPolicyRequestMsg();
                            req.setClassification(new SecurityWrapper(ClassificationType.U, "none"));
                            GetGlobalPolicyResponseMsg servicePolicy = PolicyFetch.cfg.pcsport.getGlobalPolicy(req);
                            return servicePolicy.getPolicy();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, (Object)("fgsms unable to fetch policy from PCS at " + PolicyFetch.cfg.PCS_URLS.get(urlcount) + " will retry " + (PolicyFetch.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage()), (Throwable)ex);
                            continue;
                        }
                    }
                }
                log.log((Priority)Level.FATAL, (Object)("fgsms unable to fetch policy from any of the PCS[" + PolicyFetch.cfg.PCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy"));
                return null;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                for (retrycount = 0; retrycount < PolicyFetch.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < PolicyFetch.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)PolicyFetch.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", PolicyFetch.cfg.PCS_URLS.get(urlcount));
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", PolicyFetch.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE((String)PolicyFetch.cfg.password));
                            }
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE((String)cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE((String)cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE((String)cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE((String)cfg.getJavaxtruststore()));
                            }
                            GetGlobalPolicyRequestMsg req = new GetGlobalPolicyRequestMsg();
                            req.setClassification(new SecurityWrapper(ClassificationType.U, "none"));
                            GetGlobalPolicyResponseMsg servicePolicy = PolicyFetch.cfg.pcsport.getGlobalPolicy(req);
                            return servicePolicy.getPolicy();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, (Object)("fgsms unable to fetch policy from PCS at " + PolicyFetch.cfg.PCS_URLS.get(urlcount) + " will retry " + (PolicyFetch.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage()), (Throwable)ex);
                            continue;
                        }
                    }
                }
                log.log((Priority)Level.FATAL, (Object)("fgsms unable to fetch policy from any of the PCS[" + PolicyFetch.cfg.PCS_URLS.size() + "] URLs, retry count exceeded."));
                return null;
            }
        }
        return null;
    }

    public static ServicePolicy TryFetchPolicy(String URI2, PolicyType policyType, String domainname, String hostname) throws ConfigurationException {
        if (cfg == null) {
            PolicyFetch.Init();
        }
        PolicyFetch.discoverEndpoints();
        ServicePolicyRequestMsg req = new ServicePolicyRequestMsg();
        req.setClassification(PolicyFetch.cfg.classlevel);
        req.setDomain(domainname);
        req.setURI(URI2);
        req.setPolicytype(policyType);
        if (Utility.stringIsNullOrEmpty((String)hostname)) {
            req.setMachine(Utility.getHostName());
        } else {
            req.setMachine(hostname);
        }
        try {
            return PolicyFetch.Send(req);
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, (Object)"could not retrieve a policy for the specified url", (Throwable)ex);
            return null;
        }
    }

    private static ServicePolicy Send(ServicePolicyRequestMsg req) throws ConfigurationException {
        if (cfg == null) {
            PolicyFetch.Init();
        }
        int retrycount = 0;
        int urlcount = 0;
        switch (PolicyFetch.cfg.PCSalgo) {
            case FAILOVER: {
                urlcount = 0;
                for (retrycount = 0; retrycount < PolicyFetch.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < PolicyFetch.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)PolicyFetch.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", PolicyFetch.cfg.PCS_URLS.get(urlcount));
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", PolicyFetch.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE((String)PolicyFetch.cfg.password));
                            }
                            if (Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                context.put("javax.net.ssl.trustStorePassword", Utility.DE((String)cfg.getJavaxtruststorepass()));
                                context.put("javax.net.ssl.trustStore", Utility.DE((String)cfg.getJavaxtruststore()));
                            }
                            try {
                                if (PolicyFetch.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                    context.put("javax.net.ssl.keyStorePassword", Utility.DE((String)cfg.getJavaxkeystorepass()));
                                    context.put("javax.net.ssl.keyStore", Utility.DE((String)cfg.getJavaxkeystore()));
                                }
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.FATAL, (Object)"error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", (Throwable)ex);
                            }
                            ServicePolicyResponseMsg servicePolicy = PolicyFetch.cfg.pcsport.getServicePolicy(req);
                            PolicyFetch.cfg.classlevel = servicePolicy.getClassification();
                            return servicePolicy.getPolicy();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, (Object)("fgsms unable to fetch policy from PCS at " + PolicyFetch.cfg.PCS_URLS.get(urlcount) + " will retry " + (PolicyFetch.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage()), (Throwable)ex);
                            continue;
                        }
                    }
                }
                log.log((Priority)Level.FATAL, (Object)("fgsms unable to fetch policy from any of the PCS[" + PolicyFetch.cfg.PCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy"));
                return null;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                for (retrycount = 0; retrycount < PolicyFetch.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < PolicyFetch.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)PolicyFetch.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", PolicyFetch.cfg.PCS_URLS.get(urlcount));
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", PolicyFetch.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE((String)PolicyFetch.cfg.password));
                            }
                            if (PolicyFetch.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE((String)cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE((String)cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE((String)cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE((String)cfg.getJavaxtruststore()));
                            }
                            ServicePolicyResponseMsg servicePolicy = PolicyFetch.cfg.pcsport.getServicePolicy(req);
                            PolicyFetch.cfg.classlevel = servicePolicy.getClassification();
                            return servicePolicy.getPolicy();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, (Object)("fgsms unable to fetch policy from PCS at " + PolicyFetch.cfg.PCS_URLS.get(urlcount) + " will retry " + (PolicyFetch.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage()), (Throwable)ex);
                            continue;
                        }
                    }
                }
                log.log((Priority)Level.FATAL, (Object)("fgsms unable to fetch policy from any of the PCS[" + PolicyFetch.cfg.PCS_URLS.size() + "] URLs, retry count exceeded."));
                return null;
            }
        }
        return null;
    }

    protected static String readAllText(InputStream in) {
        try {
            InputStreamReader sr = new InputStreamReader(in, "UTF-8");
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(sr);
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            sr.close();
            return fileData.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static TransactionalWebServicePolicy loadTranasctionalDefaultPolicy(String url) {
        try {
            InputStream in = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            in = loader.getResourceAsStream("org/miloss/fgsms/agentcore/defaultpolicy.xml");
            String pol = PolicyFetch.readAllText(in);
            in.close();
            JAXBContext jc = Utility.getSerializationContext();
            Unmarshaller u = jc.createUnmarshaller();
            ByteArrayInputStream bss = new ByteArrayInputStream(pol.getBytes("UTF-8"));
            XMLInputFactory xf = XMLInputFactory.newInstance();
            XMLStreamReader r = xf.createXMLStreamReader(bss);
            JAXBElement foo = u.unmarshal(r, TransactionalWebServicePolicy.class);
            if (foo == null || foo.getValue() == null) {
                log.log((Priority)Level.WARN, (Object)"ServicePolicy is unexpectedly null or empty");
                return null;
            }
            ServicePolicyResponseMsg ret = new ServicePolicyResponseMsg();
            ret.setPolicy((ServicePolicy)foo.getValue());
            ret.setClassification(PolicyFetch.cfg.classlevel);
            ret.getPolicy().setURL(url);
            return (TransactionalWebServicePolicy)ret.getPolicy();
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, (Object)"error loading default policy from disk", (Throwable)ex);
            return null;
        }
    }

    public static StatisticalServicePolicy loadStatisticalDefaultPolicy(String url, String machine, String domain) {
        StatisticalServicePolicy pol = new StatisticalServicePolicy();
        pol.setAgentsEnabled(true);
        pol.setURL(url);
        pol.setMachineName(machine);
        pol.setDomainName(domain);
        return pol;
    }
}

