/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.handler.MessageContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;

public class AuditLogger {
    static final Logger log = Logger.getLogger(AuditLogger.class.getCanonicalName());
    public static final String unspecified = "UNSPECIFIED";

    public static void logItem(String classname, String method, String username, String memo, SecurityWrapper classification, MessageContext messageContext) {
        if (classification == null || classification.getClassification() == null || classification.getCaveats() == null) {
            AuditLogger.logItem(classname, method, username, memo, unspecified, messageContext);
        } else {
            AuditLogger.logItem(classname, method, username, memo, Utility.ICMClassificationToString(classification.getClassification()) + " " + classification.getCaveats(), messageContext);
        }
    }

    private static String logForgePrevention(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("\n", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logItem(String classname, String method, String username, String memo, String classification, MessageContext messageContext) {
        PreparedStatement com;
        Connection con;
        block9: {
            memo = memo + " JVM Free:" + Runtime.getRuntime().freeMemory() + " Total: " + Runtime.getRuntime().totalMemory();
            double used = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (double)Runtime.getRuntime().totalMemory();
            memo = memo + " " + String.valueOf(used) + "% in use, processors: " + Runtime.getRuntime().availableProcessors();
            log.log((Priority)Level.DEBUG, "fgsms Audit Log: " + AuditLogger.logForgePrevention(classname) + " " + AuditLogger.logForgePrevention(method) + " username: " + AuditLogger.logForgePrevention(username) + " memo: " + AuditLogger.logForgePrevention(memo));
            con = Utility.getConfigurationDBConnection();
            com = null;
            if (con != null) break block9;
            log.log((Priority)Level.FATAL, "database not available");
            System.out.println("database not available! cannot record audit logs!");
            System.err.println("database not available! cannot record audit logs!");
            DBUtils.safeClose(com);
            DBUtils.safeClose(con);
            return;
        }
        try {
            com = con.prepareStatement("INSERT INTO auditlog(utcdatetime, username, classname, method, memo, classification, ipaddress) VALUES (?, ?, ?, ?, ?,?,?);");
            com.setLong(1, System.currentTimeMillis());
            com.setString(2, username);
            com.setString(3, classname);
            com.setString(4, method);
            com.setBytes(5, memo.trim().getBytes("UTF-8"));
            com.setString(6, classification);
            if (messageContext != null) {
                try {
                    HttpServletRequest ctx = null;
                    ctx = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
                    com.setString(7, ctx.getRemoteAddr());
                }
                catch (Exception ex) {
                    com.setString(7, "NA");
                }
            } else {
                com.setString(7, "NA");
            }
            com.execute();
        }
        catch (Exception ex) {
            try {
                log.log((Priority)Level.ERROR, "Unable to log audit event", ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
                throw throwable;
            }
            DBUtils.safeClose(com);
            DBUtils.safeClose(con);
        }
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
    }
}

