/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.policyconfiguration.GlobalPolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValue;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransportAuthenticationStyle;
import us.gov.ic.ism.v2.ClassificationType;

public class DBSettingsLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyNameValueEnc> GetPropertiesFromDB(boolean isPooled) {
        Connection con = null;
        PreparedStatement com = null;
        ResultSet rs = null;
        ArrayList<KeyNameValueEnc> items = new ArrayList<KeyNameValueEnc>();
        try {
            con = isPooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
            com = con.prepareStatement("select * from settings;");
            rs = com.executeQuery();
            while (rs.next()) {
                KeyNameValueEnc k = new KeyNameValueEnc();
                k.setShouldEncrypt(rs.getBoolean("isencrypted"));
                KeyNameValue p = new KeyNameValue();
                p.setPropertyKey(rs.getString("keycol"));
                p.setPropertyName(rs.getString("namecol"));
                p.setPropertyValue(new String(rs.getBytes("valuecol"), Charset.forName("UTF-8")));
                k.setKeyNameValue(p);
                items.add(k);
            }
        }
        catch (Exception ex) {
            try {
                Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "problem loading settings from the database", ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose(com);
            DBUtils.safeClose(con);
        }
        DBUtils.safeClose(rs);
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyNameValueEnc> GetPropertiesFromDB(boolean isPooled, String keyfilter) {
        Connection con = null;
        PreparedStatement com = null;
        ResultSet rs = null;
        ArrayList<KeyNameValueEnc> items = new ArrayList<KeyNameValueEnc>();
        try {
            con = isPooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
            com = con.prepareStatement("select * from settings where keycol=?;");
            com.setString(1, keyfilter);
            rs = com.executeQuery();
            while (rs.next()) {
                KeyNameValueEnc k = new KeyNameValueEnc();
                k.setShouldEncrypt(rs.getBoolean("isencrypted"));
                KeyNameValue p = new KeyNameValue();
                p.setPropertyKey(rs.getString("keycol"));
                p.setPropertyName(rs.getString("namecol"));
                p.setPropertyValue(new String(rs.getBytes("valuecol"), "UTF-8"));
                k.setKeyNameValue(p);
                items.add(k);
            }
        }
        catch (Exception ex) {
            try {
                Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "problem loading " + keyfilter + " settings from the database", ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose(com);
            DBUtils.safeClose(con);
        }
        DBUtils.safeClose(rs);
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyNameValueEnc GetPropertiesFromDB(boolean isPooled, String keyfilter, String namefilter) {
        KeyNameValueEnc k;
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block4: {
            con = null;
            com = null;
            rs = null;
            k = new KeyNameValueEnc();
            try {
                con = isPooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
                com = con.prepareStatement("select * from settings where keycol=? and  namecol=?;");
                com.setString(1, keyfilter);
                com.setString(2, namefilter);
                rs = com.executeQuery();
                if (!rs.next()) break block4;
                k.setShouldEncrypt(rs.getBoolean("isencrypted"));
                KeyNameValue p = new KeyNameValue();
                p.setPropertyKey(rs.getString("keycol"));
                p.setPropertyName(rs.getString("namecol"));
                p.setPropertyValue(new String(rs.getBytes("valuecol"), "UTF-8"));
                k.setKeyNameValue(p);
            }
            catch (Exception ex) {
                try {
                    Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "problem loading " + keyfilter + " " + namefilter + " settings from the database", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose(com);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
            }
        }
        DBUtils.safeClose(rs);
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] GetDefaultBuellerCredentials(boolean isPooled) {
        Connection con = null;
        PreparedStatement com = null;
        ResultSet rs = null;
        String[] data = new String[2];
        try {
            con = isPooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
            com = con.prepareStatement("select * from settings where keycol=?;");
            com.setString(1, "Bueller");
            rs = com.executeQuery();
            while (rs.next()) {
                if (rs.getString("namecol").equalsIgnoreCase("defaultUser")) {
                    data[0] = new String(rs.getBytes("valuecol"), "UTF-8");
                }
                if (!rs.getString("namecol").equalsIgnoreCase("defaultPassword")) continue;
                data[1] = new String(rs.getBytes("valuecol"), "UTF-8");
            }
        }
        catch (Exception ex) {
            try {
                Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "problem loading default bueller credentials from the database", ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose(com);
            DBUtils.safeClose(con);
        }
        DBUtils.safeClose(rs);
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
        if (Utility.stringIsNullOrEmpty(data[0]) || Utility.stringIsNullOrEmpty(data[1])) {
            return null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] GetCredentials(boolean isPooled, String url) {
        String[] data;
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block6: {
            con = null;
            com = null;
            rs = null;
            data = null;
            try {
                con = isPooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
                com = con.prepareStatement("select * from bueller where uri=?;");
                com.setString(1, url);
                rs = com.executeQuery();
                if (!rs.next()) break block6;
                data = new String[3];
                data[0] = rs.getString("username");
                data[1] = new String(rs.getBytes("pwdcol"), "UTF-8");
                try {
                    int x = rs.getInt("authtype");
                    TransportAuthenticationStyle tas = TransportAuthenticationStyle.values()[x];
                    data[2] = tas.value();
                }
                catch (Exception e) {
                    data[2] = TransportAuthenticationStyle.NA.value();
                }
            }
            catch (Exception ex) {
                try {
                    Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "problem loading credentials for " + url + " from the database", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose(com);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose(con);
            }
        }
        DBUtils.safeClose(rs);
        DBUtils.safeClose(com);
        DBUtils.safeClose(con);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalPolicy GetGlobalPolicy(boolean pooled) {
        Connection con;
        GlobalPolicy ret;
        ResultSet results;
        PreparedStatement comm;
        block11: {
            comm = null;
            results = null;
            ret = new GlobalPolicy();
            con = pooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
            try {
                DatatypeFactory df = DatatypeFactory.newInstance();
                comm = con.prepareStatement("Select * from GlobalPolicies;");
                results = comm.executeQuery();
                boolean foundPolicy = false;
                if (results.next()) {
                    ret.setPolicyRefreshRate(df.newDuration(results.getLong("PolicyRefreshRate")));
                    ret.setRecordedMessageCap(results.getInt("RecordedMessageCap"));
                    SecurityWrapper wrap = new SecurityWrapper(ClassificationType.fromValue((String)results.getString("classification")), results.getString("caveat"));
                    ret.setClassification(wrap);
                    ret.setAgentsEnabled(Boolean.valueOf(results.getBoolean("agentsenable")));
                    foundPolicy = true;
                }
                results.close();
                comm.close();
                if (!foundPolicy) {
                    try {
                        comm = con.prepareStatement("INSERT INTO GlobalPolicies (PolicyRefreshRate, RecordedMessageCap, classification, agentsenable, caveat)  VALUES (?, ?, ?, true, ?);");
                        comm.setLong(1, 180000L);
                        comm.setLong(2, 1024000L);
                        comm.setString(3, "U");
                        comm.setString(4, "");
                        comm.execute();
                        ret.setRecordedMessageCap(1024000);
                        ret.setClassification(new SecurityWrapper(ClassificationType.U, "None"));
                        ret.setAgentsEnabled(Boolean.valueOf(true));
                    }
                    catch (SQLException ex) {
                        Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "error setting global policy", ex);
                    }
                }
                comm.close();
                con.close();
                KeyNameValueEnc d = DBSettingsLoader.GetPropertiesFromDB(true, "UddiPublisher", "Interval");
                if (d != null && d.getKeyNameValue() != null) {
                    try {
                        ret.setUDDIPublishRate(df.newDuration(Long.parseLong(d.getKeyNameValue().getPropertyValue())));
                    }
                    catch (Exception ex) {
                        ret.setUDDIPublishRate(df.newDuration(180000L));
                    }
                    break block11;
                }
                ret.setUDDIPublishRate(df.newDuration(180000L));
            }
            catch (Exception ex) {
                try {
                    Logger.getLogger("fgsms.Utility").log((Priority)Level.ERROR, "error getting global policy", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(results);
                    DBUtils.safeClose(comm);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
                DBUtils.safeClose(results);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
            }
        }
        DBUtils.safeClose(results);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        return ret;
    }
}

