/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;

public class IpAddressUtility {
    public static final String logname = "fgsms.Utility";

    public static String modifyURL(String url, boolean isClient) {
        if (Utility.stringIsNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        String str = url;
        ArrayList<String> ips = new ArrayList<String>();
        String host = "localhost";
        ips.add("127.0.0.1");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getHostName().toLowerCase();
            InetAddress localhost = InetAddress.getLocalHost();
            ips.add(localhost.getHostAddress());
            InetAddress[] appmyips = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (appmyips != null && appmyips.length > 1) {
                for (int i = 0; i < appmyips.length; ++i) {
                    ips.add(appmyips[i].getHostAddress());
                }
            }
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> eip = intf.getInetAddresses();
                while (eip.hasMoreElements()) {
                    InetAddress ip = eip.nextElement();
                    ips.add(ip.getHostAddress());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(logname).log((Priority)Level.WARN, "Error caught attempting to obtain local ip addresses " + ex.getLocalizedMessage());
        }
        if (isClient) {
            String prefix;
            boolean containsLocalhostOrLocalIP = false;
            if (url.contains("://localhost:")) {
                containsLocalhostOrLocalIP = true;
            }
            if (url.contains("://localhost/")) {
                containsLocalhostOrLocalIP = true;
            }
            for (int i = 0; i < ips.size(); ++i) {
                if (url.contains("://" + (String)ips.get(i) + "/")) {
                    containsLocalhostOrLocalIP = true;
                    break;
                }
                if (!url.contains("://" + (String)ips.get(i) + ":")) continue;
                containsLocalhostOrLocalIP = true;
                break;
            }
            if (containsLocalhostOrLocalIP) {
                String prefix2 = str.substring(0, 5).toLowerCase();
                for (int i = 0; i < ips.size(); ++i) {
                    if (prefix2.equals("https")) {
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":443/");
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":443/");
                        continue;
                    }
                    if (prefix2.equals("http:")) {
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":80/");
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                        str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":80/");
                        continue;
                    }
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + "/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + "/");
                }
                if (str.startsWith("jms:")) {
                    str = str.replaceFirst("\\:[a-zA-Z0-9\\-\\.]+:", host);
                }
                Logger.getLogger(logname).log((Priority)Level.DEBUG, "URL Modifier - original " + url + " modified " + str + " client=true");
                return str;
            }
            String ipurl = IpAddressUtility.ContainsIPAddress(str);
            if (!Utility.stringIsNullOrEmpty(ipurl)) {
                try {
                    try {
                        InetAddress addr = InetAddress.getByName(ipurl);
                        host = addr.getHostName().toLowerCase();
                        if (Utility.stringIsNullOrEmpty(host)) {
                            host = ipurl;
                        }
                    }
                    catch (Exception e) {
                        host = ipurl;
                    }
                    str = str.replaceFirst(ipurl, host);
                    if (str.startsWith("jms:")) {
                        str = str.replaceFirst("\\:[a-zA-Z0-9\\-\\.]+:", "\\:" + host);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(logname).log((Priority)Level.WARN, "Client side url modifier, error caught trying to rdns the remote entry of  " + url + ex.getLocalizedMessage());
                }
                Logger.getLogger(logname).log((Priority)Level.DEBUG, "URL Modifier - original " + url + " modified " + str + " client=true");
                return str;
            }
            String hostname = "";
            String hostnameregex = "://([^/:]+)";
            Pattern p = Pattern.compile(hostnameregex);
            Matcher m = p.matcher(str);
            boolean find = m.find();
            if (!find) {
                Logger.getLogger(logname).log((Priority)Level.DEBUG, "unexpected error modifing the url " + url + " maybe it's not an actual url?");
                return url;
            }
            hostname = str.substring(m.start(), m.end());
            hostname = hostname.replace("://", "");
            boolean found = false;
            try {
                InetAddress localaddr = InetAddress.getByName(hostname);
                String hostnameip = localaddr.getHostAddress();
                for (int i = 0; i < ips.size(); ++i) {
                    if (!((String)ips.get(i)).equalsIgnoreCase(hostnameip)) continue;
                    found = true;
                }
            }
            catch (Exception localaddr) {
                // empty catch block
            }
            if (found) {
                prefix = str.substring(0, 5).toLowerCase();
                if (prefix.equals("https")) {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":443/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":443/");
                } else if (prefix.equals("http:")) {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":80/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":80/");
                } else if (str.startsWith("jms:")) {
                    str = str.replaceFirst("\\:[a-zA-Z0-9\\-\\.]+:", host);
                } else {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + "/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + "/");
                }
            } else {
                prefix = str.substring(0, 5).toLowerCase();
                if (prefix.equals("https")) {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + hostname + ":443/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + hostname + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + hostname + ":443/");
                } else if (prefix.equals("http:")) {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + hostname + ":80/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + hostname + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + hostname + ":80/");
                } else if (str.startsWith("jms:")) {
                    str = str.replaceFirst("\\:[a-zA-Z0-9\\-\\.]+:", hostname);
                } else {
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + hostname + "/");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + hostname + ":");
                    str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + hostname + "/");
                }
            }
            Logger.getLogger(logname).log((Priority)Level.DEBUG, "URL Modifier - original " + url + " modified " + str + " client=true");
            return str;
        }
        String prefix = str.substring(0, 5).toLowerCase();
        for (int i = 0; i < ips.size(); ++i) {
            if (prefix.equals("https")) {
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":443/");
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":443/");
                continue;
            }
            if (prefix.equals("http:")) {
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + ":80/");
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
                str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + ":80/");
                continue;
            }
            str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+\\/", "://" + host + "/");
            str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+:", "://" + host + ":");
            str = str.replaceFirst("\\://[a-zA-Z0-9\\-\\.]+?$", "://" + host + "/");
        }
        if (str.contains("?")) {
            str = str.substring(0, str.indexOf("?"));
        }
        if (str.startsWith("jms:")) {
            str = str.replaceFirst("\\:[a-zA-Z0-9\\-\\.]+:", ":" + host + ":");
        }
        Logger.getLogger(logname).log((Priority)Level.DEBUG, "URL Modifier - original " + url + " modified " + str);
        return str;
    }

    private static String ContainsIPAddress(String str) {
        if (Utility.stringIsNullOrEmpty(str)) {
            return "";
        }
        String reg = "\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
        String worker = str;
        try {
            Pattern p = Pattern.compile(reg);
            Matcher m = p.matcher(worker);
            if (m.find()) {
                return str.substring(m.start(), m.end());
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

