/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import com.sun.org.apache.xerces.internal.dom.DeferredElementImpl;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.Duration;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.AES;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.PropertyLoader;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.AbstractSchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.DailySchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.Daynames;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ExportCSVDataRequestMsg;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ExportDataRequestMsg;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.MonthlySchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.OneTimeSchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ReportDefinition;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ScheduleDefinition;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.TimeRangeDiff;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.WeeklySchedule;
import org.miloss.fgsms.services.interfaces.common.AlertMessageDefinition;
import org.miloss.fgsms.services.interfaces.common.DriveInformation;
import org.miloss.fgsms.services.interfaces.common.Header;
import org.miloss.fgsms.services.interfaces.common.NameValuePair;
import org.miloss.fgsms.services.interfaces.common.NameValuePairSet;
import org.miloss.fgsms.services.interfaces.common.NetworkAdapterInfo;
import org.miloss.fgsms.services.interfaces.common.NetworkAdapterPerformanceData;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.interfaces.datacollector.AddData;
import org.miloss.fgsms.services.interfaces.datacollector.AddDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddMoreData;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfSLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfSLAActionBaseType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfUserIdentity;
import org.miloss.fgsms.services.interfaces.policyconfiguration.FederationPolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.FederationPolicyCollection;
import org.miloss.fgsms.services.interfaces.policyconfiguration.GeoTag;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValue;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.services.interfaces.policyconfiguration.MachineInformation;
import org.miloss.fgsms.services.interfaces.policyconfiguration.MachinePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.Plugin;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ProcessPolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.PropertyPair;
import org.miloss.fgsms.services.interfaces.policyconfiguration.RuleBaseType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.RunAtLocation;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLAAction;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLARuleGeneric;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SetProcessListByMachineRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SetProcessListByMachineResponseMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.StatisticalServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.StatusServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransactionalWebServicePolicy;
import org.miloss.fgsms.services.interfaces.reportingservice.ArrayOfReportTypeContainer;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportRecordsEnum;
import org.miloss.fgsms.services.interfaces.reportingservice.ReportTypeContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import us.gov.ic.ism.v2.ClassificationType;

public class Utility {
    public static final String logname = "fgsms.Utility";
    static final Logger log = Logger.getLogger("fgsms.Utility");
    public static final String JDBC_PERFORMANCE = "jdbc/fgsmsPerformance";
    public static final String JDBC_CONFIG = "jdbc/fgsmsConfig";
    public static final String SECONDARY_POSTIFX = "Secondary";
    private static final SimpleDateFormat dtg = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static JAXBContext serialctx = null;
    private static JAXBContext arsctx = null;
    private static final String PerformanceDBURL = "performancedbURL";
    private static final String ConfigDBURL = "configdbURL";
    private static final String ConfigUsername = "configUser";
    private static final String ConfigPassword = "configPass";
    private static final String PerformanceUsername = "perfUser";
    private static final String PerformancePassword = "perfPass";
    private static final String PerformanceDBURL_FAILOVER = "performancedbURL_FAILOVER";
    private static final String ConfigDBURL_FAILOVER = "configdbURL_FAILOVER";
    private static final String ConfigUsername_FAILOVER = "configUser_FAILOVER";
    private static final String ConfigPassword_FAILOVER = "configPass_FAILOVER";
    private static final String PerformanceUsername_FAILOVER = "perfUser_FAILOVER";
    private static final String PerformancePassword_FAILOVER = "perfPass_FAILOVER";
    private static final String DBdriver = "driver";
    public static final String PropertyFilePath = "org/miloss/fgsms/common/database";
    private static String myHostname = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Calendar cal) {
        SimpleDateFormat simpleDateFormat = dtg;
        synchronized (simpleDateFormat) {
            if (cal == null) {
                return "unknown";
            }
            return dtg.format(cal.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date cal) {
        SimpleDateFormat simpleDateFormat = dtg;
        synchronized (simpleDateFormat) {
            if (cal == null) {
                return "unknown";
            }
            return dtg.format(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(long timestampEpoch) {
        SimpleDateFormat simpleDateFormat = dtg;
        synchronized (simpleDateFormat) {
            return dtg.format(new Date(timestampEpoch));
        }
    }

    public static Calendar parseDateTime(String s) throws Exception {
        SimpleDateFormat f1 = new SimpleDateFormat("MM/dd/yyyy");
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        SimpleDateFormat f3 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        SimpleDateFormat f4 = new SimpleDateFormat("EEE MM/dd/yyyy HH:mm:ss.ms");
        SimpleDateFormat f5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.zzzzzzz");
        Date d = null;
        try {
            d = f1.parse(s, new ParsePosition(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d == null) {
            try {
                d = f2.parse(s, new ParsePosition(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (d == null) {
            try {
                d = f3.parse(s, new ParsePosition(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (d == null) {
            try {
                d = f4.parse(s, new ParsePosition(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (d == null) {
            try {
                d = f5.parse(s, new ParsePosition(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (d != null) {
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTime(d);
            return gcal;
        }
        try {
            long timestamp = Long.parseLong(s);
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(timestamp);
            return gcal;
        }
        catch (Exception exception) {
            throw new Exception("Unable to parse the date, see documentation for correct usage");
        }
    }

    public static void addStatusChangeSLA(ServicePolicy ret) {
        SLAAction e;
        SLARuleGeneric r;
        int i;
        if (ret.getServiceLevelAggrements() == null) {
            ret.setServiceLevelAggrements(new ArrayOfSLA());
        }
        boolean existingSla = false;
        for (i = 0; i < ret.getServiceLevelAggrements().getSLA().size(); ++i) {
            if (!(((SLA)ret.getServiceLevelAggrements().getSLA().get(i)).getRule() instanceof SLARuleGeneric) || !(r = (SLARuleGeneric)((SLA)ret.getServiceLevelAggrements().getSLA().get(i)).getRule()).getClassName().equalsIgnoreCase("org.miloss.fgsms.sla.rules.ChangeInAvailabilityStatus")) continue;
            existingSla = true;
        }
        if (!existingSla) {
            SLA s = new SLA();
            r = new SLARuleGeneric();
            r.setClassName("org.miloss.fgsms.sla.rules.ChangeInAvailabilityStatus");
            r.setProcessAt(RunAtLocation.FGSMS_SERVER);
            s.setRule((RuleBaseType)r);
            s.setGuid(UUID.randomUUID().toString());
            s.setAction(new ArrayOfSLAActionBaseType());
            e = Utility.newEmailAction(null, "Change of status for " + Utility.encodeHTML(ret.getURL()), "Change of status for " + Utility.encodeHTML(ret.getURL()) + ". This is the default status alert. This can be changed by changing the policy for this service.");
            s.getAction().getSLAAction().add(e);
            ret.getServiceLevelAggrements().getSLA().add(s);
        }
        existingSla = false;
        for (i = 0; i < ret.getServiceLevelAggrements().getSLA().size(); ++i) {
            if (!(((SLA)ret.getServiceLevelAggrements().getSLA().get(i)).getRule() instanceof SLARuleGeneric) || !(r = (SLARuleGeneric)((SLA)ret.getServiceLevelAggrements().getSLA().get(i)).getRule()).getClassName().equalsIgnoreCase("org.miloss.fgsms.sla.rules.StaleData")) continue;
            existingSla = true;
        }
        if (!existingSla) {
            SLA s = new SLA();
            r = new SLARuleGeneric();
            r.setProcessAt(RunAtLocation.FGSMS_SERVER);
            r.setClassName("org.miloss.fgsms.sla.rules.StaleData");
            s.setRule((RuleBaseType)r);
            s.setGuid(UUID.randomUUID().toString());
            s.setAction(new ArrayOfSLAActionBaseType());
            e = Utility.newEmailAction(null, "Stale Data Alert for " + Utility.encodeHTML(ret.getURL()), "Stale Data Alert for " + Utility.encodeHTML(ret.getURL()) + ". This is the default alert that indicates that either a server or agent is offline. This alert can be changed by changing the policy for this service.");
            s.getAction().getSLAAction().add(e);
            ret.getServiceLevelAggrements().getSLA().add(s);
        }
    }

    public static synchronized JAXBContext getARSSerializationContext() throws JAXBException {
        if (arsctx == null) {
            arsctx = JAXBContext.newInstance((Class[])new Class[]{ReportDefinition.class, TimeRangeDiff.class, ScheduleDefinition.class, AbstractSchedule.class, ExportCSVDataRequestMsg.class, ExportDataRequestMsg.class, Daynames.class, DailySchedule.class, WeeklySchedule.class, MonthlySchedule.class, SLAAction.class, NameValuePair.class, OneTimeSchedule.class, SecurityWrapper.class, TimeRange.class, ArrayOfReportTypeContainer.class, ReportTypeContainer.class, ExportDataRequestMsg.class, String.class, Calendar.class, ExportCSVDataRequestMsg.class, ExportRecordsEnum.class});
        }
        return arsctx;
    }

    public static synchronized JAXBContext getSerializationContext() throws JAXBException {
        if (serialctx == null) {
            serialctx = JAXBContext.newInstance((Class[])new Class[]{ArrayOfSLA.class, SLA.class, SLAAction.class, RuleBaseType.class, GeoTag.class, Long.class, Double.TYPE, String.class, ServicePolicy.class, GeoTag.class, ArrayOfUserIdentity.class, Duration.class, PolicyType.class, ArrayOfSLAActionBaseType.class, ArrayOfServicePolicy.class, FederationPolicy.class, FederationPolicyCollection.class, AddData.class, AddMoreData.class, AddDataRequestMsg.class, Header.class, ProcessPolicy.class, MachinePolicy.class, AlertMessageDefinition.class, StatusServicePolicy.class, StatisticalServicePolicy.class, TransactionalWebServicePolicy.class, RunAtLocation.class, DriveInformation.class, SetProcessListByMachineResponseMsg.class, SetProcessListByMachineRequestMsg.class, MachineInformation.class, NetworkAdapterInfo.class, PropertyPair.class, NetworkAdapterPerformanceData.class, NameValuePair.class, SLARuleGeneric.class, NameValuePairSet.class});
        }
        return serialctx;
    }

    public static void validateClassification(SecurityWrapper w) {
        if (w == null || w.getClassification() == null) {
            throw new IllegalArgumentException("A classification level must be specified");
        }
    }

    public static String getHostName() {
        if (myHostname == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                myHostname = addr.getHostName().toLowerCase();
            }
            catch (Exception e) {
                myHostname = "ADDRESS_UNKNOWN";
            }
        }
        return myHostname;
    }

    public static boolean hasEmailSLA(ServicePolicy pc) {
        if (pc == null) {
            return false;
        }
        if (pc.getServiceLevelAggrements() == null || pc.getServiceLevelAggrements().getSLA().isEmpty()) {
            return false;
        }
        for (int i = 0; i < pc.getServiceLevelAggrements().getSLA().size(); ++i) {
            if (((SLA)pc.getServiceLevelAggrements().getSLA().get(i)).getAction() == null || ((SLA)pc.getServiceLevelAggrements().getSLA().get(i)).getAction().getSLAAction().isEmpty()) continue;
            for (int k = 0; k < ((SLA)pc.getServiceLevelAggrements().getSLA().get(i)).getAction().getSLAAction().size(); ++k) {
                if (!((SLAAction)((SLA)pc.getServiceLevelAggrements().getSLA().get(i)).getAction().getSLAAction().get(k)).getImplementingClassName().equals("org.miloss.fgsms.sla.actions.EmailAlerter")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEmailSLA(ArrayOfSLAActionBaseType pc) {
        if (pc == null) {
            return false;
        }
        if (pc.getSLAAction().isEmpty()) {
            return false;
        }
        for (int i = 0; i < pc.getSLAAction().size(); ++i) {
            if (!((SLAAction)pc.getSLAAction().get(i)).getImplementingClassName().equals("org.miloss.fgsms.sla.actions.EmailAlerter")) continue;
            return true;
        }
        return false;
    }

    public static String EN(String clear) {
        if (Utility.stringIsNullOrEmpty(clear)) {
            return "";
        }
        try {
            return AES.EN(clear);
        }
        catch (Exception ex) {
            log.log((Priority)Level.FATAL, "############################################# fgsms cannot encrypt! Check to make sure the unlimited strength JCE is installed: " + ex.getMessage());
            return "";
        }
    }

    public static String DE(String cipher) {
        if (Utility.stringIsNullOrEmpty(cipher)) {
            return "";
        }
        try {
            return AES.DE(cipher);
        }
        catch (Exception ex) {
            log.log((Priority)Level.FATAL, "############################################# fgsms cannot decrypt! Check to make sure the unlimited strength JCE is installed: " + ex.getMessage());
            return cipher;
        }
    }

    public static String durationToString(Duration d) {
        if (d == null) {
            return "";
        }
        String s = "";
        if (d.getYears() > 0) {
            s = s + d.getYears() + "yr ";
        }
        if (d.getMonths() > 0) {
            s = s + d.getMonths() + "mo ";
        }
        if (d.getDays() > 0) {
            s = s + d.getDays() + "d ";
        }
        if (d.getHours() > 0) {
            s = s + d.getHours() + "hr ";
        }
        if (d.getMinutes() > 0) {
            s = s + d.getMinutes() + "min ";
        }
        if (d.getSeconds() > 0) {
            s = s + d.getSeconds() + "s ";
        }
        return s.trim();
    }

    public static String durationLargestUnitToString(Duration d) {
        if (d == null) {
            return "";
        }
        if (d.getYears() > 0) {
            return d.getYears() + "yr";
        }
        if (d.getMonths() > 0) {
            return d.getMonths() + "mo";
        }
        if (d.getDays() > 0) {
            return d.getDays() + "d";
        }
        if (d.getHours() > 0) {
            return d.getHours() + "hr";
        }
        if (d.getMinutes() > 0) {
            return d.getMinutes() + "min";
        }
        if (d.getSeconds() > 0) {
            return d.getSeconds() + "s";
        }
        return "";
    }

    public static String ICMClassificationToString(ClassificationType type) {
        if (type == null) {
            return "UNCLASSIFIED";
        }
        switch (type) {
            case U: {
                return "UNCLASSIFIED";
            }
            case R: {
                return "RESTRICTED";
            }
            case C: {
                return "CONFIDENTIAL";
            }
            case S: {
                return "SECRET";
            }
            case TS: {
                return "TOP SECRET";
            }
            case CTS: {
                return "COSMIC TS";
            }
            case NU: {
                return "NATO UNCLASSIFIED";
            }
            case NC: {
                return "NATO CONFIDENTIAL";
            }
            case NR: {
                return "NATO RESTRICTED";
            }
            case NS: {
                return "NATO SECRET";
            }
            case CTSA: {
                return "COSMIC TOP SECRET ATOMAL";
            }
            case NSAT: {
                return "NATO SECRET ATOMAL";
            }
            case NCA: {
                return "NATO CLASSIFIED ATOMAL";
            }
            case CTS_BALK: {
                return "COSMIC TOP SECRET BALK";
            }
            case CTS_B: {
                return "COSMIC TOP SECRET Bohemia";
            }
        }
        return "CLASSIFIED: " + type.value();
    }

    public static String ICMClassificationToColorCodeString(ClassificationType type) {
        if (type == null) {
            return "lime";
        }
        switch (type) {
            case U: {
                return "lime";
            }
            case R: {
                return "yellow";
            }
            case C: {
                return "blue";
            }
            case S: {
                return "red";
            }
            case TS: {
                return "orange";
            }
            case CTS: {
                return "red";
            }
            case NU: {
                return "lime";
            }
            case NC: {
                return "purple";
            }
            case NR: {
                return "purple";
            }
            case NS: {
                return "purple";
            }
            case CTSA: {
                return "orange";
            }
            case NSAT: {
                return "purple";
            }
            case NCA: {
                return "purple";
            }
            case CTS_BALK: {
                return "orange";
            }
            case CTS_B: {
                return "orange";
            }
        }
        return "red";
    }

    public static String listStringtoString(List<String> data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            if (Utility.stringIsNullOrEmpty(data.get(i))) continue;
            String t = data.get(i);
            if (Utility.stringIsNullOrEmpty(t = t.trim())) continue;
            sb = sb.append(t).append(" ");
        }
        return sb.toString().trim();
    }

    public static String getActionNameFromXML(String xml) {
        if (Utility.stringIsNullOrEmpty(xml)) {
            return "";
        }
        try {
            int i;
            DeferredElementImpl j;
            ByteArrayInputStream is = null;
            Document xmlDocument = null;
            try {
                is = new ByteArrayInputStream(xml.trim().getBytes("UTF-8"));
                xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            catch (Exception ex) {
                log.log((Priority)Level.DEBUG, "fgsms Utility, error identifying request method by building request message as xml document: " + ex.getLocalizedMessage());
            }
            if (xmlDocument == null) {
                String workingdoc = "";
                try {
                    workingdoc = xml.substring(xml.indexOf("<"), xml.lastIndexOf(">"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Utility.stringIsNullOrEmpty(workingdoc)) {
                    log.log((Priority)Level.WARN, "fgsms Utility, error identifying request method by building request message as xml document: this most likely isn't xml");
                    return "";
                }
                if (Utility.stringIsNullOrEmpty(xml)) {
                    is = new ByteArrayInputStream(workingdoc.getBytes("UTF-8"));
                }
                xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xp = xpath.compile("/Envelope/Body");
            try {
                j = (DeferredElementImpl)xp.evaluate(xmlDocument, XPathConstants.NODE);
                for (i = 0; i < j.getChildNodes().getLength(); ++i) {
                    if (j.getChildNodes().item(i).getNodeName().equalsIgnoreCase("#text")) continue;
                    log.log((Priority)Level.DEBUG, "Found action via com.sun.org.apache.xerces.internal.dom.DeferredElementImpl");
                    return j.getChildNodes().item(i).getNodeName();
                }
            }
            catch (NoClassDefFoundError c) {
                log.log((Priority)Level.DEBUG, "couldn't find com.sun.org.apache.xerces.internal.dom.DeferredElementImpl, trying alternate method...");
            }
            catch (ClassCastException e) {
                log.log((Priority)Level.DEBUG, "couldn't find com.sun.org.apache.xerces.internal.dom.DeferredElementImpl, trying alternate method...");
            }
            catch (Exception ex) {
                log.log((Priority)Level.DEBUG, "error caught using com.sun.org.apache.xerces.internal.dom.DeferredElementImpl, trying alternate method...", ex);
            }
            try {
                j = (org.apache.xerces.dom.DeferredElementImpl)xp.evaluate(xmlDocument, XPathConstants.NODE);
                for (i = 0; i < j.getChildNodes().getLength(); ++i) {
                    if (j.getChildNodes().item(i).getNodeName().equalsIgnoreCase("#text")) continue;
                    Node n = j.getChildNodes().item(i);
                    String s = n.getNodeName();
                    s = n.getNodeValue();
                    s = n.getNodeValue();
                    s = n.getBaseURI();
                    log.log((Priority)Level.DEBUG, "Found action via org.apache.xerces.dom.DeferredElementImpl");
                    return j.getChildNodes().item(i).getNodeName();
                }
            }
            catch (NoClassDefFoundError c) {
                log.log((Priority)Level.DEBUG, "couldn't find org.apache.xerces.dom.DeferredElementImpl, giving up determining action");
            }
            catch (Exception ex) {
                log.log((Priority)Level.DEBUG, "error caught using org.apache.xerces.dom.DeferredElementImpl", ex);
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.DEBUG, "fgsms Utility, error identifying request method from xml, defaulted to urn:undeterminable", ex);
        }
        return "";
    }

    public static String encodeHTML(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return StringEscapeUtils.escapeHtml4((String)s);
    }

    public static boolean stringIsNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static long durationToTimeInMS(Duration d) {
        if (d == null) {
            throw new IllegalArgumentException("duration cannot be null");
        }
        return d.getTimeInMillis(new GregorianCalendar());
    }

    public static String truncate(String x, int length) {
        if (x == null || x.length() == 0) {
            return "";
        }
        String ret = x;
        if (x.length() > length) {
            ret = x.substring(0, length);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static Connection getPerformanceDB_NONPOOLED_Connection_FAILOVER() {
        Connection connection;
        Properties prop = PropertyLoader.loadProperties(PropertyFilePath);
        Driver d = (Driver)Class.forName(prop.getProperty(DBdriver)).newInstance();
        DriverManager.registerDriver(d);
        Connection con = DriverManager.getConnection(prop.getProperty(PerformanceDBURL_FAILOVER), prop.getProperty(PerformanceUsername_FAILOVER), Utility.DE(prop.getProperty(PerformancePassword_FAILOVER)));
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            Connection connection2;
            try {
                log.log((Priority)Level.FATAL, "Error obtaining secondary perf database connection, msg:" + e.getLocalizedMessage(), e);
                connection2 = null;
            }
            catch (Throwable throwable) {
                try {
                    DBUtils.safeClose(com);
                    throw throwable;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.FATAL, "No connection to the secondary database could be made, msg:" + ex.getLocalizedMessage(), ex);
                    return null;
                }
            }
            DBUtils.safeClose(com);
            return connection2;
        }
        DBUtils.safeClose(com);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Connection getPerformanceDB_NONPOOLED_Connection() {
        Connection connection;
        Properties prop = PropertyLoader.loadProperties(PropertyFilePath);
        Driver d = (Driver)Class.forName(prop.getProperty(DBdriver)).newInstance();
        DriverManager.registerDriver(d);
        Connection con = DriverManager.getConnection(prop.getProperty(PerformanceDBURL), prop.getProperty(PerformanceUsername), Utility.DE(prop.getProperty(PerformancePassword)));
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            Connection connection2;
            try {
                log.log((Priority)Level.ERROR, "Error obtaining primary perf database connection, attempting alternate. msg:" + e.getLocalizedMessage(), e);
                connection2 = Utility.getPerformanceDB_NONPOOLED_Connection_FAILOVER();
            }
            catch (Throwable throwable) {
                try {
                    DBUtils.safeClose(com);
                    throw throwable;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, "No connection to the performance database could be made, msg:" + ex.getLocalizedMessage(), ex);
                    return null;
                }
            }
            DBUtils.safeClose(com);
            return connection2;
        }
        DBUtils.safeClose(com);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Connection getConfigurationDB_NONPOOLED_Connection() {
        Connection connection;
        Properties prop = PropertyLoader.loadProperties(PropertyFilePath);
        Driver d = (Driver)Class.forName(prop.getProperty(DBdriver)).newInstance();
        DriverManager.registerDriver(d);
        Connection con = DriverManager.getConnection(prop.getProperty(ConfigDBURL), prop.getProperty(ConfigUsername), Utility.DE(prop.getProperty(ConfigPassword)));
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            Connection connection2;
            try {
                log.log((Priority)Level.ERROR, "Error obtaining primary config database connection, attempting alternate. msg:" + e.getLocalizedMessage(), e);
                connection2 = Utility.getConfigurationDB_NONPOOLED_Connection_FAILOVER();
            }
            catch (Throwable throwable) {
                try {
                    DBUtils.safeClose(com);
                    throw throwable;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, "Error obtaining primary conf database connection:" + ex.getLocalizedMessage(), ex);
                    return Utility.getConfigurationDB_NONPOOLED_Connection_FAILOVER();
                }
            }
            DBUtils.safeClose(com);
            return connection2;
        }
        DBUtils.safeClose(com);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static Connection getConfigurationDB_NONPOOLED_Connection_FAILOVER() {
        Connection connection;
        Properties prop = PropertyLoader.loadProperties(PropertyFilePath);
        Driver d = (Driver)Class.forName(prop.getProperty(DBdriver)).newInstance();
        DriverManager.registerDriver(d);
        Connection con = DriverManager.getConnection(prop.getProperty(ConfigDBURL_FAILOVER), prop.getProperty(ConfigUsername_FAILOVER), Utility.DE(prop.getProperty(ConfigPassword_FAILOVER)));
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            Connection connection2;
            try {
                log.log((Priority)Level.FATAL, "Error obtaining failover config database connection, attempting alternate. msg:" + e.getLocalizedMessage(), e);
                connection2 = null;
            }
            catch (Throwable throwable) {
                try {
                    DBUtils.safeClose(com);
                    throw throwable;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.FATAL, "Error obtaining primary conf database connection:" + ex.getLocalizedMessage(), ex);
                    return null;
                }
            }
            DBUtils.safeClose(com);
            return connection2;
        }
        DBUtils.safeClose(com);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getPerformanceDBConnection() {
        Connection connection;
        Exception root = null;
        InitialContext ctx1 = new InitialContext();
        DataSource ds = (DataSource)ctx1.lookup("java:fgsmsPerformance");
        Connection con = ds.getConnection();
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            try {
                try {
                    root = e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.safeClose(com);
                }
            }
            catch (Exception ex) {
                root = ex;
            }
        }
        DBUtils.safeClose(com);
        return connection;
        ctx1 = new InitialContext();
        ds = (DataSource)ctx1.lookup("java:/comp/env/jdbc/fgsmsPerformance");
        con = ds.getConnection();
        com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            Connection e = con;
        }
        catch (Exception e) {
            try {
                try {
                    root = e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.safeClose(com);
                }
            }
            catch (Exception ex) {
                root = ex;
            }
        }
        DBUtils.safeClose(com);
        return e;
        ctx1 = new InitialContext();
        ds = (DataSource)ctx1.lookup(JDBC_PERFORMANCE);
        con = ds.getConnection();
        com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            Connection e = con;
        }
        catch (Exception e) {
            try {
                try {
                    root = e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.safeClose(com);
                }
            }
            catch (Exception ex) {
                root = ex;
            }
        }
        DBUtils.safeClose(com);
        return e;
        if (root != null) {
            log.log((Priority)Level.WARN, "Error obtaining primary pooled performance database connection, attempting alternate. msg:" + root.getLocalizedMessage(), root);
        }
        return Utility.getAlternatePerformanceDBConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getAlternatePerformanceDBConnection() {
        Connection connection;
        Exception root = null;
        InitialContext ctx1 = new InitialContext();
        DataSource ds = (DataSource)ctx1.lookup("java:fgsmsPerformanceSecondary");
        Connection con = ds.getConnection();
        PreparedStatement com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            connection = con;
        }
        catch (Exception e) {
            try {
                try {
                    root = e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.safeClose(com);
                }
            }
            catch (Exception ex) {
                root = ex;
            }
        }
        DBUtils.safeClose(com);
        return connection;
        ctx1 = new InitialContext();
        ds = (DataSource)ctx1.lookup("java:/comp/env/jdbc/fgsmsPerformanceSecondary");
        con = ds.getConnection();
        com = con.prepareStatement("select 1;");
        try {
            com.execute();
            DBUtils.safeClose(com);
            Connection e = con;
        }
        catch (Exception e) {
            try {
                try {
                    root = e;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtils.safeClose(com);
                }
            }
            catch (Exception ex) {
                root = ex;
            }
        }
        DBUtils.safeClose(com);
        return e;
        if (root != null && root != null) {
            log.log((Priority)Level.FATAL, "Error obtaining secondary pooled performance database connection, giving up. Ensure that the database is available. msg:" + root.getLocalizedMessage(), root);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConfigurationDBConnection() {
        Exception root;
        block40: {
            Connection e3;
            PreparedStatement com;
            Connection con;
            DataSource ds;
            InitialContext ctx1;
            block39: {
                block38: {
                    AutoCloseable com2;
                    block37: {
                        Connection connection;
                        root = null;
                        ctx1 = new InitialContext();
                        Context env = (Context)ctx1.lookup("java:/comp/env");
                        DataSource ds2 = (DataSource)env.lookup(JDBC_CONFIG);
                        Connection con2 = ds2.getConnection();
                        com2 = con2.prepareStatement("select 1;");
                        try {
                            com2.execute();
                            DBUtils.safeClose(com2);
                            connection = con2;
                        }
                        catch (Exception e2) {
                            try {
                                try {
                                    e2.printStackTrace();
                                    root = e2;
                                    if (System.getProperties().containsKey("debug")) {
                                        log.log((Priority)Level.WARN, "Error obtaining primary conf pooled performance database connection, attempting alternate. msg:" + e2.getLocalizedMessage(), e2);
                                    }
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    DBUtils.safeClose(com2);
                                }
                            }
                            catch (Exception ex) {
                                root = ex;
                                if (!System.getProperties().containsKey("debug")) break block37;
                                log.log((Priority)Level.WARN, "Error obtaining primary conf pooled database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                            }
                        }
                        DBUtils.safeClose(com2);
                        return connection;
                    }
                    ctx1 = new InitialContext();
                    ds = (DataSource)ctx1.lookup("java:fgsmsConfig");
                    con = ds.getConnection();
                    com = con.prepareStatement("select 1;");
                    try {
                        com.execute();
                        DBUtils.safeClose(com);
                        com2 = con;
                    }
                    catch (Exception e3) {
                        try {
                            try {
                                e3.printStackTrace();
                                root = e3;
                                if (System.getProperties().containsKey("debug")) {
                                    log.log((Priority)Level.WARN, "Error obtaining primary conf pooled performance database connection, attempting alternate. msg:" + e3.getLocalizedMessage(), e3);
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                DBUtils.safeClose(com);
                            }
                        }
                        catch (Exception ex) {
                            root = ex;
                            if (!System.getProperties().containsKey("debug")) break block38;
                            log.log((Priority)Level.WARN, "Error obtaining primary conf pooled database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                        }
                    }
                    DBUtils.safeClose(com);
                    return com2;
                }
                ctx1 = new InitialContext();
                ds = (DataSource)ctx1.lookup(JDBC_CONFIG);
                con = ds.getConnection();
                com = con.prepareStatement("select 1;");
                try {
                    com.execute();
                    DBUtils.safeClose(com);
                    e3 = con;
                }
                catch (Exception e4) {
                    try {
                        try {
                            e4.printStackTrace();
                            root = e4;
                            if (System.getProperties().containsKey("debug")) {
                                log.log((Priority)Level.WARN, "Error obtaining primary conf pooled performance database connection, attempting alternate. msg:" + e4.getLocalizedMessage(), e4);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            DBUtils.safeClose(com);
                        }
                    }
                    catch (Exception ex) {
                        root = ex;
                        if (!System.getProperties().containsKey("debug")) break block39;
                        log.log((Priority)Level.WARN, "Error obtaining primary conf pooled database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                    }
                }
                DBUtils.safeClose(com);
                return e3;
            }
            ctx1 = new InitialContext();
            ds = (DataSource)ctx1.lookup("fgsmsConfig");
            con = ds.getConnection();
            com = con.prepareStatement("select 1;");
            try {
                com.execute();
                DBUtils.safeClose(com);
                e3 = con;
            }
            catch (Exception e5) {
                try {
                    try {
                        e5.printStackTrace();
                        root = e5;
                        if (System.getProperties().containsKey("debug")) {
                            log.log((Priority)Level.WARN, "Error obtaining primary conf pooled performance database connection, attempting alternate. msg:" + e5.getLocalizedMessage(), e5);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DBUtils.safeClose(com);
                    }
                }
                catch (Exception ex) {
                    root = ex;
                    if (!System.getProperties().containsKey("debug")) break block40;
                    log.log((Priority)Level.WARN, "Error obtaining primary conf pooled database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                }
            }
            DBUtils.safeClose(com);
            return e3;
        }
        if (root != null) {
            log.log((Priority)Level.WARN, "Error obtaining primary conf pooled database connection, attempting alternate. msg:" + root.getLocalizedMessage(), root);
        }
        return Utility.getAlternateConfigurationDBConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getAlternateConfigurationDBConnection() {
        Exception root;
        block20: {
            PreparedStatement com;
            Connection con;
            DataSource ds;
            InitialContext ctx1;
            block19: {
                Connection connection;
                root = null;
                ctx1 = new InitialContext();
                ds = (DataSource)ctx1.lookup("java:fgsmsConfigSecondary");
                con = ds.getConnection();
                com = con.prepareStatement("select 1;");
                try {
                    com.execute();
                    DBUtils.safeClose(com);
                    connection = con;
                }
                catch (Exception e) {
                    try {
                        try {
                            root = e;
                            if (System.getProperties().containsKey("debug")) {
                                log.log((Priority)Level.WARN, "Error obtaining secondary pooled config database connection, attempting alternate. msg:" + e.getLocalizedMessage(), e);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            DBUtils.safeClose(com);
                        }
                    }
                    catch (Exception ex) {
                        root = ex;
                        if (!System.getProperties().containsKey("debug")) break block19;
                        log.log((Priority)Level.WARN, "Error obtaining secondary pooled conf database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                    }
                }
                DBUtils.safeClose(com);
                return connection;
            }
            ctx1 = new InitialContext();
            ds = (DataSource)ctx1.lookup("java:/comp/env/jdbc/fgsmsConfigSecondary");
            con = ds.getConnection();
            com = con.prepareStatement("select 1;");
            try {
                com.execute();
                DBUtils.safeClose(com);
                Connection e = con;
            }
            catch (Exception e) {
                try {
                    try {
                        root = e;
                        if (System.getProperties().containsKey("debug")) {
                            log.log((Priority)Level.FATAL, "Error obtaining secondary pooled config database connection, attempting alternate. msg:" + e.getLocalizedMessage(), e);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DBUtils.safeClose(com);
                    }
                }
                catch (Exception ex) {
                    root = ex;
                    if (!System.getProperties().containsKey("debug")) break block20;
                    log.log((Priority)Level.FATAL, "Error obtaining secondary pooled conf database connection, attempting alternate. msg:" + ex.getLocalizedMessage(), ex);
                }
            }
            DBUtils.safeClose(com);
            return e;
        }
        if (root != null) {
            log.log((Priority)Level.FATAL, "Error obtaining secondary pooled config database connection, attempting alternate. msg:" + root.getLocalizedMessage(), root);
        }
        return null;
    }

    public static NameValuePair newNameValuePair(String name, String val, boolean encrypted, boolean encryptOnSave) {
        NameValuePair r = new NameValuePair();
        r.setName(name);
        r.setValue(val);
        r.setEncrypted(Boolean.valueOf(encrypted));
        r.setEncryptOnSave(Boolean.valueOf(encryptOnSave));
        return r;
    }

    public static SLAAction newEmailAction(String from, String subject, String body) {
        SLAAction r = new SLAAction();
        r.setImplementingClassName("org.miloss.fgsms.sla.actions.EmailAlerter");
        if (!Utility.stringIsNullOrEmpty(from)) {
            r.getParameterNameValue().add(Utility.newNameValuePair("From", from, false, false));
        }
        r.getParameterNameValue().add(Utility.newNameValuePair("Body", body, false, false));
        r.getParameterNameValue().add(Utility.newNameValuePair("Subject", subject, false, false));
        return r;
    }

    public static NameValuePair getNameValuePairByName(List<NameValuePair> set, String name) {
        if (set == null) {
            return null;
        }
        for (int i = 0; i < set.size(); ++i) {
            if (!set.get(i).getName().equalsIgnoreCase(name)) continue;
            return set.get(i);
        }
        return null;
    }

    public static Plugin newPlugin(String classname, String displayname, String appliesto) {
        Plugin p = new Plugin();
        p.setClassname(classname);
        p.setDisplayname(displayname);
        p.setPlugintype(appliesto);
        return p;
    }

    public static List<PolicyType> getAllPolicyTypes() {
        ArrayList<PolicyType> r = new ArrayList<PolicyType>();
        PolicyType[] values = PolicyType.values();
        r.addAll(Arrays.asList(values));
        return r;
    }

    public static boolean containsPolicyType(List<PolicyType> appliesTo, PolicyType optionalPolicyTypeFilter) {
        if (appliesTo == null) {
            return false;
        }
        if (optionalPolicyTypeFilter == null) {
            return false;
        }
        for (int i = 0; i < appliesTo.size(); ++i) {
            if (!appliesTo.get(i).equals((Object)optionalPolicyTypeFilter)) continue;
            return true;
        }
        return false;
    }

    public static KeyNameValue newKeyNameValue(String key, String name, String value) {
        KeyNameValue x = new KeyNameValue();
        x.setPropertyKey(key);
        x.setPropertyName(name);
        x.setPropertyValue(value);
        return x;
    }

    public static KeyNameValueEnc newKeyNameValueEnc(KeyNameValue value, boolean shouldEncrypt) {
        KeyNameValueEnc x = new KeyNameValueEnc();
        x.setKeyNameValue(value);
        x.setShouldEncrypt(shouldEncrypt);
        return x;
    }
}

