/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agents;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.agents.JbossWSCommonMessageHandler;
import org.miloss.fgsms.common.Logger;

public class JbossWSMonitor
implements SOAPHandler<SOAPMessageContext> {
    private Logger log = Logger.getLogger((String)"fgsms.Agents");

    public boolean handleMessage(SOAPMessageContext messageContext) {
        long start = System.currentTimeMillis();
        Boolean isRequest = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound") == false;
        if (isRequest.booleanValue()) {
            try {
                this.ProcessInboundMessage(messageContext);
            }
            catch (SOAPException ex) {
                this.log.log((Priority)Level.WARN, (Object)"fgsms Error processing inbound message", (Throwable)ex);
                return true;
            }
        }
        try {
            this.ProcessOutboundMessage(messageContext, false);
        }
        catch (SOAPException ex) {
            this.log.log((Priority)Level.WARN, (Object)"fgsms Error processing outbound message", (Throwable)ex);
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return Collections.EMPTY_SET;
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        Boolean isRequest = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound") == false;
        if (isRequest.booleanValue()) {
            try {
                this.ProcessInboundMessage(messageContext);
            }
            catch (SOAPException ex) {
                this.log.log((Priority)Level.WARN, (Object)"fgsms Error processing inbound message", (Throwable)ex);
                return true;
            }
        }
        try {
            this.ProcessOutboundMessage(messageContext, true);
        }
        catch (SOAPException ex) {
            this.log.log((Priority)Level.WARN, (Object)"fgsms Error processing outbound message", (Throwable)ex);
        }
        return true;
    }

    public void close(MessageContext context) {
    }

    private void ProcessInboundMessage(SOAPMessageContext messageContext) throws SOAPException {
        JbossWSCommonMessageHandler.ProcessRequest(messageContext, false, this.getClass().getCanonicalName());
    }

    private void ProcessOutboundMessage(SOAPMessageContext messageContext, boolean fault) throws SOAPException {
        JbossWSCommonMessageHandler.ProcessResponse(messageContext, fault, false, this.getClass().getCanonicalName());
    }
}

