/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.AuditLogger;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.reporting.ReportGeneratorPlugin;
import org.miloss.fgsms.services.interfaces.common.GetOperatingStatusRequestMessage;
import org.miloss.fgsms.services.interfaces.common.GetOperatingStatusResponseMessage;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.faults.ServiceUnavailableFaultCodes;
import org.miloss.fgsms.services.interfaces.reportingservice.AccessDeniedException;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportCSVDataRequestMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataRequestMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToCSVResponseMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToHTMLResponseMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ReportTypeContainer;
import org.miloss.fgsms.services.interfaces.reportingservice.ReportingService;
import org.miloss.fgsms.services.interfaces.reportingservice.ServiceUnavailableException;
import org.miloss.fgsms.services.interfaces.status.OpStatusService;
import org.miloss.fgsms.services.rs.impl.CsvExporter;
import us.gov.ic.ism.v2.ClassificationType;

@WebService(name="reportingService", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService")
@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.WRAPPED, use=SOAPBinding.Use.LITERAL)
public class Reporting
implements ReportingService,
OpStatusService {
    protected static final String delimiter = "|";
    protected static final String name = "fgsms.ReportingService";
    private static DatatypeFactory df = null;
    public static final Logger log = Logger.getLogger((String)"fgsms.ReportingService");
    private static Calendar started = null;
    public static final String allitems = "All-Methods";
    private static Map<String, ReportGeneratorPlugin> reportingPlugins;
    @Resource
    private WebServiceContext ctx;

    public Reporting() throws DatatypeConfigurationException {
        this.InitDF();
    }

    private synchronized void InitDF() throws DatatypeConfigurationException {
        if (df == null) {
            df = DatatypeFactory.newInstance();
        }
        if (started == null) {
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(System.currentTimeMillis());
            started = gcal;
        }
        reportingPlugins = new HashMap<String, ReportGeneratorPlugin>();
    }

    public Reporting(WebServiceContext w) throws DatatypeConfigurationException {
        this.ctx = w;
        this.InitDF();
    }

    @WebMethod(operationName="ExportDataToHTML", action="urn:org:miloss:fgsms:services:interfaces:reportingService/reportingService/ExportDataToHTML")
    @WebResult(name="ExportDataToHTMLResult", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService")
    @RequestWrapper(localName="ExportDataToHTML", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService", className="org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToHTML")
    @ResponseWrapper(localName="ExportDataToHTMLResponse", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService", className="org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToHTMLResponse")
    public ExportDataToHTMLResponseMsg exportDataToHTML(@WebParam(name="request", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService") ExportDataRequestMsg request) throws AccessDeniedException, ServiceUnavailableException {
        String currentUser = UserIdentityUtil.getFirstIdentityToString((WebServiceContext)this.ctx);
        return this.generateHtmlReport(currentUser, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExportDataToHTMLResponseMsg generateHtmlReport(String currentUser, ExportDataRequestMsg request) throws AccessDeniedException, ServiceUnavailableException {
        if (request == null) {
            AuditLogger.logItem((String)this.getClass().getCanonicalName(), (String)"exportDataToHTML", (String)currentUser, (String)"", (String)"not specified", (MessageContext)this.ctx.getMessageContext());
            throw new IllegalArgumentException("request is null");
        }
        Utility.validateClassification((SecurityWrapper)request.getClassification());
        AuditLogger.logItem((String)this.getClass().getCanonicalName(), (String)"exportDataToHTML", (String)currentUser, (String)"", (SecurityWrapper)request.getClassification(), this.ctx != null ? this.ctx.getMessageContext() : null);
        if (request.getRange() == null || request.getRange().getEnd() == null || request.getRange().getStart() == null) {
            throw new IllegalArgumentException("range is null");
        }
        if (request.getReportTypes() == null || request.getReportTypes().getReportTypeContainer() == null || request.getReportTypes().getReportTypeContainer().isEmpty()) {
            throw new IllegalArgumentException("ReportTypes is null, at least one must be specified");
        }
        if (!request.isAllServices() && (request.getURLs() == null || request.getURLs().isEmpty())) {
            throw new IllegalArgumentException("AllServices must be true or at least one URL must be specified");
        }
        String path = "";
        String header = "";
        String currentFolder = "";
        String footer = "";
        File targetfolder = null;
        UUID id = UUID.randomUUID();
        try {
            boolean mkdir;
            currentFolder = System.getProperty("jboss.server.temp.dir");
            if (currentFolder == null || currentFolder.equals("") || currentFolder.equalsIgnoreCase("null")) {
                currentFolder = System.getProperty("java.io.tmpdir");
            }
            if (!(mkdir = (targetfolder = new File(path = currentFolder + Reporting.getFilePathDelimitor() + id.toString())).mkdir())) {
                HttpServletRequest session = (HttpServletRequest)this.ctx.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
                targetfolder = (File)session.getAttribute("javax.servlet.context.tmpdir");
            }
            if (!targetfolder.exists()) {
                log.log((Priority)Level.INFO, (Object)("fgsms.ReportingServiceexportDataToHTML, unable to create temporary directory " + currentFolder + targetfolder.getAbsolutePath()));
                ServiceUnavailableException f = new ServiceUnavailableException("", null);
                f.getFaultInfo().setCode(ServiceUnavailableFaultCodes.MISCONFIGURATION);
                throw f;
            }
            header = this.getHeader();
            footer = this.getFooter();
        }
        catch (Exception e) {
            log.log((Priority)Level.INFO, (Object)("fgsms.ReportingServiceexportDataToHTML, load props" + e));
            ServiceUnavailableException f = new ServiceUnavailableException("", null);
            f.getFaultInfo().setCode(ServiceUnavailableFaultCodes.MISCONFIGURATION);
            throw f;
        }
        ArrayList<String> files = new ArrayList<String>();
        Calendar time = null;
        header = header.replaceAll("%DATETIME_NOW%", new Date().toString());
        time = request.getRange().getStart();
        header = header.replaceAll("%DATETIME_FROM%", time.getTime().toString());
        time = request.getRange().getEnd();
        header = header.replaceAll("%DATETIME_TO%", time.getTime().toString());
        if (request.getClassification() == null) {
            request.setClassification(this.getClassLevelFromDB());
        }
        header = header.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " - " + request.getClassification().getCaveats());
        header = header.replaceAll("%COLOR%", Utility.ICMClassificationToColorCodeString((ClassificationType)request.getClassification().getClassification()));
        footer = footer.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " - " + request.getClassification().getCaveats());
        footer = footer.replaceAll("%COLOR%", Utility.ICMClassificationToColorCodeString((ClassificationType)request.getClassification().getClassification()));
        StringBuilder x = new StringBuilder();
        x.append("<ul>");
        if (request.isAllServices()) {
            x.append(this.buildAllServiceList(request, currentUser));
        } else {
            for (int i = 0; i < request.getURLs().size(); ++i) {
                x.append("<li>").append(Utility.encodeHTML((String)((String)request.getURLs().get(i)))).append("</li>\n");
            }
        }
        x.append("</ul>");
        header = header.replaceAll("%SERVICE_LIST%", x.toString());
        OutputStreamWriter fw = null;
        try {
            File f = new File(path + Reporting.getFilePathDelimitor() + "index.html");
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            List<String> urls = this.urlListRead(request.isAllServices(), request.getURLs(), currentUser, request.getClassification());
            fw.write(header);
            for (int i = 0; i < request.getReportTypes().getReportTypeContainer().size(); ++i) {
                ReportGeneratorPlugin plugin = null;
                String name = ((ReportTypeContainer)request.getReportTypes().getReportTypeContainer().get(i)).getType();
                if (reportingPlugins.containsKey(name)) {
                    plugin = reportingPlugins.get(name);
                }
                if (plugin == null) {
                    try {
                        plugin = (ReportGeneratorPlugin)Class.forName(name).newInstance();
                        reportingPlugins.put(name, plugin);
                    }
                    catch (Throwable t) {
                        log.log((Priority)Level.WARN, (Object)(name + " could not load the user specified reporting plugin"), t);
                    }
                }
                if (plugin == null) {
                    throw new IllegalArgumentException("unknwon report type;" + ((ReportTypeContainer)request.getReportTypes().getReportTypeContainer().get(i)).getType());
                }
                plugin.generateReport(fw, urls, path, files, request.getRange(), currentUser, this.getClassLevelFromDB(), this.ctx);
            }
            fw.write(footer);
            fw.flush();
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceWriteAllText, ", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ex) {
                    log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceWriteAllText, ", (Throwable)ex);
                }
            }
        }
        x = null;
        files.add(path + Reporting.getFilePathDelimitor() + "index.html");
        ExportDataToHTMLResponseMsg response = new ExportDataToHTMLResponseMsg();
        response.setClassification(this.getClassLevelFromDB());
        response.setZipFile(Reporting.generateZipFileandDelete(files, path));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHeader() {
        String x = null;
        InputStream s = null;
        try {
            s = this.getClass().getClassLoader().getResourceAsStream("org/miloss/fgsms/services/rs/impl/header.txt");
            x = Reporting.readAllText(s);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFooter() {
        String x = null;
        InputStream s = null;
        try {
            s = this.getClass().getClassLoader().getResourceAsStream("org/miloss/fgsms/services/rs/impl/footer.txt");
            x = Reporting.readAllText(s);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return x;
    }

    private String buildAllServiceList(ExportDataRequestMsg request, String currentUser) {
        List<String> urls = this.urlListRead(request.isAllServices(), request.getURLs(), currentUser, request.getClassification());
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < urls.size(); ++i) {
            list.append("<li>").append(Utility.encodeHTML((String)urls.get(i))).append("</li>\n");
        }
        return list.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> urlListRead(boolean allServices, List<String> requestedurls, String currentUser, SecurityWrapper sec) {
        ArrayList<String> urls;
        block9: {
            block10: {
                urls = new ArrayList<String>();
                if (!allServices) break block10;
                Connection con = Utility.getConfigurationDBConnection();
                PreparedStatement cmd = null;
                ResultSet rs = null;
                try {
                    if (UserIdentityUtil.hasGlobalAdministratorRole((String)currentUser, (String)"GenerateReports", (SecurityWrapper)sec, (WebServiceContext)this.ctx)) {
                        cmd = con.prepareStatement("select URI from servicepolicies;");
                    } else {
                        cmd = con.prepareStatement("select ObjectURI as URI from UserPermissions where username=? and ReadObject=1 or WriteObject=1 or AdministerObject=1 or AuditObject=1;");
                        cmd.setString(1, currentUser);
                    }
                    rs = cmd.executeQuery();
                    while (rs.next()) {
                        urls.add(rs.getString("URI"));
                    }
                }
                catch (Exception ex) {
                    try {
                        log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceGenerateReports", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose(cmd);
                        DBUtils.safeClose((Connection)con);
                        throw throwable;
                    }
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                    DBUtils.safeClose((Connection)con);
                    break block9;
                }
                DBUtils.safeClose((ResultSet)rs);
                DBUtils.safeClose((PreparedStatement)cmd);
                DBUtils.safeClose((Connection)con);
                break block9;
            }
            if (requestedurls != null && requestedurls.size() > 0) {
                for (int i = 0; i < requestedurls.size(); ++i) {
                    urls.add(requestedurls.get(i));
                    UserIdentityUtil.assertReadAccess((String)((String)urls.get(i)), (String)currentUser, (String)"urlListRead", (SecurityWrapper)sec, (WebServiceContext)this.ctx);
                }
            }
        }
        return urls;
    }

    protected static String readAllText(InputStream stream) {
        try {
            int size = 1024;
            byte[] chars = new byte[size];
            int k = stream.read(chars);
            StringBuilder str = new StringBuilder();
            while (k > 0) {
                for (int i = 0; i < k; ++i) {
                    str.append((char)chars[i]);
                }
                k = stream.read(chars);
            }
            return str.toString();
        }
        catch (Exception e) {
            log.log((Priority)Level.ERROR, (Object)"fgsms.ReportingServiceReadAllText, ", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAllText(String filename, String text) {
        OutputStreamWriter fw = null;
        try {
            File f = new File(filename);
            log.log((Priority)Level.INFO, (Object)("WriteAllText Current Dir = " + f.getName() + f.getAbsolutePath()));
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
            fw.write(text);
            fw.flush();
        }
        catch (Exception e) {
            log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceWriteAllText, ", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException ex) {
                    log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceWriteAllText, ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] generateZipFileandDelete(List<String> files, String path) {
        log.log((Priority)Level.INFO, (Object)("Report Service, Building Zip file at " + path + " for " + files.size() + " files"));
        byte[] buf = new byte[1024];
        ByteArrayOutputStream fos = null;
        ZipOutputStream out = null;
        try {
            File f;
            fos = new ByteArrayOutputStream();
            out = new ZipOutputStream(fos);
            for (int i = 0; i < files.size(); ++i) {
                String temp = files.get(i);
                log.log((Priority)Level.DEBUG, (Object)("adding " + files.get(i) + " to the zip"));
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(files.get(i));
                    ZipEntry z = new ZipEntry(temp.substring(temp.lastIndexOf(Reporting.getFilePathDelimitor()) + 1));
                    out.putNextEntry(z);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                }
                catch (Exception z) {
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                in = null;
            }
            out.flush();
            out.finish();
            out.flush();
            out.close();
            out = null;
            fos.flush();
            byte[] data = fos.toByteArray();
            fos.close();
            fos = null;
            log.log((Priority)Level.DEBUG, (Object)("Zip file created at " + data.length + " bytes"));
            for (int i = 0; i < files.size(); ++i) {
                try {
                    f = new File(files.get(i)).getCanonicalFile();
                    f.setWritable(true);
                    if (f == null || f.delete()) continue;
                    log.log((Priority)Level.WARN, (Object)("Error deleting file " + files.get(i)));
                    f.deleteOnExit();
                    continue;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, (Object)("Error deleting file " + files.get(i)), (Throwable)ex);
                }
            }
            f = null;
            try {
                f = new File(path).getCanonicalFile();
                f.setWritable(true);
                if (!f.delete()) {
                    log.log((Priority)Level.WARN, (Object)("Error deleting temp folder" + path));
                    f.deleteOnExit();
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)("Error deleting file " + path + Reporting.getFilePathDelimitor() + "output.zip"), (Throwable)ex);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServicegenerateZipFileandDelete", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    log.log((Priority)Level.DEBUG, (Object)"fgsms.ReportingServicegenerateZipFileandDelete", (Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    log.log((Priority)Level.DEBUG, (Object)"fgsms.ReportingServicegenerateZipFileandDelete", (Throwable)ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecurityWrapper getClassLevelFromDB() {
        SecurityWrapper t2;
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block5: {
            con = Utility.getConfigurationDBConnection();
            com = null;
            rs = null;
            com = con.prepareStatement("select classification, caveat from globalpolicies;");
            rs = com.executeQuery();
            if (!rs.next()) break block5;
            ClassificationType t2 = ClassificationType.fromValue((String)rs.getString(1));
            String cav = rs.getString(2);
            SecurityWrapper securityWrapper = new SecurityWrapper(t2, cav);
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return securityWrapper;
        }
        try {
            log.log((Priority)Level.ERROR, (Object)"unable to determine current classification level, defaulting to UNCLASSIFIED");
            t2 = new SecurityWrapper(ClassificationType.U, "None");
        }
        catch (SQLException ex) {
            SecurityWrapper securityWrapper;
            try {
                log.log((Priority)Level.ERROR, (Object)"error determining classification level from config db", (Throwable)ex);
                log.log((Priority)Level.ERROR, (Object)"unable to determine current classification level, defaulting to UNCLASSIFIED");
                securityWrapper = new SecurityWrapper(ClassificationType.U, "None");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)com);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return securityWrapper;
        }
        DBUtils.safeClose((ResultSet)rs);
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return t2;
    }

    public static int pixelHeightCalc(int items) {
        if (items > 0 && items < 3) {
            return items * 200;
        }
        if (items == 0) {
            return 200;
        }
        return items * 50;
    }

    @WebMethod(operationName="ExportDataToCSV", action="urn:org:miloss:fgsms:services:interfaces:reportingService/reportingService/ExportDataToCSV")
    @WebResult(name="ExportDataToCSVResult", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService")
    @RequestWrapper(localName="ExportDataToCSV", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService", className="org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToCSV")
    @ResponseWrapper(localName="ExportDataToCSVResponse", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService", className="org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToCSVResponse")
    public ExportDataToCSVResponseMsg exportDataToCSV(@WebParam(name="request", targetNamespace="urn:org:miloss:fgsms:services:interfaces:reportingService") ExportCSVDataRequestMsg request) throws ServiceUnavailableException {
        String currentUser = UserIdentityUtil.getFirstIdentityToString((WebServiceContext)this.ctx);
        if (request == null) {
            AuditLogger.logItem((String)this.getClass().getCanonicalName(), (String)"exportDataToHTML", (String)currentUser, (String)"null request", (String)"not specified", (MessageContext)this.ctx.getMessageContext());
            throw new IllegalArgumentException("request is null");
        }
        Utility.validateClassification((SecurityWrapper)request.getClassification());
        if (request.getRange() == null) {
            throw new IllegalArgumentException("time range");
        }
        if (request.getExportType() == null) {
            throw new IllegalArgumentException("a records type must be specified");
        }
        UserIdentityUtil.assertGlobalAdministratorRole((String)currentUser, (String)"exportDataToCSV", (SecurityWrapper)request.getClassification(), (WebServiceContext)this.ctx);
        return CsvExporter.exportDataToCSV(this.ctx, currentUser, this.getClassLevelFromDB(), request);
    }

    public static String getFilePathDelimitor() {
        return File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPolicyTypeOf(String uri, PolicyType p) {
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block8: {
            boolean bl;
            block7: {
                con = Utility.getConfigurationDBConnection();
                com = null;
                rs = null;
                try {
                    com = con.prepareStatement("select policytype from servicepolicies where uri=?");
                    com.setString(1, uri);
                    rs = com.executeQuery();
                    if (rs.next()) {
                        int x = rs.getInt(1);
                        if (PolicyType.values()[x].equals((Object)p)) {
                            bl = true;
                            DBUtils.safeClose((ResultSet)rs);
                            break block7;
                        }
                    }
                    DBUtils.safeClose((ResultSet)rs);
                    break block8;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    return false;
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return bl;
        }
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return false;
        finally {
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
        }
    }

    protected static String toSafeFileName(String url) {
        if (Utility.stringIsNullOrEmpty((String)url)) {
            return "EmptyFileName";
        }
        String s = url;
        s = s.replace("-", "--");
        s = s.replace('/', '-');
        s = s.replace('\\', '-');
        s = s.replace(':', '-');
        s = s.replace('*', '-');
        s = s.replace('|', '-');
        s = s.replace('<', '-');
        s = s.replace('>', '-');
        s = s.replace('?', '-');
        s = s.replace('\"', '-');
        s = s.replace('%', '-');
        s = s.replace('\"', '-');
        s = s.replace('{', '-');
        s = s.replace('}', '-');
        s = s.replace('[', '-');
        s = s.replace(']', '-');
        s = s.replace('~', '-');
        s = s.replace('!', '-');
        s = s.replace('$', '-');
        s = s.replace('&', '-');
        s = s.replace(';', '-');
        s = s.replace('#', '-');
        s = s.replace('@', '-');
        s = s.replace('(', '-');
        s = s.replace(')', '-');
        return s;
    }

    protected static String stripCommas(String string) {
        if (Utility.stringIsNullOrEmpty((String)string)) {
            return string;
        }
        return string.replace(',', ' ').trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod(operationName="GetOperatingStatus", action="urn:org:miloss:fgsms:services:interfaces:opStatusService/GetOperatingStatus")
    @WebResult(name="response", targetNamespace="urn:org:miloss:fgsms:services:interfaces:common")
    @RequestWrapper(localName="GetOperatingStatus", targetNamespace="urn:org:miloss:fgsms:services:interfaces:common", className="org.miloss.fgsms.services.interfaces.common.GetOperatingStatus")
    @ResponseWrapper(localName="GetOperatingStatusResponse", targetNamespace="urn:org:miloss:fgsms:services:interfaces:common", className="org.miloss.fgsms.services.interfaces.common.GetOperatingStatusResponse")
    public GetOperatingStatusResponseMessage getOperatingStatus(@WebParam(name="request", targetNamespace="urn:org:miloss:fgsms:services:interfaces:common") GetOperatingStatusRequestMessage request) {
        String currentUser = UserIdentityUtil.getFirstIdentityToString((WebServiceContext)this.ctx);
        Utility.validateClassification((SecurityWrapper)request.getClassification());
        AuditLogger.logItem((String)this.getClass().getCanonicalName(), (String)"getOperatingStatus", (String)currentUser, (String)"", (SecurityWrapper)request.getClassification(), (MessageContext)this.ctx.getMessageContext());
        GetOperatingStatusResponseMessage res = new GetOperatingStatusResponseMessage();
        res.setClassification(request.getClassification());
        res.setVersionInfo(new GetOperatingStatusResponseMessage.VersionInfo());
        res.getVersionInfo().setVersionData("7.0.0  2017.03.11 21:51.");
        res.getVersionInfo().setVersionSource(Constants.class.getCanonicalName());
        res.setStartedAt(started);
        boolean ok = true;
        Connection con = Utility.getConfigurationDBConnection();
        Connection con2 = Utility.getPerformanceDBConnection();
        PreparedStatement prepareStatement = null;
        PreparedStatement prepareStatement2 = null;
        try {
            prepareStatement = con.prepareStatement("select 1=1;");
            prepareStatement.execute();
            prepareStatement2 = con2.prepareStatement("select 1=1;");
            prepareStatement2.execute();
            res.setStatusMessage("OK");
        }
        catch (Exception ex) {
            try {
                ok = false;
                res.setStatusMessage("One or more of the database connections is available");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose((PreparedStatement)prepareStatement);
                DBUtils.safeClose(prepareStatement2);
                DBUtils.safeClose((Connection)con);
                DBUtils.safeClose((Connection)con2);
                throw throwable;
            }
            DBUtils.safeClose((PreparedStatement)prepareStatement);
            DBUtils.safeClose((PreparedStatement)prepareStatement2);
            DBUtils.safeClose((Connection)con);
            DBUtils.safeClose((Connection)con2);
        }
        DBUtils.safeClose((PreparedStatement)prepareStatement);
        DBUtils.safeClose((PreparedStatement)prepareStatement2);
        DBUtils.safeClose((Connection)con);
        DBUtils.safeClose((Connection)con2);
        res.setStatus(ok);
        return res;
    }
}

