/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.reporting.ReportGeneratorPlugin;
import org.miloss.fgsms.services.interfaces.common.NameValuePair;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.StatusRecordsExt;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;

public class AvailabilityByService
implements ReportGeneratorPlugin {
    public String GetDisplayName() {
        return "Availability By Service";
    }

    public String GetHtmlFormattedHelp() {
        return "This represents the availability over time. A value of 1 represents operational and 0 represents non-operational status. For web services, this is limited by the ability for the Bueller component to a) connect to the service and b) authenticate to it.";
    }

    public List<PolicyType> GetAppliesTo() {
        ArrayList<PolicyType> ret = new ArrayList<PolicyType>();
        ret.add(PolicyType.TRANSACTIONAL);
        ret.add(PolicyType.MACHINE);
        ret.add(PolicyType.PROCESS);
        ret.add(PolicyType.STATISTICAL);
        ret.add(PolicyType.STATUS);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URI</th><th>Number of status changes</th><th>Percent Uptime</th><th>Percent Downtime</th></tr>");
            DecimalFormat percentFormat = new DecimalFormat("###.#####");
            TimeSeriesCollection col = new TimeSeriesCollection();
            for (int i = 0; i < urls.size(); ++i) {
                if (!UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                TimeSeries s1 = new TimeSeries((Comparable)((Object)url), Millisecond.class);
                try {
                    data.append("<tr><td>").append(url).append("</td>");
                    List<StatusRecordsExt> records = this.getStatusRecords(urls.get(i), range, con);
                    if (records == null || records.isEmpty()) {
                        data.append("<td>-</td><td>-</td></tr>");
                        continue;
                    }
                    double uptime = this.getUptimePercentage(records, range);
                    data.append("<td>").append(records.size() + "").append("</td><td>").append(percentFormat.format(uptime)).append("</td><td>").append(percentFormat.format(100.0 - uptime)).append("</td></tr>");
                    TimeSeriesDataItem t = null;
                    for (int k = 0; k < records.size(); ++k) {
                        if (records.get((int)k).status) {
                            try {
                                t = new TimeSeriesDataItem((RegularTimePeriod)new Millisecond(records.get((int)k).gcal.getTime()), 1.0);
                                s1.addOrUpdate(t);
                            }
                            catch (Exception ex) {
                                Reporting.log.log((Priority)Level.WARN, null, (Throwable)ex);
                            }
                        } else {
                            try {
                                t = new TimeSeriesDataItem((RegularTimePeriod)new Millisecond(records.get((int)k).gcal.getTime()), 0.0);
                                s1.addOrUpdate(t);
                            }
                            catch (Exception ex) {
                                Reporting.log.log((Priority)Level.WARN, null, (Throwable)ex);
                            }
                        }
                        col.addSeries(s1);
                    }
                    continue;
                }
                catch (Exception ex) {
                    Reporting.log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
                }
            }
            chart = ChartFactory.createTimeSeriesChart((String)this.GetDisplayName(), (String)"Timestamp", (String)"Status", (XYDataset)col, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)800);
                data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
                files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
            }
            catch (IOException ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            Reporting.log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StatusRecordsExt> getStatusRecords(String url, TimeRange range, Connection con) {
        ResultSet rs;
        PreparedStatement com;
        ArrayList<StatusRecordsExt> ret;
        block13: {
            ret = new ArrayList<StatusRecordsExt>();
            com = null;
            rs = null;
            try {
                com = con.prepareStatement("select status from availability where uri=? and  utcdatetime < ? order by utcdatetime desc limit 1;");
                com.setString(1, url);
                com.setLong(2, range.getStart().getTimeInMillis());
                rs = com.executeQuery();
                if (rs.next()) {
                    StatusRecordsExt x = new StatusRecordsExt();
                    x.gcal = new GregorianCalendar();
                    x.gcal.setTimeInMillis(range.getStart().getTimeInMillis());
                    x.status = rs.getBoolean("status");
                    ret.add(x);
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.WARN, null, (Throwable)ex);
                break block13;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)com);
            }
            DBUtils.safeClose((PreparedStatement)com);
        }
        try {
            StatusRecordsExt x;
            com = con.prepareStatement("select * from availability where uri=? and  utcdatetime >= ?  and utcdatetime <=? order by utcdatetime asc;");
            com.setString(1, url);
            com.setLong(2, range.getStart().getTimeInMillis());
            com.setLong(3, range.getEnd().getTimeInMillis());
            rs = com.executeQuery();
            boolean lastStatus = true;
            while (rs.next()) {
                if (!ret.isEmpty()) {
                    StatusRecordsExt get = (StatusRecordsExt)ret.get(ret.size() - 1);
                    StatusRecordsExt x2 = new StatusRecordsExt();
                    x2.gcal = new GregorianCalendar();
                    x2.gcal.setTimeInMillis(rs.getLong("utcdatetime") - 1L);
                    x2.status = get.status;
                    ret.add(x2);
                }
                x = new StatusRecordsExt();
                x.gcal = new GregorianCalendar();
                x.gcal.setTimeInMillis(rs.getLong("utcdatetime"));
                lastStatus = x.status = rs.getBoolean("status");
                ret.add(x);
            }
            x = new StatusRecordsExt();
            x.gcal = new GregorianCalendar();
            x.gcal.setTimeInMillis(range.getEnd().getTimeInMillis());
            x.status = lastStatus;
            ret.add(x);
            ArrayList<StatusRecordsExt> arrayList = ret;
            return arrayList;
        }
        catch (Exception ex) {
            Reporting.log.log((Priority)Level.WARN, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)com);
        }
        return null;
    }

    private double getUptimePercentage(List<StatusRecordsExt> records, TimeRange range) {
        long totaluptime = 0L;
        long totaltime = range.getEnd().getTimeInMillis() - range.getStart().getTimeInMillis();
        if (records.size() == 1) {
            if (records.get((int)0).status) {
                return 100.0;
            }
            return 0.0;
        }
        for (int i = 0; i < records.size() - 1; ++i) {
            if (!records.get((int)i).status) continue;
            totaluptime += records.get((int)(i + 1)).gcal.getTimeInMillis() - records.get((int)i).gcal.getTimeInMillis();
        }
        if (records.get((int)(records.size() - 1)).status) {
            totaluptime += range.getEnd().getTimeInMillis() - records.get((int)(records.size() - 1)).gcal.getTimeInMillis();
        }
        if (totaltime > 0L) {
            return (double)totaluptime / (double)totaltime * 100.0;
        }
        return -1.0;
    }

    public List<NameValuePair> GetRequiredParameters() {
        return Collections.EMPTY_LIST;
    }

    public List<NameValuePair> GetOptionalParameters() {
        return Collections.EMPTY_LIST;
    }
}

