/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.reporting.ReportGeneratorPlugin;
import org.miloss.fgsms.services.interfaces.common.NameValuePair;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.sla.SLACommon;

public abstract class BaseReportGenerator
implements ReportGeneratorPlugin {
    protected static final String name = "fgsms.ReportingService";
    public static final Logger log = Logger.getLogger((String)"fgsms.ReportingService");
    public static String allitems = "All-Methods";
    public final DecimalFormat format = new DecimalFormat("###,###.##");

    public static String getPolicyDisplayName(String uri) {
        ServicePolicy policy = SLACommon.LoadPolicyPooled((String)uri);
        if (policy == null) {
            return uri;
        }
        if (policy.getDisplayName() != null && policy.getDisplayName().length() > 0) {
            return policy.getDisplayName();
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isPolicyTypeOf(String uri, PolicyType p) {
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block8: {
            boolean bl;
            block7: {
                con = Utility.getConfigurationDBConnection();
                com = null;
                rs = null;
                try {
                    com = con.prepareStatement("select policytype from servicepolicies where uri=?");
                    com.setString(1, uri);
                    rs = com.executeQuery();
                    if (rs.next()) {
                        int x = rs.getInt(1);
                        if (PolicyType.values()[x].equals((Object)p)) {
                            bl = true;
                            DBUtils.safeClose((ResultSet)rs);
                            break block7;
                        }
                    }
                    DBUtils.safeClose((ResultSet)rs);
                    break block8;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    return false;
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return bl;
        }
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return false;
        finally {
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
        }
    }

    public List<NameValuePair> GetRequiredParameters() {
        return Collections.EMPTY_LIST;
    }

    public List<NameValuePair> GetOptionalParameters() {
        return Collections.EMPTY_LIST;
    }
}

