/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;

public class ServiceLevelAgreementReport
extends BaseReportGenerator {
    public String GetDisplayName() {
        return "Service Level Agreement violations";
    }

    public String GetHtmlFormattedHelp() {
        return "Applies to all service policy types. This report generates a table and bar chart outlining all SLA violations for a given service. An SLA is basically a rule and action based on recorded data. An SLA Fault is not necessarily a performance and are based on the rules configured for each service.";
    }

    public List<PolicyType> GetAppliesTo() {
        ArrayList<PolicyType> ret = new ArrayList<PolicyType>();
        ret.add(PolicyType.TRANSACTIONAL);
        ret.add(PolicyType.MACHINE);
        ret.add(PolicyType.PROCESS);
        ret.add(PolicyType.STATISTICAL);
        ret.add(PolicyType.STATUS);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URI</th><th>SLA Violations</th></tr>");
            for (int i = 0; i < urls.size(); ++i) {
                block19: {
                    if (!ServiceLevelAgreementReport.isPolicyTypeOf(urls.get(i), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                    String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                    data.append("<tr><td>").append(url).append("</td><td>");
                    try {
                        cmd = con.prepareStatement("select count(*) from slaviolations where uri = ? and (utcdatetime > ?) and (utcdatetime < ?);");
                        cmd.setString(1, urls.get(i));
                        cmd.setLong(2, range.getStart().getTimeInMillis());
                        cmd.setLong(3, range.getEnd().getTimeInMillis());
                        rs = cmd.executeQuery();
                        long count = -1L;
                        try {
                            if (rs.next()) {
                                count = rs.getLong(1);
                            }
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.DEBUG, (Object)(" error querying database url:" + urls.get(i)), (Throwable)ex);
                        }
                        if (count >= 0L) {
                            data.append(count + "");
                        } else {
                            data.append("N/A");
                        }
                        if (count > 0L) {
                            set.addValue((double)count, (Comparable)((Object)url), (Comparable)((Object)url));
                        }
                        DBUtils.safeClose((ResultSet)rs);
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.ERROR, (Object)("Error opening or querying the database." + this.GetDisplayName()), (Throwable)ex);
                        break block19;
                    }
                    finally {
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("</td></tr>");
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(urls.size()));
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

