/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.broker;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;

public class QueueTopicCountByBroker
extends BaseReportGenerator {
    public String GetDisplayName() {
        return "Queue or Topic Count on a Message Broker";
    }

    public String GetHtmlFormattedHelp() {
        return "This represents the count of channels/topics/queues for a given message broker. For the chart, X axis is time, Y is queue/topic count";
    }

    public List<PolicyType> GetAppliesTo() {
        ArrayList<PolicyType> ret = new ArrayList<PolicyType>();
        ret.add(PolicyType.STATISTICAL);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URI</th><th>Channel Count</th></tr>");
            for (int i = 0; i < urls.size(); ++i) {
                long count;
                block14: {
                    if (!QueueTopicCountByBroker.isPolicyTypeOf(urls.get(i), PolicyType.STATISTICAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                    String url = Utility.encodeHTML((String)QueueTopicCountByBroker.getPolicyDisplayName(urls.get(i)));
                    data.append("<tr><td>").append(url).append("</td>");
                    count = 0L;
                    try {
                        cmd = con.prepareStatement("select canonicalname from brokerhistory where host=?  group by canonicalname;");
                        cmd.setString(1, urls.get(i));
                        rs = cmd.executeQuery();
                        if (rs.next()) {
                            ++count;
                        }
                        DBUtils.safeClose((ResultSet)rs);
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
                        break block14;
                    }
                    finally {
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("<td>").append(count + "").append("</td></tr>");
                set.addValue((double)count, (Comparable)((Object)urls.get(i)), (Comparable)((Object)urls.get(i)));
            }
            data.append("</table>");
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getRowCount()));
                data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
                files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

