/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.os;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.TimeSeriesContainer;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;

public class DiskIOReport
extends BaseReportGenerator {
    public String GetDisplayName() {
        return "Disk I/O";
    }

    public String GetHtmlFormattedHelp() {
        return "This represents the disk I/O operating on a logical partition on a given machine over time. For the chart, X axis is time, Y is I/O rate";
    }

    public List<PolicyType> GetAppliesTo() {
        ArrayList<PolicyType> ret = new ArrayList<PolicyType>();
        ret.add(PolicyType.MACHINE);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URI</th><th>Average Free Disk Space (all paritions)</th><th>Average Write KB/s</th><th>Average Read KB/s</th></tr>");
            TimeSeriesCollection col = new TimeSeriesCollection();
            for (int i = 0; i < urls.size(); ++i) {
                double average;
                String url;
                block33: {
                    if (!DiskIOReport.isPolicyTypeOf(urls.get(i), PolicyType.MACHINE) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                    url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                    average = 0.0;
                    data.append("<tr><td>").append(url).append("</td>");
                    try {
                        cmd = con.prepareStatement("select avg(freespace) from rawdatadrives where uri=? and utcdatetime > ? and utcdatetime < ?;");
                        cmd.setString(1, urls.get(i));
                        cmd.setLong(2, range.getStart().getTimeInMillis());
                        cmd.setLong(3, range.getEnd().getTimeInMillis());
                        rs = cmd.executeQuery();
                        if (rs.next()) {
                            average = rs.getDouble(1);
                        }
                        DBUtils.safeClose((ResultSet)rs);
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.WARN, null, (Throwable)ex);
                        break block33;
                    }
                    finally {
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("<td>").append(average + "").append("</td>");
                average = 0.0;
                try {
                    cmd = con.prepareStatement("select avg(writekbs) from rawdatadrives where uri=? and utcdatetime > ? and utcdatetime < ?;");
                    cmd.setString(1, urls.get(i));
                    cmd.setLong(2, range.getStart().getTimeInMillis());
                    cmd.setLong(3, range.getEnd().getTimeInMillis());
                    rs = cmd.executeQuery();
                    if (rs.next()) {
                        average = rs.getDouble(1);
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                }
                finally {
                    DBUtils.safeClose((ResultSet)rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("<td>").append(average + "").append("</td>");
                average = 0.0;
                try {
                    cmd = con.prepareStatement("select avg(readkbs) from rawdatadrives where uri=? and utcdatetime > ? and utcdatetime < ?;");
                    cmd.setString(1, urls.get(i));
                    cmd.setLong(2, range.getStart().getTimeInMillis());
                    cmd.setLong(3, range.getEnd().getTimeInMillis());
                    rs = cmd.executeQuery();
                    if (rs.next()) {
                        average = rs.getDouble(1);
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                }
                finally {
                    DBUtils.safeClose((ResultSet)rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("<td>").append(average + "").append("</td></tr>");
                TimeSeriesContainer tsc = new TimeSeriesContainer();
                try {
                    cmd = con.prepareStatement("select readkbs, writekbs,freespace, utcdatetime, driveidentifier from rawdatadrives where uri=? and utcdatetime > ? and utcdatetime < ?;");
                    cmd.setString(1, urls.get(i));
                    cmd.setLong(2, range.getStart().getTimeInMillis());
                    cmd.setLong(3, range.getEnd().getTimeInMillis());
                    rs = cmd.executeQuery();
                    while (rs.next()) {
                        TimeSeries ts = tsc.Get(url + " " + rs.getString("driveidentifier") + " Read", Millisecond.class);
                        TimeSeries ts2 = tsc.Get(url + " " + rs.getString("driveidentifier") + " Write", Millisecond.class);
                        GregorianCalendar gcal = new GregorianCalendar();
                        gcal.setTimeInMillis(rs.getLong(4));
                        Millisecond m = new Millisecond(gcal.getTime());
                        ts.addOrUpdate((RegularTimePeriod)m, (double)rs.getLong("readKBs"));
                        ts2.addOrUpdate((RegularTimePeriod)m, (double)rs.getLong("writeKBs"));
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                }
                finally {
                    DBUtils.safeClose((ResultSet)rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                for (int ik = 0; ik < tsc.data.size(); ++ik) {
                    col.addSeries(tsc.data.get(ik));
                }
            }
            chart = ChartFactory.createTimeSeriesChart((String)this.GetDisplayName(), (String)"Timestamp", (String)"Rate", (XYDataset)col, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)400);
                data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
                files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

