/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class AverageMessageSizeByServiceByMethod
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Average Message Size By Service By Method";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + " This represents the average combined request and response message size of each " + "service grouped by method. A negative value generally indicates that the information was not able to be collected by the agent." + "For the chart, X axis is time, Y axis is response time";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        int itemcount = 0;
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>");
            data.append(this.GetDisplayName());
            data.append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URL</th><th>Action</th><th>Average Message Size (bytes)</th></tr>");
            itemcount = 0;
            for (int i = 0; i < urls.size(); ++i) {
                if (!AverageMessageSizeByServiceByMethod.isPolicyTypeOf(urls.get(i), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                try {
                    List<String> actions = this.getSoapActions(urls.get(i), con);
                    for (int k = 0; k < actions.size(); ++k) {
                        long count;
                        block21: {
                            ++itemcount;
                            count = -1L;
                            try {
                                cmd = con.prepareStatement("select AVG(responseSize + requestSize) as messagesSize from RawData where URI=? and (UTCdatetime > ?) and (UTCdatetime < ?) and soapaction=?");
                                cmd.setString(1, urls.get(i));
                                cmd.setLong(2, range.getStart().getTimeInMillis());
                                cmd.setLong(3, range.getEnd().getTimeInMillis());
                                cmd.setString(4, actions.get(k));
                                rs = cmd.executeQuery();
                                try {
                                    if (rs.next()) {
                                        count = rs.getLong(1);
                                    }
                                }
                                catch (Exception ex) {
                                    log.log((Priority)Level.DEBUG, (Object)(" error querying database for average message size url:" + urls.get(i)), (Throwable)ex);
                                }
                                DBUtils.safeClose((ResultSet)rs);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.ERROR, (Object)("Error opening or querying the database." + this.getClass().getSimpleName()), (Throwable)ex);
                                break block21;
                            }
                            finally {
                                DBUtils.safeClose(rs);
                                DBUtils.safeClose((PreparedStatement)cmd);
                            }
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        data.append("<tr><td>").append(url).append("</td><td>");
                        data.append(Utility.encodeHTML((String)actions.get(k)));
                        data.append("</td><td>");
                        if (count >= 0L) {
                            data.append(count + " bytes");
                        } else {
                            data.append("N/A");
                        }
                        data.append("</td></tr>");
                        if (count < 0L) continue;
                        set.addValue((double)count, (Comparable)((Object)actions.get(k)), (Comparable)((Object)url));
                    }
                    continue;
                }
                catch (Exception ex) {
                    data.append("0 bytes</td></tr>");
                    log.log((Priority)Level.ERROR, (Object)("Error opening or querying the database." + this.getClass().getSimpleName()), (Throwable)ex);
                }
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                int height = Reporting.pixelHeightCalc(itemcount);
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)height);
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

