/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class InvocationsByConsumer
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Invocations By Consumer";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + "Aggregated against all web service traffic, by client username or ip address";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        con = Utility.getPerformanceDBConnection();
        try {
            cmd = null;
            userQuery = null;
            rs = null;
            set = new DefaultCategoryDataset();
            chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append("This represents service usage by consumer for the provided services.<br />");
            data.append("<table class=\"table table-hover\"><tr><th>User</th><th>Invocations</th></tr>");
            actionRS = null;
            users = new HashSet<String>();
            try {
                userQuery = con.prepareStatement("select consumeridentity from rawdata group by consumeridentity");
                actionRS = userQuery.executeQuery();
                users.add("unspecified");
                while (actionRS.next()) {
                    try {
                        s = actionRS.getString(1);
                        if (Utility.stringIsNullOrEmpty((String)(s = s.trim()))) continue;
                        items = s.split(";");
                        for (x = 0; x < items.length; ++x) {
                            if (Utility.stringIsNullOrEmpty((String)items[x])) continue;
                            users.add(items[x].trim());
                        }
                    }
                    catch (Exception ex) {
                        InvocationsByConsumer.log.log((Priority)Level.WARN, (Object)" error querying database", (Throwable)ex);
                    }
                }
                ** GOTO lbl44
            }
            catch (Exception ex) {
                try {
                    InvocationsByConsumer.log.log((Priority)Level.WARN, (Object)" error querying database", (Throwable)ex);
                }
                catch (Throwable var20_28) {
                    DBUtils.safeClose(actionRS);
                    DBUtils.safeClose((PreparedStatement)userQuery);
                    throw var20_28;
                }
lbl44:
                // 1 sources

                DBUtils.safeClose((ResultSet)actionRS);
                DBUtils.safeClose((PreparedStatement)userQuery);
                DBUtils.safeClose((ResultSet)actionRS);
                DBUtils.safeClose((PreparedStatement)userQuery);
            }
            try {
                for (String u : users) {
                    try {
                        if (u.equalsIgnoreCase("unspecified")) {
                            cmd = con.prepareStatement("select count(*)  from RawData where consumeridentity is null and (UTCdatetime > ?) and (UTCdatetime < ?)");
                            cmd.setLong(1, range.getStart().getTimeInMillis());
                            cmd.setLong(2, range.getEnd().getTimeInMillis());
                        } else {
                            cmd = con.prepareStatement("select count(*)  from RawData where consumeridentity=? and (UTCdatetime > ?) and (UTCdatetime < ?)");
                            cmd.setString(1, u);
                            cmd.setLong(2, range.getStart().getTimeInMillis());
                            cmd.setLong(3, range.getEnd().getTimeInMillis());
                        }
                        rs = cmd.executeQuery();
                        count = 0L;
                        try {
                            if (rs.next()) {
                                count = rs.getLong(1);
                            }
                        }
                        catch (Exception ex) {
                            InvocationsByConsumer.log.log((Priority)Level.DEBUG, (Object)" error querying database", (Throwable)ex);
                        }
                        data.append("<tr><td>").append(Utility.encodeHTML((String)u)).append("</td><td>");
                        data.append(count + "").append("</td></tr>");
                        if (count > 0L) {
                            set.addValue((double)count, (Comparable)u, (Comparable)u);
                        }
                        ** GOTO lbl85
                    }
                    catch (Exception ex) {
                        try {
                            InvocationsByConsumer.log.log((Priority)Level.WARN, (Object)" error querying database", (Throwable)ex);
                        }
                        catch (Throwable var22_30) {
                            DBUtils.safeClose(rs);
                            DBUtils.safeClose(cmd);
                            throw var22_30;
                        }
lbl85:
                        // 1 sources

                        DBUtils.safeClose((ResultSet)rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                        continue;
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                }
            }
            catch (Exception ex) {
                data.append("0</td></tr>");
                InvocationsByConsumer.log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
            }
            finally {
                DBUtils.safeClose(cmd);
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Consumers", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getRowCount()));
            }
            catch (IOException ex) {
                InvocationsByConsumer.log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
            return;
        }
        catch (Exception ex) {
            InvocationsByConsumer.log.log((Priority)Level.ERROR, null, (Throwable)ex);
            return;
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

