/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class InvocationsByConsumerByServiceByMethod
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Invocations by Consumer by Service by Method";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + " This represents the number of invocations (transactions) per consumer for each service grouped by method. Useful for identifying customers or consumers that are producing more traffic than others";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URL</th><th>Consumer</th><th>Method</th><th>Invocations</th></tr>");
            HashSet<String> consumers2 = new HashSet<String>();
            List<Object> actions = new ArrayList();
            for (int k = 0; k < urls.size(); ++k) {
                if (!InvocationsByConsumerByServiceByMethod.isPolicyTypeOf(urls.get(k), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(k), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(k)));
                consumers2.clear();
                actions.clear();
                try {
                    actions = this.getSoapActions(urls.get(k), con);
                    rs = null;
                    for (int k2 = 0; k2 < actions.size(); ++k2) {
                        block35: {
                            try {
                                consumers2.clear();
                                cmd = con.prepareStatement("select  consumeridentity from rawdata where uri=?  and (UTCdatetime > ?) and (UTCdatetime < ?) and soapaction=? group by consumeridentity;");
                                cmd.setString(1, urls.get(k));
                                cmd.setLong(2, range.getStart().getTimeInMillis());
                                cmd.setLong(3, range.getEnd().getTimeInMillis());
                                cmd.setString(4, (String)actions.get(k2));
                                rs = cmd.executeQuery();
                                while (rs.next()) {
                                    String s = rs.getString(1);
                                    if (Utility.stringIsNullOrEmpty((String)s)) continue;
                                    String[] ids = s.split(";");
                                    for (int i = 0; i < ids.length; ++i) {
                                        if (Utility.stringIsNullOrEmpty((String)ids[i]) || consumers2.contains(ids[i])) continue;
                                        consumers2.add(ids[i]);
                                    }
                                }
                                DBUtils.safeClose((ResultSet)rs);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.WARN, (Object)(" error querying database forINVOCATIONS_BY_CONSUMER_BY_SERVICE" + urls.get(k)), (Throwable)ex);
                                break block35;
                            }
                            finally {
                                DBUtils.safeClose(rs);
                                DBUtils.safeClose((PreparedStatement)cmd);
                            }
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        consumers2.add("unspecified");
                        for (String u : consumers2) {
                            long count = 0L;
                            try {
                                cmd = con.prepareStatement("select count(*) from RawData where URI=? and soapaction=? and (UTCdatetime > ?) and (UTCdatetime < ?) and consumeridentity ~* ?;");
                                cmd.setString(1, urls.get(k));
                                cmd.setString(2, (String)actions.get(k2));
                                cmd.setLong(3, range.getStart().getTimeInMillis());
                                cmd.setLong(4, range.getEnd().getTimeInMillis());
                                cmd.setString(5, u);
                                rs = cmd.executeQuery();
                                try {
                                    if (rs.next()) {
                                        count = rs.getLong(1);
                                    }
                                }
                                catch (Exception ex) {
                                    log.log((Priority)Level.WARN, (Object)(" error querying database forINVOCATIONS_BY_CONSUMER_BY_SERVICE" + urls.get(k)), (Throwable)ex);
                                }
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.WARN, null, (Throwable)ex);
                            }
                            finally {
                                DBUtils.safeClose((ResultSet)rs);
                                DBUtils.safeClose((PreparedStatement)cmd);
                            }
                            if (count <= 0L) continue;
                            data.append("<tr><td>").append(url).append("</td><td>").append(Utility.encodeHTML((String)u)).append("</td><td>").append(Utility.encodeHTML((String)((String)actions.get(k2)))).append("</td><td>");
                            data.append(count + "");
                            data.append("</td></tr>");
                            set.addValue((double)count, (Comparable)((Object)u), (Comparable)((Object)(urls.get(k) + " " + (String)actions.get(k2))));
                        }
                        long count = 0L;
                        try {
                            cmd = con.prepareStatement("select count(*) from RawData where URI=? and soapaction=? and (UTCdatetime > ?) and (UTCdatetime < ?) and consumeridentity is null;");
                            cmd.setString(1, urls.get(k));
                            cmd.setString(2, (String)actions.get(k2));
                            cmd.setLong(3, range.getStart().getTimeInMillis());
                            cmd.setLong(4, range.getEnd().getTimeInMillis());
                            rs = cmd.executeQuery();
                            try {
                                if (rs.next()) {
                                    count = rs.getLong(1);
                                }
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.WARN, (Object)(" error querying database forINVOCATIONS_BY_CONSUMER_BY_SERVICE" + urls.get(k)), (Throwable)ex);
                            }
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, null, (Throwable)ex);
                        }
                        finally {
                            DBUtils.safeClose((ResultSet)rs);
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        if (count <= 0L) continue;
                        data.append("<tr><td>").append(url).append("</td><td>unspecified</td><td>").append(Utility.encodeHTML((String)((String)actions.get(k2)))).append("</td><td>");
                        data.append(count + "");
                        data.append("</td></tr>");
                        set.addValue((double)count, (Comparable)((Object)"unspecified"), (Comparable)((Object)(url + " " + (String)actions.get(k2))));
                    }
                    continue;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
                }
            }
            data.append("</table>");
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getColumnCount()));
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

