/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class InvocationsByDataCollector
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Invocations by Data Collector";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return "This report is useful for load balancing transactional/web service agents that report to the FGSMS server(s).";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        int itemcount = 0;
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            if (!UserIdentityUtil.hasGlobalAdministratorRole((String)currentuser, (String)"THROUGHPUT_BY_HOSTING_SERVER", (SecurityWrapper)classification, (WebServiceContext)ctx)) {
                data.append("<h2>Access for " + this.GetDisplayName() + " was denied for non-global admin users</h2>");
                return;
            }
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append("This represents Data Collector Service utilization.<br />");
            data.append("<table class=\"table table-hover\"><tr><th>Host</th><th>Invocations</th></tr>");
            ArrayList<String> dcs = new ArrayList<String>();
            try {
                cmd = con.prepareStatement("select monitorsource from rawdata group by monitorsource;");
                rs = cmd.executeQuery();
                while (rs.next()) {
                    dcs.add(rs.getString(1));
                }
            }
            catch (Exception ex) {
                try {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                    throw throwable;
                }
                DBUtils.safeClose((ResultSet)rs);
                DBUtils.safeClose((PreparedStatement)cmd);
            }
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)cmd);
            try {
                itemcount = dcs.size();
                for (int i = 0; i < dcs.size(); ++i) {
                    data.append("<tr><td>").append(Utility.encodeHTML((String)((String)dcs.get(i)))).append("</td><td>");
                    int success = 0;
                    try {
                        cmd = con.prepareStatement("select count(*) from RawData where monitorsource=? and UTCdatetime > ? and UTCdatetime < ?;");
                        cmd.setString(1, (String)dcs.get(i));
                        cmd.setLong(2, range.getStart().getTimeInMillis());
                        cmd.setLong(3, range.getEnd().getTimeInMillis());
                        rs = cmd.executeQuery();
                        if (rs.next()) {
                            success = rs.getInt(1);
                        }
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.WARN, null, (Throwable)ex);
                    }
                    finally {
                        DBUtils.safeClose((ResultSet)rs);
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                    data.append("<td>").append(success + "").append("</td></tr>");
                    set.addValue((double)success, (Comparable)dcs.get(i), (Comparable)dcs.get(i));
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"Error generating chart information.", (Throwable)ex);
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Monitoring Servers", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(itemcount));
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

