/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class MeanTimeBetweenFailureByService
extends BaseWebServiceReport {
    DatatypeFactory df;

    public MeanTimeBetweenFailureByService() {
        try {
            this.df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }

    public String GetDisplayName() {
        return "Mean time between faults (MTBF)";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + "This is the measure of average time between failed service invocations. Failed invocations for a service can be " + "for a number of reasons and may not necessarily be due to a problem with the service (could be network related, faulty clients, etc)." + "This report does not necessarily represent service up time.";
    }

    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        DefaultCategoryDataset set = new DefaultCategoryDataset();
        JFreeChart chart = null;
        data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
        data.append(this.GetHtmlFormattedHelp() + "<br />");
        data.append("<table class=\"table table-hover\"><tr><th>URL</th><th>MTBF (ms)</th><th>Timespan</th><th>XML Duration Value</th></tr>");
        for (int i = 0; i < urls.size(); ++i) {
            if (!MeanTimeBetweenFailureByService.isPolicyTypeOf(urls.get(i), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
            String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
            try {
                long mtbf = this.meanTimeBetweenFailures(urls.get(i), range);
                Duration newDuration = this.df.newDuration(mtbf);
                data.append("<tr><td>").append(url).append("</td><td>");
                if (mtbf == -1L || mtbf == 0L) {
                    data.append("Never</td><td>0</td><td>0</d></tr>");
                } else {
                    data.append(mtbf + "").append("ms</td><td>").append(Utility.durationToString((Duration)newDuration)).append("</td><td>").append(newDuration.toString()).append("</td></tr>");
                }
                if (mtbf <= 0L) continue;
                set.addValue((double)mtbf, (Comparable)((Object)url), (Comparable)((Object)url));
                continue;
            }
            catch (Exception ex) {
                data.append("0 bytes</td></tr>");
                log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
            }
        }
        chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
        data.append("</table>");
        try {
            if (set.getRowCount() != 0) {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getRowCount()));
                data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
                files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
            }
        }
        catch (IOException ex) {
            log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long meanTimeBetweenFailures(String url, TimeRange timeRange) {
        long l;
        ArrayList<Long> faults;
        ResultSet rs;
        PreparedStatement com;
        Connection con;
        block7: {
            con = Utility.getPerformanceDBConnection();
            com = null;
            rs = null;
            faults = new ArrayList<Long>();
            com = con.prepareStatement("select utcdatetime from rawdata where uri=? and success=false and (utcdatetime > ?) and (utcdatetime < ?);");
            com.setString(1, url);
            com.setLong(2, timeRange.getStart().getTimeInMillis());
            com.setLong(3, timeRange.getEnd().getTimeInMillis());
            rs = com.executeQuery();
            while (rs.next()) {
                faults.add(rs.getLong(1));
            }
            if (!faults.isEmpty()) break block7;
            long l2 = 0L;
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return l2;
        }
        try {
            Collections.sort(faults);
            long diff = 0L;
            for (int i = 1; i < faults.size(); ++i) {
                diff += (Long)faults.get(i) - (Long)faults.get(i - 1);
            }
            l = diff / (long)(faults.size() - 1);
        }
        catch (Exception ex) {
            try {
                log.log((Priority)Level.DEBUG, null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            return -1L;
        }
        DBUtils.safeClose((ResultSet)rs);
        DBUtils.safeClose((PreparedStatement)com);
        DBUtils.safeClose((Connection)con);
        return l;
    }
}

