/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class SuccessFailureCountByService
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Success and Failure Transaction Counts By Service";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append("This represents service invocation by success and failure rates.<br />");
            data.append("<table  class=\"table table-hover\"><tr><th>URL</th><th>Successes</th><th>Failures</th></tr>");
            try {
                for (int i = 0; i < urls.size(); ++i) {
                    int failures;
                    int success;
                    String url;
                    block25: {
                        block24: {
                            if (!SuccessFailureCountByService.isPolicyTypeOf(urls.get(i), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                            url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                            data.append("<tr><td>").append(url).append("</td>");
                            success = 0;
                            failures = 0;
                            try {
                                cmd = con.prepareStatement("select count(*) from RawData where uri=? and success=false and UTCdatetime > ? and UTCdatetime < ?;");
                                cmd.setString(1, urls.get(i));
                                cmd.setLong(2, range.getStart().getTimeInMillis());
                                cmd.setLong(3, range.getEnd().getTimeInMillis());
                                rs = cmd.executeQuery();
                                try {
                                    rs.next();
                                    failures = rs.getInt(1);
                                }
                                catch (Exception ex) {
                                    log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                                }
                                DBUtils.safeClose((ResultSet)rs);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.WARN, null, (Throwable)ex);
                                break block24;
                            }
                            finally {
                                DBUtils.safeClose(rs);
                                DBUtils.safeClose((PreparedStatement)cmd);
                            }
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        try {
                            cmd = con.prepareStatement("select count(*) from RawData where uri=? and success=true and UTCdatetime > ? and UTCdatetime < ?;");
                            cmd.setString(1, urls.get(i));
                            cmd.setLong(2, range.getStart().getTimeInMillis());
                            cmd.setLong(3, range.getEnd().getTimeInMillis());
                            rs = cmd.executeQuery();
                            try {
                                rs.next();
                                success = rs.getInt(1);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                            }
                            DBUtils.safeClose((ResultSet)rs);
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.WARN, null, (Throwable)ex);
                            break block25;
                        }
                        finally {
                            DBUtils.safeClose(rs);
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        DBUtils.safeClose((PreparedStatement)cmd);
                    }
                    data.append("<td>").append(success + "").append("</td>");
                    data.append("<td>").append(failures + "").append("</td></tr>");
                    set.addValue((double)success, (Comparable)((Object)(url + " Success")), (Comparable)((Object)(url + " Success")));
                    set.addValue((double)failures, (Comparable)((Object)(url + " Failures")), (Comparable)((Object)(url + " Failures")));
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"Error generating chart information.", (Throwable)ex);
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Services", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getRowCount()));
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

