/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class ThroughputByHostingServer
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Throughput By Hosting Server";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + "This represents the average invocation rate over the given period of time for a given service host. The accuracy of the data" + " is limited to the time range this report was generated from. For the chart, X axis is host, Y axis is is throughput (bytes total of all messages/time for a given host)." + " This data does not necessarily represent bytes on the wire and may or may not include transport overhead, headers, or packetization.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        if (!UserIdentityUtil.hasGlobalAdministratorRole((String)currentuser, (String)"INVOCATIONS_BY_HOSTING_SERVER", (SecurityWrapper)classification, (WebServiceContext)ctx)) {
            data.write("<h2>Access for " + this.GetDisplayName() + " was denied for non-global admin users</h2>");
            return;
        }
        double d = range.getEnd().getTimeInMillis() - range.getStart().getTimeInMillis();
        double day = d / 8.64E7;
        double hours = d / 3600000.0;
        double min = d / 60000.0;
        double sec = d / 1000.0;
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append(this.GetHtmlFormattedHelp() + "<br />");
            data.append("<table  class=\"table table-hover\"><tr><th>Service Hostname</th><th>Invocations</th><th>Msg/Day</th><th>Msg/Hour</th><th>Msg/Min</th><th>Msg/Sec</th></tr>");
            ArrayList<String> hosts = new ArrayList<String>();
            try {
                cmd = con.prepareStatement("select hostingsource from rawdata where (UTCdatetime > ?) and (UTCdatetime < ?) group by hostingsource ;");
                cmd.setLong(1, range.getStart().getTimeInMillis());
                cmd.setLong(2, range.getEnd().getTimeInMillis());
                rs = cmd.executeQuery();
                while (rs.next()) {
                    String s = rs.getString(1);
                    if (!Utility.stringIsNullOrEmpty((String)s)) {
                        s = s.trim();
                    }
                    if (Utility.stringIsNullOrEmpty((String)s)) continue;
                    hosts.add(s);
                }
            }
            catch (Exception s) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)cmd);
                catch (Throwable throwable) {
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                    throw throwable;
                }
            }
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)cmd);
            for (int i = 0; i < hosts.size(); ++i) {
                long count = 0L;
                try {
                    cmd = con.prepareStatement("select count(*) from RawData where hostingsource=? and (UTCdatetime > ?) and (UTCdatetime < ?) ;");
                    cmd.setString(1, (String)hosts.get(i));
                    cmd.setLong(2, range.getStart().getTimeInMillis());
                    cmd.setLong(3, range.getEnd().getTimeInMillis());
                    rs = cmd.executeQuery();
                    try {
                        if (rs.next()) {
                            count = rs.getLong(1);
                        }
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
                }
                finally {
                    DBUtils.safeClose((ResultSet)rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                }
                data.append("<tr><td>").append(Utility.encodeHTML((String)((String)hosts.get(i)))).append("</td><td>");
                data.append(count + "");
                data.append("</td><td>").append(this.format.format((double)count / day)).append("</td><td>").append(this.format.format((double)count / hours)).append("</td><td>").append(this.format.format((double)count / min)).append("</td><td>").append(this.format.format((double)count / sec)).append("</td></tr>");
                if (count <= 0L) continue;
                set.addValue((double)count / day, (Comparable)hosts.get(i), (Comparable)hosts.get(i));
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(hosts.size()));
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

