/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl.reports.ws;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.services.rs.impl.reports.BaseReportGenerator;
import org.miloss.fgsms.services.rs.impl.reports.ws.BaseWebServiceReport;

public class TotalMessageSizeByServiceByMethod
extends BaseWebServiceReport {
    public String GetDisplayName() {
        return "Total Message Size By Service By Method";
    }

    @Override
    public String GetHtmlFormattedHelp() {
        return super.GetHtmlFormattedHelp() + "Displays the sum of all request and response messages sizes, assuming it was recorded, grouped by service, by method. " + " This data does not necessarily include transport headers, encryption, or any kind transport overhead or packet level" + " retransmissions and represents the payload sizes that was recorded by the agent." + " The accuracy of the data" + " is limited to the time range this report was generated from. . For the chart, X axis is service, Y axis is bytes total for all messages by method. ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(OutputStreamWriter data, List<String> urls, String path, List<String> files, TimeRange range, String currentuser, SecurityWrapper classification, WebServiceContext ctx) throws IOException {
        Connection con = Utility.getPerformanceDBConnection();
        try {
            PreparedStatement cmd = null;
            long itemcount = 0L;
            ResultSet rs = null;
            DefaultCategoryDataset set = new DefaultCategoryDataset();
            JFreeChart chart = null;
            data.append("<hr /><h2>").append(this.GetDisplayName()).append("</h2>");
            data.append("This represents the total combined request and response message size of each service grouped by method.<br />");
            data.append("<table class=\"table table-hover\"><tr><th>URL</th><th>Action</th><th>Total Message Size (bytes)</th></tr>");
            for (int i = 0; i < urls.size(); ++i) {
                if (!TotalMessageSizeByServiceByMethod.isPolicyTypeOf(urls.get(i), PolicyType.TRANSACTIONAL) || !UserIdentityUtil.hasReadAccess((String)currentuser, (String)"getReport", (String)urls.get(i), (SecurityWrapper)classification, (WebServiceContext)ctx)) continue;
                String url = Utility.encodeHTML((String)BaseReportGenerator.getPolicyDisplayName(urls.get(i)));
                try {
                    List<String> actions = this.getSoapActions(urls.get(i), con);
                    itemcount = actions.size();
                    for (int k = 0; k < actions.size(); ++k) {
                        long count;
                        block21: {
                            count = -1L;
                            try {
                                cmd = con.prepareStatement("select SUM(responseSize + requestSize) as messagesSize from RawData where URI=? and (UTCdatetime > ?) and (UTCdatetime < ?) and soapaction=? and (requestsize>=0) and (responsesize>=0);");
                                cmd.setString(1, urls.get(i));
                                cmd.setLong(2, range.getStart().getTimeInMillis());
                                cmd.setLong(3, range.getEnd().getTimeInMillis());
                                cmd.setString(4, actions.get(k));
                                rs = cmd.executeQuery();
                                try {
                                    if (rs.next()) {
                                        count = rs.getLong(1);
                                    }
                                }
                                catch (Exception ex) {
                                    log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                                }
                                DBUtils.safeClose((ResultSet)rs);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.WARN, null, (Throwable)ex);
                                break block21;
                            }
                            finally {
                                DBUtils.safeClose(rs);
                                DBUtils.safeClose((PreparedStatement)cmd);
                            }
                            DBUtils.safeClose((PreparedStatement)cmd);
                        }
                        data.append("<tr><td>").append(url).append("</td><td>");
                        data.append(Utility.encodeHTML((String)actions.get(k))).append("</td><td>");
                        if (count >= 0L) {
                            data.append(count + " bytes");
                        } else {
                            data.append("N/A");
                        }
                        data.append("</td></tr>");
                        set.addValue((double)count, (Comparable)((Object)actions.get(k)), (Comparable)((Object)url));
                    }
                    continue;
                }
                catch (Exception ex) {
                    data.append("0 bytes</td></tr>");
                    log.log((Priority)Level.ERROR, (Object)"Error opening or querying the database.", (Throwable)ex);
                }
            }
            chart = ChartFactory.createBarChart((String)this.GetDisplayName(), (String)"Service URL", (String)"", (CategoryDataset)set, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            data.append("</table>");
            try {
                ChartUtilities.saveChartAsPNG((File)new File(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png"), (JFreeChart)chart, (int)1500, (int)Reporting.pixelHeightCalc(set.getRowCount()));
            }
            catch (IOException ex) {
                log.log((Priority)Level.ERROR, (Object)"Error saving chart image for request", (Throwable)ex);
            }
            data.append("<img src=\"image_").append(this.getClass().getSimpleName()).append(".png\">");
            files.add(path + Reporting.getFilePathDelimitor() + "image_" + this.getClass().getSimpleName() + ".png");
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)con);
        }
    }
}

