/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agents.smxviajmxagent;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.IpAddressUtility;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.PropertyLoader;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.datacollector.AddStatisticalDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.BrokerData;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfSLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLAAction;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.StatusServicePolicy;
import org.miloss.fgsms.sla.AuxHelper;
import org.miloss.fgsms.sla.SLACommon;
import org.miloss.fgsms.sla.actions.SLAActionRestart;

public class FgsmsSMXviaJMXAgent {
    static Logger log = Logger.getLogger((String)"fgsms.SMXJMX");
    private boolean running = true;
    private boolean done = false;
    private File file;
    private FileChannel channel;
    private FileLock lock;
    public static String[] urls = null;
    static final String AGENT = "org.miloss.fgsms.agents.amqp.jmx";

    private void closeLock() {
        try {
            this.lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this.file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new FgsmsSMXviaJMXAgent().Main(args);
    }

    private void Main(String[] args) {
        try {
            this.file = new File("smx.lck");
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            this.lock = this.channel.tryLock();
        }
        catch (Exception e) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file smx.lck needs to be deleted.");
            return;
        }
        if (this.lock == null) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file smx.lck needs to be deleted.");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new RunWhenShuttingDown());
        PropertyConfigurator.configure((String)"log4j.properties");
        long interval = 10000L;
        if (args.length == 1) {
            try {
                interval = Long.parseLong(args[0]);
                if (interval < 10000L) {
                    interval = 10000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.log((Priority)Level.INFO, (Object)"fgsms SMX JMX Agent startup...");
        Properties prop = PropertyLoader.loadProperties((String)"fgsms.smxviajmxagent/connection");
        String temp = (String)prop.get("JMXServiceURL");
        if (temp.contains("|")) {
            urls = temp.split("\\|");
        } else {
            urls = new String[1];
            FgsmsSMXviaJMXAgent.urls[0] = temp;
        }
        if (urls == null || urls.length == 0) {
            log.log((Priority)Level.FATAL, (Object)"no JMX url has been defined.");
            return;
        }
        long lastranat = 0L;
        while (this.running) {
            if (lastranat < System.currentTimeMillis() - interval) {
                try {
                    lastranat = System.currentTimeMillis();
                    for (int aa = 0; aa < urls.length; ++aa) {
                        String originalurl = urls[aa];
                        String url = IpAddressUtility.modifyURL((String)originalurl, (boolean)true);
                        try {
                            Connection con = Utility.getConfigurationDB_NONPOOLED_Connection();
                            AuxHelper.CheckStatisticalPolicyAndCreate((String)url, (Connection)con, (boolean)false, (String)"unspecified", (String)SLACommon.GetHostName());
                            con.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        FgsmsSMXviaJMXAgent.Fire(false, originalurl, url);
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, null, (Throwable)ex);
                }
                log.log((Priority)Level.INFO, (Object)("Sleeping " + interval + "ms until next interation...."));
            }
            if (this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    log.log((Priority)Level.ERROR, null, (Throwable)ex);
                }
            }
            this.done = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Fire(boolean pooled, String url, String modifiedurl) throws Exception {
        ServicePolicy p = null;
        p = pooled ? SLACommon.LoadPolicyPooled((String)modifiedurl) : SLACommon.LoadPolicyNotPooled((String)modifiedurl);
        JMXServiceURL u = new JMXServiceURL(url);
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        boolean hascred = false;
        boolean ok = true;
        String[] data = DBSettingsLoader.GetCredentials((boolean)pooled, (String)modifiedurl);
        if (data != null && data.length >= 2) {
            String[] cred = new String[]{data[0], Utility.DE((String)data[1])};
            m.put("jmx.remote.credentials", cred);
            hascred = true;
        }
        String status = "OK";
        JMXConnector c = null;
        try {
            c = hascred ? JMXConnectorFactory.connect(u, m) : JMXConnectorFactory.connect(u);
            AuxHelper.TryUpdateStatus((boolean)true, (String)modifiedurl, (String)status, (boolean)pooled, (PolicyType)PolicyType.STATISTICAL, (String)"unspecified", (String)SLACommon.GetHostName(), null);
        }
        catch (Exception ex) {
            status = ex.getMessage();
            if (status.equalsIgnoreCase("Expected String[2], got null")) {
                status = "No credentials were provided";
            }
            AuxHelper.TryUpdateStatus((boolean)false, (String)modifiedurl, (String)status, (boolean)pooled, (PolicyType)PolicyType.STATISTICAL, (String)"unspecified", (String)SLACommon.GetHostName(), null);
            log.log((Priority)Level.WARN, (Object)("SMX Server offline " + url + " " + status));
            ok = false;
        }
        if (ok && c != null) {
            log.log((Priority)Level.INFO, (Object)("SMX Server Online, updating ActiveMQ statistics" + url));
            MBeanServerConnection mBeanServerConnection = c.getMBeanServerConnection();
            Set<ObjectName> queryNames = mBeanServerConnection.queryNames(ObjectName.WILDCARD, null);
            Iterator<ObjectName> iterator = queryNames.iterator();
            String[] queueattribs = new String[]{"Name", "ConsumerCount", "DequeueCount", "DispatchCount", "EnqueueCount", "ExpiredCount", "ProducerCount", "QueueSize"};
            Connection perfcon = null;
            PreparedStatement ps = null;
            try {
                long QueueDepth;
                String name;
                perfcon = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
                ps = perfcon.prepareStatement("delete from brokerrawdata where host=?");
                ps.setString(1, modifiedurl);
                ps.executeUpdate();
                HashMap<String, Long> currenttopics = new HashMap<String, Long>();
                while (iterator.hasNext()) {
                    ObjectName n = iterator.next();
                    if (n == null || n.getCanonicalName() == null || !n.getCanonicalName().startsWith("org.apache.activemq:BrokerName")) continue;
                    AttributeList attributes = null;
                    try {
                        attributes = mBeanServerConnection.getAttributes(new ObjectName(n.getCanonicalName()), queueattribs);
                    }
                    catch (Exception ex2) {
                        try {
                            mBeanServerConnection = c.getMBeanServerConnection();
                            attributes = mBeanServerConnection.getAttributes(new ObjectName(n.getCanonicalName()), queueattribs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    log.log((Priority)Level.DEBUG, (Object)("Updating: " + n.getCanonicalName()));
                    String bigname = n.getCanonicalName();
                    String ExchangeType = bigname.contains("Type=Topic") ? "Topic" : "Queue";
                    long ExpiredCount = 0L;
                    long ConsumerCount = 0L;
                    long RecievedMessageCount = 0L;
                    long MessageCount = 0L;
                    name = "";
                    QueueDepth = 0L;
                    if (attributes != null) {
                        for (int i2 = 0; i2 < attributes.size(); ++i2) {
                            if (attributes.get(i2).toString().toLowerCase().startsWith("enqueuecount = ")) {
                                RecievedMessageCount = Long.parseLong(attributes.get(i2).toString().toLowerCase().replace("enqueuecount = ", "").trim());
                            }
                            if (attributes.get(i2).toString().toLowerCase().startsWith("dispatchcount = ")) {
                                MessageCount = Long.parseLong(attributes.get(i2).toString().toLowerCase().replace("dispatchcount = ", "").trim());
                            }
                            if (attributes.get(i2).toString().toLowerCase().startsWith("queuesize = ")) {
                                QueueDepth = Long.parseLong(attributes.get(i2).toString().toLowerCase().replace("queuesize = ", "").trim());
                            }
                            if (attributes.get(i2).toString().toLowerCase().startsWith("consumercount = ")) {
                                ConsumerCount = Long.parseLong(attributes.get(i2).toString().toLowerCase().replace("consumercount = ", "").trim());
                            }
                            if (attributes.get(i2).toString().toLowerCase().startsWith("name = ")) {
                                name = attributes.get(i2).toString().split("=")[1].trim();
                            }
                            if (!attributes.get(i2).toString().toLowerCase().startsWith("expiredcount = ")) continue;
                            ExpiredCount = Long.parseLong(attributes.get(i2).toString().toLowerCase().replace("expiredcount = ", "").trim());
                        }
                    }
                    if (Utility.stringIsNullOrEmpty((String)name)) continue;
                    currenttopics.put(n.getCanonicalName(), QueueDepth);
                    FgsmsSMXviaJMXAgent.UpdateData(modifiedurl, name, bigname, MessageCount, RecievedMessageCount, ConsumerCount, ConsumerCount, QueueDepth, ExchangeType, 0L, 0L, 0L, ExpiredCount, perfcon);
                }
                int components = 0;
                String[] componentattribs = new String[]{"CurrentState", "Name", "MainType"};
                queryNames = mBeanServerConnection.queryNames(ObjectName.WILDCARD, null);
                for (ObjectName n : queryNames) {
                    if (n == null || n.getCanonicalName() == null) continue;
                    AttributeList attributes = null;
                    try {
                        mBeanServerConnection = c.getMBeanServerConnection();
                        attributes = mBeanServerConnection.getAttributes(new ObjectName(n.getCanonicalName()), componentattribs);
                    }
                    catch (Exception ex2) {
                        try {
                            mBeanServerConnection = c.getMBeanServerConnection();
                            attributes = mBeanServerConnection.getAttributes(new ObjectName(n.getCanonicalName()), componentattribs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (attributes == null) continue;
                    String name2 = "";
                    String currentstate = "";
                    for (int i2 = 0; i2 < attributes.size(); ++i2) {
                        String[] temp = attributes.get(i2).toString().split("=");
                        if (temp.length != 2) continue;
                        if (temp[0].trim().equalsIgnoreCase("name")) {
                            name2 = temp[1].trim();
                        }
                        if (!temp[0].trim().equalsIgnoreCase("CurrentState")) continue;
                        currentstate = temp[1].trim();
                    }
                    if (Utility.stringIsNullOrEmpty((String)name2) || Utility.stringIsNullOrEmpty((String)currentstate)) continue;
                    boolean running = currentstate.toLowerCase().contains("start");
                    AuxHelper.TryUpdateStatus((boolean)running, (String)(modifiedurl + "/" + name2), (String)currentstate, (boolean)pooled, (PolicyType)PolicyType.STATUS, (String)"unspecified", (String)"unspecified", (String)modifiedurl);
                    if (!running) {
                        StatusServicePolicy spol = null;
                        spol = pooled ? (StatusServicePolicy)SLACommon.LoadPolicyPooled((String)(modifiedurl + "/" + name2)) : (StatusServicePolicy)SLACommon.LoadPolicyNotPooled((String)(modifiedurl + "/" + name2));
                        if (FgsmsSMXviaJMXAgent.containsRestartSLA(spol.getServiceLevelAggrements())) {
                            try {
                                Object RecievedMessageCount = mBeanServerConnection.invoke(n, "Start", null, null);
                            }
                            catch (Exception ex) {
                                log.log((Priority)Level.ERROR, (Object)("the attemp to restart the service identified by " + modifiedurl + "/" + name2), (Throwable)ex);
                            }
                        }
                    }
                    ++components;
                }
                queryNames = mBeanServerConnection.queryNames(ObjectName.WILDCARD, null);
                iterator = queryNames.iterator();
                AddStatisticalDataRequestMsg req = new AddStatisticalDataRequestMsg();
                while (iterator.hasNext()) {
                    ObjectName n = iterator.next();
                    if (n == null || n.getCanonicalName() == null || !n.getDomain().equalsIgnoreCase("org.apache.camel") || !n.getCanonicalName().contains("type=routes")) continue;
                    log.log((Priority)Level.DEBUG, (Object)("Updating: " + n.getCanonicalName()));
                    String bigname = n.getCanonicalName();
                    String ExchangeType = "Route";
                    long MessageCount = 0L;
                    long MessageDropCount = 0L;
                    long ExchangesTotal = 0L;
                    name = "";
                    QueueDepth = 0L;
                    try {
                        name = (String)mBeanServerConnection.getAttribute(n, "EndpointUri");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        MessageDropCount = (Long)mBeanServerConnection.getAttribute(n, "ExchangesFailed");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        MessageCount = (Long)mBeanServerConnection.getAttribute(n, "ExchangesCompleted");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ExchangesTotal = (Long)mBeanServerConnection.getAttribute(n, "ExchangesTotal");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (Utility.stringIsNullOrEmpty((String)name)) continue;
                    currenttopics.put(n.getCanonicalName(), QueueDepth);
                    req.getData().add(FgsmsSMXviaJMXAgent.UpdateData(modifiedurl, name, bigname, MessageCount, ExchangesTotal, 0L, 0L, QueueDepth, ExchangeType, 0L, 0L, 0L, MessageDropCount, perfcon));
                }
                log.log((Priority)Level.INFO, (Object)("SMX Server Online, updating status for " + components + " SMX components" + url));
                req.setAgentType(AGENT);
                req.setBrokerURI(modifiedurl);
                req.setBrokerHostname(p.getMachineName());
                req.setDomain(p.getDomainName());
                req.setClassification(SLACommon.GetClassLevel((boolean)pooled));
                req.setOperationalStatus(ok);
                req.setOperationalStatusMessage(status);
                SLACommon.ProcessStatisticalSLARules((AddStatisticalDataRequestMsg)req, (boolean)pooled);
            }
            catch (Exception ex) {
                try {
                    log.log((Priority)Level.ERROR, (Object)"Cannot connect to fgsms performance db, monitoring is not possible, exiting...");
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(ps);
                    DBUtils.safeClose((Connection)perfcon);
                    throw throwable;
                }
                DBUtils.safeClose((PreparedStatement)ps);
                DBUtils.safeClose((Connection)perfcon);
                return;
            }
            DBUtils.safeClose((PreparedStatement)ps);
            DBUtils.safeClose((Connection)perfcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BrokerData UpdateData(String url, String name, String bigname, long MessageCount, long RecievedMessageCount, long ConsumerCount, long ActiveConsumerCount, long QueueDepth, String ExchangeType, long bytesin, long bytesout, long bytesdrop, long MessageDropCount, Connection perf) {
        BrokerData bd = new BrokerData();
        bd.setActiveConsumers(QueueDepth);
        bd.setQueueOrTopicCanonicalName(bigname);
        bd.setQueueOrTopicName(name);
        bd.setMessagesIn(RecievedMessageCount);
        bd.setMessagesDropped(MessageDropCount);
        bd.setDepth(QueueDepth);
        bd.setActiveConsumers(ActiveConsumerCount);
        bd.setBytesDropped(bytesdrop);
        bd.setBytesIn(bytesin);
        bd.setBytesOut(bytesout);
        bd.setItemType(ExchangeType);
        bd.setMessagesOut(MessageCount);
        bd.setTotalConsumers(ConsumerCount);
        if (!Utility.stringIsNullOrEmpty((String)name)) {
            PreparedStatement comm = null;
            try {
                comm = perf.prepareStatement("Delete from brokerrawdata where host=? and namecol=? and canonicalname=?; INSERT INTO brokerrawdata (host, utcdatetime, namecol, canonicalname, messagecount,recievedmessagecount, consumercount, activeconsumercount, queuedepth, typecol, agenttype, messagedropcount, bytesdropcount, bytesin, bytesout) VALUES (?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);INSERT INTO brokerhistory (host, utcdatetime, namecol,canonicalname, messagecount,recievedmessagecount, consumercount, activeconsumercount, queuedepth, typecol, agenttype, messagedropcount, bytesdropcount, bytesin, bytesout) VALUES (?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
                comm.setString(1, url);
                comm.setString(2, name);
                comm.setString(3, bigname);
                comm.setString(4, url);
                comm.setLong(5, System.currentTimeMillis());
                comm.setString(6, name);
                comm.setString(7, bigname);
                comm.setLong(8, MessageCount);
                comm.setLong(9, RecievedMessageCount);
                comm.setLong(10, ConsumerCount);
                comm.setLong(11, ActiveConsumerCount);
                comm.setLong(12, QueueDepth);
                comm.setString(13, ExchangeType);
                comm.setString(14, AGENT);
                comm.setLong(15, MessageDropCount);
                comm.setLong(16, bytesdrop);
                comm.setLong(17, bytesin);
                comm.setLong(18, bytesout);
                comm.setString(19, url);
                comm.setLong(20, System.currentTimeMillis());
                comm.setString(21, name);
                comm.setString(22, bigname);
                comm.setLong(23, MessageCount);
                comm.setLong(24, RecievedMessageCount);
                comm.setLong(25, ConsumerCount);
                comm.setLong(26, ActiveConsumerCount);
                comm.setLong(27, QueueDepth);
                comm.setString(28, ExchangeType);
                comm.setString(29, AGENT);
                comm.setLong(30, MessageDropCount);
                comm.setLong(31, bytesdrop);
                comm.setLong(32, bytesin);
                comm.setLong(33, bytesout);
                comm.execute();
            }
            catch (SQLException ex) {
                log.log((Priority)Level.WARN, (Object)"error saving broker data", (Throwable)ex);
            }
            finally {
                DBUtils.safeClose((PreparedStatement)comm);
            }
        }
        return bd;
    }

    private static boolean containsRestartSLA(ArrayOfSLA serviceLevelAggrements) {
        if (serviceLevelAggrements == null) {
            return false;
        }
        if (serviceLevelAggrements.getSLA().isEmpty()) {
            return false;
        }
        for (int i = 0; i < serviceLevelAggrements.getSLA().size(); ++i) {
            if (((SLA)serviceLevelAggrements.getSLA().get(i)).getAction() == null) continue;
            for (int k = 0; k < ((SLA)serviceLevelAggrements.getSLA().get(i)).getAction().getSLAAction().size(); ++k) {
                if (!((SLAAction)((SLA)serviceLevelAggrements.getSLA().get(i)).getAction().getSLAAction().get(k)).getImplementingClassName().equalsIgnoreCase(SLAActionRestart.class.getCanonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    public class RunWhenShuttingDown
    extends Thread {
        @Override
        public void run() {
            System.out.println("Control-C caught. Shutting down...");
            FgsmsSMXviaJMXAgent.this.running = false;
            while (!FgsmsSMXviaJMXAgent.this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            FgsmsSMXviaJMXAgent.this.closeLock();
            FgsmsSMXviaJMXAgent.this.deleteFile();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    AuxHelper.TryUpdateStatus((boolean)false, (String)IpAddressUtility.modifyURL((String)urls[i], (boolean)true), (String)"Agent Stopped", (boolean)false, (PolicyType)PolicyType.STATISTICAL, (String)"unspecified", (String)SLACommon.GetHostName());
                }
            }
        }
    }
}

