/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.bueller;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AuthSSLProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(AuthSSLProtocolSocketFactory.class);
    private URL keystoreUrl = null;
    private String keystorePassword = null;
    private URL truststoreUrl = null;
    private String truststorePassword = null;
    private SSLContext sslcontext = null;

    public AuthSSLProtocolSocketFactory(URL keystoreUrl, String keystorePassword, URL truststoreUrl, String truststorePassword) {
        this.keystoreUrl = keystoreUrl;
        this.keystorePassword = keystorePassword;
        this.truststoreUrl = truststoreUrl;
        this.truststorePassword = truststorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        LOG.debug((Object)"Initializing key store");
        KeyStore keystore = KeyStore.getInstance("jks");
        InputStream is = null;
        try {
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return keystore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing key manager");
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing trust manager");
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory fac = TrustManagerFactory.getInstance(alg);
        fac.init(keystore);
        return fac.getTrustManagers();
    }

    private SSLContext createSSLContext() {
        try {
            String alias;
            Enumeration<String> aliases;
            KeyStore keystore;
            KeyManager[] keymanagers = null;
            TrustManager[] trustmanagers = null;
            if (this.keystoreUrl != null) {
                keystore = AuthSSLProtocolSocketFactory.createKeyStore(this.keystoreUrl, this.keystorePassword);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        Certificate[] certs = keystore.getCertificateChain(alias);
                        if (certs == null) continue;
                        LOG.debug((Object)("Certificate chain '" + alias + "':"));
                        for (int c = 0; c < certs.length; ++c) {
                            if (!(certs[c] instanceof X509Certificate)) continue;
                            X509Certificate cert = (X509Certificate)certs[c];
                            LOG.debug((Object)(" Certificate " + (c + 1) + ":"));
                            LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                            LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                            LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                            LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                            LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                        }
                    }
                }
                keymanagers = AuthSSLProtocolSocketFactory.createKeyManagers(keystore, this.keystorePassword);
            }
            if (this.truststoreUrl != null) {
                keystore = AuthSSLProtocolSocketFactory.createKeyStore(this.truststoreUrl, this.truststorePassword);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        LOG.debug((Object)("Trusted certificate '" + alias + "':"));
                        Certificate trustedcert = keystore.getCertificate(alias);
                        if (trustedcert == null || !(trustedcert instanceof X509Certificate)) continue;
                        X509Certificate cert = (X509Certificate)trustedcert;
                        LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                        LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                        LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                        LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                        LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                    }
                }
                trustmanagers = AuthSSLProtocolSocketFactory.createTrustManagers(keystore);
            }
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(keymanagers, trustmanagers, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

