/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.bueller;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AuthSSLX509TrustManager
implements TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private static final Log LOG = LogFactory.getLog(AuthSSLX509TrustManager.class);

    public AuthSSLX509TrustManager(X509TrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (LOG.isInfoEnabled() && certificates != null) {
            for (int c = 0; c < certificates.length; ++c) {
                X509Certificate cert = certificates[c];
                LOG.info((Object)(" Client certificate " + (c + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.info((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.info((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        this.defaultTrustManager.checkClientTrusted(certificates, authType);
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (LOG.isInfoEnabled() && certificates != null) {
            for (int c = 0; c < certificates.length; ++c) {
                X509Certificate cert = certificates[c];
                LOG.info((Object)(" Server certificate " + (c + 1) + ":"));
                LOG.info((Object)("  Subject DN: " + cert.getSubjectDN()));
                LOG.info((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                LOG.info((Object)("  Valid from: " + cert.getNotBefore()));
                LOG.info((Object)("  Valid until: " + cert.getNotAfter()));
                LOG.info((Object)("  Issuer: " + cert.getIssuerDN()));
            }
        }
        this.defaultTrustManager.checkServerTrusted(certificates, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

