/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.bueller;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransportAuthenticationStyle;
import org.miloss.fgsms.sla.AuxHelper;
import org.miloss.fgsms.sla.SLACommon;

public class Bueller {
    protected static final Logger log = Logger.getLogger((String)"fgsms.StatusBueller");
    public static boolean running = true;
    public static boolean noloop = false;
    private static String truststore = "";
    private static String truststorepass = "";
    private static String keystore = "";
    private static String keystorepass = "";
    private static long LastConfiguredAt = 0L;
    private static boolean Configured = false;
    private static boolean ignoreSSL = false;
    private static SSLSocketFactory sf = null;
    private static SSLSocketFactory sfpki = null;
    private boolean done = false;
    private File file;
    private FileChannel channel;
    private FileLock lock;

    public static void main(String[] args) throws InterruptedException {
        new Bueller().Main(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> GetAlternateUrls(String url, Connection perf) {
        ArrayList<String> alts;
        block6: {
            alts = new ArrayList<String>();
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                com = perf.prepareStatement("select  alturi from alternateurls where uri=?;");
                com.setString(1, url);
                rs = com.executeQuery();
                while (rs.next()) {
                    String t = rs.getString(1);
                    if (Utility.stringIsNullOrEmpty((String)t) || Utility.stringIsNullOrEmpty((String)(t = t.trim())) || t.equals(url) || url.equals(t)) continue;
                    alts.add(t);
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, null, (Throwable)ex);
                break block6;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)com);
            }
            DBUtils.safeClose((PreparedStatement)com);
        }
        return alts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> GetAlternateUrls(String url, boolean pooled) {
        Connection perf = null;
        perf = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
        List<String> ret = Collections.EMPTY_LIST;
        try {
            ret = Bueller.GetAlternateUrls(url, perf);
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((Connection)perf);
        }
        return ret;
    }

    private void closeLock() {
        try {
            this.lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this.file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanUpOldStuff(List<String> MonitoredURLS, Connection con) {
        long timer = System.currentTimeMillis();
        int x = 0;
        try {
            PreparedStatement cmd = con.prepareStatement("delete from status where uri=(select status.uri from status  left outer join  servicepolicies  on (status.uri = servicepolicies.uri) where xmlpolicy is null)");
            x = cmd.executeUpdate();
        }
        catch (SQLException ex) {
            log.log((Priority)Level.WARN, null, (Throwable)ex);
        }
        if (x > 0) {
            log.log((Priority)Level.INFO, (Object)("Purging " + x + " from status table"));
        }
        log.log((Priority)Level.INFO, (Object)("Bueller cleanup performed in " + (System.currentTimeMillis() - timer) + "ms"));
    }

    public void run() {
        this.Main(null);
    }

    private String doJmsURL(boolean pooled, String endpoint) {
        block12: {
            try {
                boolean ok = false;
                String server = endpoint.split("#")[0];
                server = server.replace("jms:", "jnp://");
                String name = endpoint.split("#")[1];
                String msg = "";
                String[] info = DBSettingsLoader.GetCredentials((boolean)pooled, (String)endpoint);
                String username = null;
                String password = null;
                if (info != null) {
                    username = info[0];
                    password = info[1];
                } else {
                    info = DBSettingsLoader.GetDefaultBuellerCredentials((boolean)pooled);
                    if (info != null) {
                        username = info[0];
                        password = info[1];
                    }
                }
                if (name.startsWith("topic")) {
                    try {
                        Properties properties1 = new Properties();
                        properties1.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                        properties1.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                        properties1.put("java.naming.provider.url", server);
                        InitialContext iniCtx = new InitialContext(properties1);
                        TopicConnectionFactory tcf = (TopicConnectionFactory)iniCtx.lookup("TopicConnectionFactory");
                        TopicConnection createTopicConnection = null;
                        createTopicConnection = info != null ? tcf.createTopicConnection(username, Utility.DE((String)password)) : tcf.createTopicConnection();
                        createTopicConnection.start();
                        createTopicConnection.stop();
                        createTopicConnection.close();
                        ok = true;
                        iniCtx.close();
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                        msg = ex.getLocalizedMessage();
                    }
                    break block12;
                }
                if (name.startsWith("queue")) {
                    try {
                        Properties properties1 = new Properties();
                        properties1.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                        properties1.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                        properties1.put("java.naming.provider.url", server);
                        InitialContext iniCtx = new InitialContext(properties1);
                        Object tmp = iniCtx.lookup("ConnectionFactory");
                        QueueConnectionFactory qcf = (QueueConnectionFactory)tmp;
                        QueueConnection conn = info != null ? qcf.createQueueConnection(username, Utility.DE((String)password)) : qcf.createQueueConnection();
                        Queue que = (Queue)iniCtx.lookup(name);
                        QueueSession session = conn.createQueueSession(false, 1);
                        conn.start();
                        ok = true;
                        conn.stop();
                        session.close();
                        iniCtx.close();
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.WARN, (Object)"Could not bind to jms queue", (Throwable)ex);
                        msg = ex.getLocalizedMessage();
                    }
                    if (ok) {
                        return "OK";
                    }
                    return "Unable to bind to JMS queue: " + msg;
                }
                return "Unsupported Protocol";
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)("service " + endpoint + " is offline or an error occured"), (Throwable)ex);
                return "Offline " + ex.getLocalizedMessage();
            }
        }
        return "undeterminable";
    }

    private void Main(String[] args) {
        try {
            this.file = new File("bueller.lck");
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            this.lock = this.channel.tryLock();
        }
        catch (Exception e) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file bueller.lck needs to be deleted.");
            return;
        }
        if (this.lock == null) {
            this.closeLock();
            System.out.println("Could not obtain the lock, this means that either this program is already running or something went wrong and the file bueller.lck needs to be deleted.");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new RunWhenShuttingDown());
        PropertyConfigurator.configure((String)"log4j.properties");
        log.log((Priority)Level.INFO, (Object)"fgsms.Bueller (service ping machine) startup.....");
        long lastRanAt = 0L;
        int interval = 10000;
        if (args.length == 1 && args[0].equalsIgnoreCase("noloop")) {
            noloop = true;
        }
        while (running) {
            if (System.currentTimeMillis() - lastRanAt > (long)interval) {
                lastRanAt = System.currentTimeMillis();
                log.log((Priority)Level.INFO, (Object)"Bueller.....");
                try {
                    this.Fire(false);
                    AuxHelper.TryUpdateStatus((boolean)true, (String)("urn:fgsms:Bueller:" + Utility.getHostName()), (String)("OK, took " + (System.currentTimeMillis() - lastRanAt) + "ms to process."), (boolean)false, (String)"unspecified", (String)SLACommon.GetHostName());
                }
                catch (Exception ex) {
                    AuxHelper.TryUpdateStatus((boolean)false, (String)("urn:fgsms:Bueller:" + Utility.getHostName()), (String)("Running but possible database error" + (System.currentTimeMillis() - lastRanAt) + "ms to process."), (boolean)false, (String)"unspecified", (String)SLACommon.GetHostName());
                }
                log.log((Priority)Level.INFO, (Object)("Pausing until the next iteration in " + interval + "ms....."));
            }
            if (noloop) {
                running = false;
            }
            if (!running) continue;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                log.log((Priority)Level.FATAL, null, (Throwable)ex);
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Init(boolean pooled) throws Exception {
        String os;
        if (System.currentTimeMillis() - 30000L < LastConfiguredAt && Configured) {
            log.log((Priority)Level.DEBUG, (Object)"already configured, using last known config");
            return;
        }
        log.log((Priority)Level.INFO, (Object)"Refreshing configuration");
        LastConfiguredAt = System.currentTimeMillis();
        Configured = true;
        String tmp = System.getProperty("jboss.server.config.url");
        if (Utility.stringIsNullOrEmpty((String)tmp)) {
            try {
                tmp = System.getProperty("jboss.server.config.dir");
                if (tmp != null && !tmp.equalsIgnoreCase("null")) {
                    File f = new File(tmp);
                    tmp = f.toURI().toURL().toString();
                    tmp = tmp + File.separator;
                }
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        if (Utility.stringIsNullOrEmpty((String)tmp) && (tmp = System.getProperty("catalina.home")) != null) {
            tmp = tmp + File.separator + "conf" + File.separator;
        }
        if (tmp != null && (os = System.getProperty("os.name")).toLowerCase().indexOf("win") == -1) {
            tmp = File.separator + tmp;
        }
        StrictHostnameVerifier hostnameVerifier = new StrictHostnameVerifier();
        KeyNameValueEnc d = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"Bueller", (String)"IgnoreSSLErrors");
        if (d != null && d.getKeyNameValue() != null) {
            try {
                ignoreSSL = Boolean.parseBoolean(d.getKeyNameValue().getPropertyValue());
            }
            catch (Exception ex) {
                ignoreSSL = false;
            }
        }
        if (ignoreSSL) {
            log.log((Priority)Level.WARN, (Object)"SSL Hostname verification turned off");
            hostnameVerifier = new AllowAllHostnameVerifier();
        }
        if (!Utility.stringIsNullOrEmpty((String)tmp)) {
            d = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"defaults", (String)"truststore");
            if (d != null && d.getKeyNameValue() != null) {
                truststore = tmp + d.getKeyNameValue().getPropertyValue();
            }
            if ((d = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"defaults", (String)"truststorepass")) != null && d.getKeyNameValue() != null) {
                truststorepass = d.getKeyNameValue().getPropertyValue();
            }
            if ((d = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"defaults", (String)"keystore")) != null && d.getKeyNameValue() != null) {
                keystore = tmp + d.getKeyNameValue().getPropertyValue();
            }
            if ((d = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"defaults", (String)"keystorepass")) != null && d.getKeyNameValue() != null) {
                keystorepass = d.getKeyNameValue().getPropertyValue();
            }
            if (!(Utility.stringIsNullOrEmpty((String)truststore) && !Utility.stringIsNullOrEmpty((String)truststorepass) || Utility.stringIsNullOrEmpty((String)keystore) || Utility.stringIsNullOrEmpty((String)keystorepass))) {
                KeyStore trustStore = null;
                FileInputStream instream = null;
                try {
                    log.log((Priority)Level.INFO, (Object)("loading trust store from " + truststore));
                    instream = new FileInputStream(new File(truststore.replace("file:/", "")));
                    trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(instream, Utility.DE((String)truststorepass).toCharArray());
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    trustStore = null;
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                        }
                    }
                }
                KeyStore keyStore = null;
                try {
                    log.log((Priority)Level.INFO, (Object)("loading key store from " + keystore));
                    instream = new FileInputStream(new File(keystore.replace("file:/", "")));
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(instream, Utility.DE((String)keystorepass).toCharArray());
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    keyStore = null;
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                        }
                    }
                }
                if (trustStore != null && keyStore != null) {
                    sfpki = new SSLSocketFactory("TLS", keyStore, Utility.DE((String)keystorepass), trustStore, new SecureRandom(), (X509HostnameVerifier)hostnameVerifier);
                } else if (trustStore != null) {
                    sf = new SSLSocketFactory(trustStore, Utility.DE((String)truststorepass));
                }
            } else if (!Utility.stringIsNullOrEmpty((String)truststore) || Utility.stringIsNullOrEmpty((String)truststorepass)) {
                KeyStore trustStore = null;
                FileInputStream instream = new FileInputStream(new File(truststore.replace("file:/", "")));
                try {
                    log.log((Priority)Level.INFO, (Object)("loading trust store from " + truststore));
                    trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(instream, Utility.DE((String)truststorepass).toCharArray());
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, null, (Throwable)ex);
                    trustStore = null;
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (Exception ex) {
                            log.log((Priority)Level.DEBUG, null, (Throwable)ex);
                        }
                    }
                }
                if (trustStore != null) {
                    sf = new SSLSocketFactory(trustStore, Utility.DE((String)truststorepass));
                    sf.setHostnameVerifier((X509HostnameVerifier)hostnameVerifier);
                }
            }
        } else {
            log.log((Priority)Level.WARN, (Object)"unable to determine the location to the key/trust stores because the environment variable jboss.server.config.url, jboss.server.config.dir and catalina.home are not defined. At least one must be set for SSL to function");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Fire(boolean pooled) throws SQLException, Exception {
        ArrayList<String> urls;
        Connection perf;
        Connection con;
        block26: {
            ResultSet rs;
            PreparedStatement com;
            block25: {
                block24: {
                    this.Init(pooled);
                    con = null;
                    perf = null;
                    if (pooled) {
                        con = Utility.getConfigurationDBConnection();
                        perf = Utility.getPerformanceDBConnection();
                    } else {
                        con = Utility.getConfigurationDB_NONPOOLED_Connection();
                        perf = Utility.getPerformanceDB_NONPOOLED_Connection();
                    }
                    com = null;
                    rs = null;
                    urls = new ArrayList<String>();
                    try {
                        boolean run = true;
                        KeyNameValueEnc GetPropertiesFromDB = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"Bueller", (String)"Enabled");
                        if (GetPropertiesFromDB != null && GetPropertiesFromDB.getKeyNameValue() != null) {
                            try {
                                run = Boolean.parseBoolean(GetPropertiesFromDB.getKeyNameValue().getPropertyValue());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (!run) {
                            log.log((Priority)Level.INFO, (Object)"Bueller is disabled by General Settings, key=Bueller, name=Enabled, exiting...");
                            con.close();
                            perf.close();
                            DBUtils.safeClose(rs);
                            break block24;
                        }
                        com = con.prepareStatement("select uri from servicepolicies where buellerenabled=true and policytype=?; ");
                        com.setInt(1, PolicyType.TRANSACTIONAL.ordinal());
                        rs = com.executeQuery();
                        while (rs.next()) {
                            urls.add(rs.getString(1));
                        }
                        rs.close();
                        com.close();
                        DBUtils.safeClose((ResultSet)rs);
                        break block25;
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.ERROR, (Object)"unexpected error running bueller ", (Throwable)ex);
                        break block26;
                    }
                }
                DBUtils.safeClose((PreparedStatement)com);
                return;
            }
            DBUtils.safeClose((PreparedStatement)com);
            break block26;
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
            }
        }
        try {
            log.log((Priority)Level.INFO, (Object)(urls.size() + " urls to process"));
            for (int i = 0; i < urls.size(); ++i) {
                if (!running) {
                    log.log((Priority)Level.INFO, (Object)("Interupt detected on url " + (i + 1) + " of " + urls.size()));
                    break;
                }
                try {
                    String s = this.sendGetRequest(pooled, (String)urls.get(i), 0);
                    Boolean currenstatus = s.equalsIgnoreCase("ok");
                    log.log((Priority)Level.INFO, (Object)(i + 1 + "/" + urls.size() + " " + (String)urls.get(i) + " status is " + s));
                    if (!currenstatus.booleanValue()) {
                        List<String> alts = Bueller.GetAlternateUrls((String)urls.get(i), perf);
                        for (int k = 0; k < alts.size() && !currenstatus.booleanValue(); ++k) {
                            s = this.sendGetRequest(pooled, alts.get(k), 0);
                            currenstatus = s.equalsIgnoreCase("ok");
                            log.log((Priority)Level.INFO, (Object)((String)urls.get(i) + " via alternate URL " + alts.get(k) + " status is " + s));
                        }
                    }
                    AuxHelper.TryUpdateStatus((boolean)currenstatus, (String)((String)urls.get(i)), (String)s, (boolean)pooled, (String)"unspecified", (String)SLACommon.GetHostName(), (AuxHelper.FLAGS)AuxHelper.FLAGS.NO_AUTO_CREATE);
                    continue;
                }
                catch (Exception ex) {
                    log.log((Priority)Level.ERROR, (Object)("error setting status in config db for uri " + (String)urls.get(i)), (Throwable)ex);
                }
            }
            this.cleanUpOldStuff(urls, con);
            return;
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, (Object)"unexpected error running bueller ", (Throwable)ex);
            return;
        }
        finally {
            DBUtils.safeClose((Connection)con);
            DBUtils.safeClose((Connection)perf);
        }
    }

    protected Credentials transformCredentials(String[] info) {
        if (info.length == 2) {
            return new UsernamePasswordCredentials(info[0], Utility.DE((String)info[1]));
        }
        if (info.length == 3) {
            TransportAuthenticationStyle tas = TransportAuthenticationStyle.valueOf((String)info[2]);
            switch (tas) {
                case HTTP_NTLM: {
                    String data = info[0];
                    String[] t = data.split("\\\\");
                    String username = t[1];
                    String domain = t[0];
                    return new NTCredentials(username, Utility.DE((String)info[1]), SLACommon.GetHostName(), domain);
                }
            }
            return new UsernamePasswordCredentials(info[0], Utility.DE((String)info[1]));
        }
        return null;
    }

    protected String sendGetRequestAuth(boolean pooled, String endpoint, String policyURL, int depth) {
        if (depth > 10) {
            return "Aborting due to redirect loop";
        }
        String[] info = DBSettingsLoader.GetCredentials((boolean)pooled, (String)policyURL);
        if (info == null && (info = DBSettingsLoader.GetDefaultBuellerCredentials((boolean)pooled)) == null) {
            return "Unauthorized, no credentials are available";
        }
        if (endpoint.startsWith("http://")) {
            DefaultHttpClient c = new DefaultHttpClient();
            try {
                c.getCredentialsProvider().setCredentials(AuthScope.ANY, this.transformCredentials(info));
                if (!c.getCredentialsProvider().getCredentials(AuthScope.ANY).getClass().getCanonicalName().equalsIgnoreCase(NTCredentials.class.getCanonicalName())) {
                    log.log((Priority)Level.WARN, (Object)"Usage of non-NTLM authentication over a non SSL channel.");
                }
                HttpGet m = new HttpGet(endpoint);
                CloseableHttpResponse res = c.execute((HttpUriRequest)m);
                int status = res.getStatusLine().getStatusCode();
                try {
                    InputStream content = res.getEntity().getContent();
                    byte[] buffer = new byte[1024];
                    while (content.read(buffer) >= 0) {
                    }
                }
                catch (Exception content) {
                    // empty catch block
                }
                c.getConnectionManager().shutdown();
                if (status < 300 || status == 304) {
                    return "OK";
                }
                if (status == 301 || status == 307 || status == 302) {
                    String newUrl = res.getHeaders("Location")[0].getValue();
                    return this.sendGetRequestAuth(pooled, newUrl, policyURL, depth + 1);
                }
                return String.valueOf(status);
            }
            catch (Exception ex) {
                c.getConnectionManager().shutdown();
                log.log((Priority)Level.INFO, (Object)("code " + ex.getLocalizedMessage()));
                return "offline: " + ex.getMessage();
            }
        }
        if (endpoint.startsWith("https://")) {
            if (sf == null && sfpki == null) {
                return "Unauthorized, no trust store available for SSL communication";
            }
            DefaultHttpClient c = new DefaultHttpClient();
            try {
                URL url = new URL(endpoint);
                String scheme = "https";
                int port = url.getPort();
                if (port == -1 && endpoint.toLowerCase().startsWith("https:")) {
                    port = 443;
                }
                Scheme sch = null;
                sch = sfpki == null ? new Scheme("https", port, (SchemeSocketFactory)sf) : new Scheme("https", port, (SchemeSocketFactory)sfpki);
                c.getConnectionManager().getSchemeRegistry().register(sch);
                c.getCredentialsProvider().setCredentials(AuthScope.ANY, this.transformCredentials(info));
                HttpGet m = new HttpGet(endpoint);
                CloseableHttpResponse res = c.execute((HttpUriRequest)m);
                int status = res.getStatusLine().getStatusCode();
                try {
                    InputStream content = res.getEntity().getContent();
                    byte[] buffer = new byte[1024];
                    while (content.read(buffer) >= 0) {
                    }
                }
                catch (Exception content) {
                    // empty catch block
                }
                c.getConnectionManager().shutdown();
                if (status < 300 || status == 304) {
                    return "OK";
                }
                if (status == 301 || status == 307 || status == 302) {
                    String newUrl = res.getHeaders("Location")[0].getValue();
                    return this.sendGetRequestAuth(pooled, newUrl, policyURL, depth + 1);
                }
                return String.valueOf(status);
            }
            catch (Exception ex) {
                c.getConnectionManager().shutdown();
                log.log((Priority)Level.INFO, (Object)("code " + ex.getLocalizedMessage()));
                return "offline: " + ex.getMessage();
            }
        }
        return "undeterminable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String sendGetRequest(boolean pooled, String endpoint, int depth) {
        if (depth > 10) {
            return "Aborting due to redirect loop";
        }
        Object result = null;
        String policyUrl = new String(endpoint);
        if (endpoint.startsWith("http://")) {
            HttpURLConnection conn = null;
            try {
                String originalendpoint = endpoint;
                if (!endpoint.endsWith("?wsdl")) {
                    endpoint = endpoint + "?wsdl";
                }
                if ((conn = (HttpURLConnection)new URL(endpoint).openConnection()).getResponseCode() == 401) {
                    String string = this.sendGetRequestAuth(pooled, endpoint, policyUrl, depth + 1);
                    return string;
                }
                if (conn.getResponseCode() == 404) {
                    conn = (HttpURLConnection)new URL(originalendpoint).openConnection();
                    String string = "Not found";
                    return string;
                }
                if (conn.getResponseCode() == 301 || conn.getResponseCode() == 302 || conn.getResponseCode() == 307) {
                    String newUrl = conn.getHeaderField("Location");
                    String string = this.sendGetRequest(pooled, newUrl, depth + 1);
                    return string;
                }
                if (conn.getResponseCode() == 304) {
                    String newUrl = "OK";
                    return newUrl;
                }
                InputStream inputStream = null;
                try {
                    inputStream = conn.getInputStream();
                    byte[] buffer = new byte[1024];
                    while (inputStream.read(buffer) >= 0) {
                    }
                    inputStream.close();
                }
                catch (Exception buffer) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception buffer) {}
                    }
                }
                String msg = conn.getResponseMessage();
                conn.disconnect();
                String string = msg;
                return string;
            }
            catch (UnknownHostException ex) {
                String inputStream = "Host unknown";
                return inputStream;
            }
            catch (Exception ex) {
                String inputStream = ex.getMessage();
                return inputStream;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (Exception msg) {}
                }
            }
        }
        if (!endpoint.startsWith("https://")) {
            if (!endpoint.startsWith("jms:")) return "Unknown protocol";
            return this.doJmsURL(pooled, endpoint);
        }
        if (!endpoint.endsWith("?wsdl")) {
            endpoint = endpoint + "?wsdl";
        }
        DefaultHttpClient c = new DefaultHttpClient();
        try {
            URL url = new URL(endpoint);
            int port = url.getPort();
            if (port == -1 && endpoint.toLowerCase().startsWith("http:")) {
                port = 80;
            }
            if (port == -1 && endpoint.toLowerCase().startsWith("https:")) {
                port = 443;
            }
            Scheme sch = null;
            sch = sfpki == null ? new Scheme("https", port, (SchemeSocketFactory)sf) : new Scheme("https", port, (SchemeSocketFactory)sfpki);
            if (endpoint.toLowerCase().startsWith("https:")) {
                c.getConnectionManager().getSchemeRegistry().register(sch);
            }
            HttpGet m = new HttpGet(endpoint);
            CloseableHttpResponse res = c.execute((HttpUriRequest)m);
            int status = res.getStatusLine().getStatusCode();
            try {
                InputStream content = res.getEntity().getContent();
                byte[] buffer = new byte[1024];
                while (content.read(buffer) >= 0) {
                }
            }
            catch (Exception content) {
                // empty catch block
            }
            c.getConnectionManager().shutdown();
            if (status == 401) {
                return this.sendGetRequestAuth(pooled, endpoint, policyUrl, depth + 1);
            }
            if (status == 301 || status == 302 || status == 307) {
                String newUrl = res.getHeaders("Location")[0].getValue();
                return this.sendGetRequest(pooled, newUrl, depth + 1);
            }
            if (status == 304) {
                return "OK";
            }
            if (status >= 300) return "offline";
            return "OK";
        }
        catch (Exception ex) {
            c.getConnectionManager().shutdown();
            log.log((Priority)Level.WARN, (Object)("error caught connecting to " + endpoint), (Throwable)ex);
            return ex.getMessage();
        }
    }

    public class RunWhenShuttingDown
    extends Thread {
        @Override
        public void run() {
            System.out.println("Control-C caught. Shutting down...");
            running = false;
            while (!Bueller.this.done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Bueller.this.closeLock();
            Bueller.this.deleteFile();
            if (!noloop) {
                AuxHelper.TryUpdateStatus((boolean)false, (String)("urn:fgsms:Bueller:" + Utility.getHostName()), (String)"Stopped", (boolean)false, (String)"unspecified", (String)SLACommon.GetHostName());
            }
        }
    }
}

