/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auth;

import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class PKIRequestWrapper
extends HttpServletRequestWrapper {
    List<String> roles = null;
    HttpServletRequest realRequest;
    String user = null;

    public PKIRequestWrapper(String user, List<String> roles, HttpServletRequest request) {
        super(request);
        this.user = user;
        this.roles = roles;
        this.realRequest = request;
    }

    public String getAuthType() {
        return "CLIENT-CERT";
    }

    public boolean isUserInRole(String role) {
        if (this.roles == null) {
            return this.realRequest.isUserInRole(role);
        }
        return this.roles.contains(role);
    }

    public Principal getUserPrincipal() {
        if (this.user == null) {
            return this.realRequest.getUserPrincipal();
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

