/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auth.PKIRequestWrapper;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;

public class PKI_LoginFilter
implements Filter {
    private static final Logger log = Logger.getLogger((String)"fgsms.Auth");
    private Constants.AuthMode mode = Constants.AuthMode.PKI;
    private List<X500Principal> authorizedDelegateCertifiations = new ArrayList();

    public void init(FilterConfig fc) throws ServletException {
        String s = fc.getInitParameter("AuthorizedDelegates");
        if (Utility.stringIsNullOrEmpty((String)s)) {
            log.log((Priority)Level.WARN, (Object)"When configuring CAC/PKI authentication for fgsms, it is required for the web interface for the web gui's server certificate to be specified as an init param for this filter. Authenticaiton requests from the GUI will not be impresonated correctly.");
        }
        String[] pkis = s.split("\\|");
        for (int i = 0; i < pkis.length; ++i) {
            this.authorizedDelegateCertifiations.add(new X500Principal(pkis[i]));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.mode == Constants.AuthMode.PKI) {
            boolean authorized = false;
            String cert = "";
            if (request instanceof HttpServletRequest) {
                HttpServletRequest r = (HttpServletRequest)request;
                String url = r.getRequestURI();
                HttpSession session = ((HttpServletRequest)request).getSession(true);
                if (session != null) {
                    String header = r.getHeader("fgsms.authorization");
                    if (Utility.stringIsNullOrEmpty((String)header)) {
                        cert = r.getUserPrincipal().getName();
                    } else {
                        for (int i = 0; i < this.authorizedDelegateCertifiations.size(); ++i) {
                            if (!((X500Principal)this.authorizedDelegateCertifiations.get(i)).getName().equalsIgnoreCase(new X500Principal(r.getUserPrincipal().getName()).getName())) continue;
                            cert = header;
                            break;
                        }
                    }
                    authorized = true;
                }
                if (authorized) {
                    ArrayList<String> roles = new ArrayList<String>();
                    roles.add("everyone");
                    PKIRequestWrapper wrap = new PKIRequestWrapper(cert, roles, r);
                    chain.doFilter((ServletRequest)wrap, response);
                    return;
                }
                ((HttpServletResponse)response).sendError(404);
                return;
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

