/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.auxsrv;

import java.util.Date;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.auxsrv.AuxConstants;
import org.miloss.fgsms.auxsrv.BuellerScheduler;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BuellerStarter
implements ServletContextListener {
    public static final String JOB_NAME = "Status Bueller";
    public static final String TRIGGER_NAME = "Status BuellerTrigger";
    private static Scheduler sc;
    static Logger log;

    public void contextInitialized(ServletContextEvent sce) {
        BuellerStarter.StartupCheck();
    }

    protected static void StartupCheck() {
        block7: {
            JobDetail job = null;
            Trigger triger = null;
            try {
                sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
                if (AuxConstants.QuartzJobExists((String)"Status Bueller", (Scheduler)sc)) break block7;
                KeyNameValueEnc interval = DBSettingsLoader.GetPropertiesFromDB((boolean)true, (String)"Bueller", (String)"Interval");
                long intinterval = 30000L;
                if (interval != null) {
                    try {
                        intinterval = Long.parseLong(interval.getKeyNameValue().getPropertyValue());
                        if (intinterval < 1000L) {
                            intinterval = 30000L;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                job = new JobDetail("Status Bueller", "fgsms Aux Services", BuellerScheduler.class);
                triger = TriggerUtils.makeSecondlyTrigger((int)((int)intinterval / 1000));
                triger.setStartTime(new Date());
                triger.setName("Status BuellerTrigger");
                triger.setGroup("fgsmsAuxServicesTriggers");
                job.setRequestsRecovery(true);
                sc.scheduleJob(job, triger);
                log.log((Priority)Level.INFO, (Object)("Status Bueller job scheduled at " + intinterval + " ms"));
                if (sc.isShutdown()) {
                    log.log((Priority)Level.WARN, (Object)"starting quartz");
                    sc.start();
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.WARN, (Object)"error scheduling bueller", (Throwable)ex);
            }
        }
    }

    protected static void Unschedule() {
        try {
            Scheduler sc = new StdSchedulerFactory().getScheduler("fgsmsAuxServicesQuartzScheduler");
            sc.deleteJob("Status Bueller", "fgsms Aux Services");
        }
        catch (Exception ex) {
            log.log((Priority)Level.DEBUG, (Object)"Unscheduling Status Bueller failed.", (Throwable)ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    static {
        log = Logger.getLogger((String)"fgsms.Aux");
    }
}

